/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.platform.spigot;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.bukkit.command.CommandSender;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.platform.spigot.shaded.net.kyori.adventure.text.Component;
import org.geysermc.mcprotocollib.protocol.data.DefaultComponentSerializer;

public final class PaperAdventure {
    private static final MethodHandle NATIVE_GSON_COMPONENT_SERIALIZER_DESERIALIZE_METHOD_BOUND;
    private static final Method SEND_MESSAGE_COMPONENT;

    public static @Nullable Object toNativeComponent(Component component) {
        if (NATIVE_GSON_COMPONENT_SERIALIZER_DESERIALIZE_METHOD_BOUND == null) {
            GeyserImpl.getInstance().getLogger().error("Illegal state where Component serialization was called when it wasn't available!");
            return null;
        }
        try {
            return NATIVE_GSON_COMPONENT_SERIALIZER_DESERIALIZE_METHOD_BOUND.invoke((String)DefaultComponentSerializer.get().serialize(component));
        }
        catch (Throwable throwable) {
            GeyserImpl.getInstance().getLogger().error("Failed to create native Component message", throwable);
            return null;
        }
    }

    public static void sendMessage(CommandSender sender, Component component) {
        if (SEND_MESSAGE_COMPONENT == null) {
            GeyserImpl.getInstance().getLogger().error("Illegal state where Component sendMessage was called when it wasn't available!");
            return;
        }
        Object nativeComponent = PaperAdventure.toNativeComponent(component);
        if (nativeComponent != null) {
            try {
                SEND_MESSAGE_COMPONENT.invoke((Object)sender, nativeComponent);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                GeyserImpl.getInstance().getLogger().error("Failed to send native Component message", e);
            }
        }
    }

    public static boolean canSendMessageUsingComponent() {
        return SEND_MESSAGE_COMPONENT != null;
    }

    private static @Nullable Class<?> findClass(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private PaperAdventure() {
    }

    static {
        Method playerComponentSendMessage;
        block11: {
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            MethodHandle nativeGsonComponentSerializerDeserializeMethodBound = null;
            Class<?> nativeGsonComponentSerializerClass = PaperAdventure.findClass(String.join((CharSequence)".", "net", "kyori", "adventure", "text", "serializer", "gson", "GsonComponentSerializer"));
            Class<?> nativeGsonComponentSerializerImplClass = PaperAdventure.findClass(String.join((CharSequence)".", "net", "kyori", "adventure", "text", "serializer", "gson", "GsonComponentSerializerImpl"));
            if (nativeGsonComponentSerializerClass != null && nativeGsonComponentSerializerImplClass != null) {
                MethodHandle nativeGsonComponentSerializerGsonGetter = null;
                try {
                    nativeGsonComponentSerializerGsonGetter = lookup.findStatic(nativeGsonComponentSerializerClass, "gson", MethodType.methodType(nativeGsonComponentSerializerClass));
                }
                catch (IllegalAccessException | NoSuchMethodException reflectiveOperationException) {
                    // empty catch block
                }
                MethodHandle nativeGsonComponentSerializerDeserializeMethod = null;
                try {
                    Method method = nativeGsonComponentSerializerImplClass.getDeclaredMethod("deserialize", String.class);
                    method.setAccessible(true);
                    nativeGsonComponentSerializerDeserializeMethod = lookup.unreflect(method);
                }
                catch (IllegalAccessException | NoSuchMethodException method) {
                    // empty catch block
                }
                if (nativeGsonComponentSerializerGsonGetter != null && nativeGsonComponentSerializerDeserializeMethod != null) {
                    try {
                        nativeGsonComponentSerializerDeserializeMethodBound = nativeGsonComponentSerializerDeserializeMethod.bindTo(nativeGsonComponentSerializerGsonGetter.invoke());
                    }
                    catch (Throwable throwable) {
                        GeyserImpl.getInstance().getLogger().error("Failed to access native GsonComponentSerializer", throwable);
                    }
                }
            }
            NATIVE_GSON_COMPONENT_SERIALIZER_DESERIALIZE_METHOD_BOUND = nativeGsonComponentSerializerDeserializeMethodBound;
            playerComponentSendMessage = null;
            Class<?> nativeComponentClass = PaperAdventure.findClass(String.join((CharSequence)".", "net", "kyori", "adventure", "text", "Component"));
            if (nativeComponentClass != null) {
                try {
                    playerComponentSendMessage = CommandSender.class.getMethod("sendMessage", nativeComponentClass);
                }
                catch (NoSuchMethodException e) {
                    if (!GeyserImpl.getInstance().getLogger().isDebug()) break block11;
                    e.printStackTrace();
                }
            }
        }
        SEND_MESSAGE_COMPONENT = playerComponentSendMessage;
    }
}

