/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.scoreboard.display.slot;

import java.util.List;
import org.cloudburstmc.nbt.NbtMapBuilder;
import org.cloudburstmc.protocol.bedrock.data.ScoreInfo;
import org.geysermc.geyser.entity.type.player.PlayerEntity;
import org.geysermc.geyser.platform.spigot.shaded.it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import org.geysermc.geyser.platform.spigot.shaded.it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import org.geysermc.geyser.scoreboard.Objective;
import org.geysermc.geyser.scoreboard.ScoreReference;
import org.geysermc.geyser.scoreboard.UpdateType;
import org.geysermc.geyser.scoreboard.display.score.BelownameDisplayScore;
import org.geysermc.geyser.scoreboard.display.slot.DisplaySlot;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.translator.text.MessageTranslator;
import org.geysermc.mcprotocollib.protocol.codec.NbtComponentSerializer;
import org.geysermc.mcprotocollib.protocol.data.game.chat.numbers.BlankFormat;
import org.geysermc.mcprotocollib.protocol.data.game.chat.numbers.FixedFormat;
import org.geysermc.mcprotocollib.protocol.data.game.chat.numbers.NumberFormat;
import org.geysermc.mcprotocollib.protocol.data.game.chat.numbers.StyledFormat;
import org.geysermc.mcprotocollib.protocol.data.game.scoreboard.ScoreboardPosition;

public class BelownameDisplaySlot
extends DisplaySlot {
    private final Long2ObjectMap<BelownameDisplayScore> displayScores = new Long2ObjectOpenHashMap<BelownameDisplayScore>();

    public BelownameDisplaySlot(GeyserSession session, Objective objective) {
        super(session, objective, ScoreboardPosition.BELOW_NAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void render0(List<ScoreInfo> addScores, List<ScoreInfo> removeScores) {
        if (this.updateType == UpdateType.ADD) {
            this.session.getEntityCache().forEachPlayerEntity(this::playerRegistered);
            return;
        }
        if (this.updateType == UpdateType.UPDATE) {
            this.session.getEntityCache().forEachPlayerEntity(player -> this.setBelowNameText((PlayerEntity)player, this.scoreFor(player.getUsername())));
            this.updateType = UpdateType.NOTHING;
            return;
        }
        Long2ObjectMap<BelownameDisplayScore> long2ObjectMap = this.displayScores;
        synchronized (long2ObjectMap) {
            for (BelownameDisplayScore score : this.displayScores.values()) {
                if (!score.shouldUpdate()) continue;
                if (score.referenceRemoved()) {
                    this.clearBelowNameText(score.player());
                    continue;
                }
                score.markUpdated();
                this.setBelowNameText(score.player(), score.reference());
            }
        }
    }

    @Override
    public void remove() {
        this.updateType = UpdateType.REMOVE;
        this.session.getEntityCache().forEachPlayerEntity(this::clearBelowNameText);
    }

    @Override
    public void addScore(ScoreReference reference) {
        this.addDisplayScore(reference);
    }

    @Override
    public void playerRegistered(PlayerEntity player) {
        ScoreReference reference = this.scoreFor(player.getUsername());
        this.setBelowNameText(player, reference);
        if (reference != null) {
            this.addDisplayScore(player, reference).markUpdated();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void playerRemoved(PlayerEntity player) {
        Long2ObjectMap<BelownameDisplayScore> long2ObjectMap = this.displayScores;
        synchronized (long2ObjectMap) {
            this.displayScores.remove(player.getGeyserId());
        }
    }

    private void addDisplayScore(ScoreReference reference) {
        List<PlayerEntity> players = this.session.getEntityCache().getPlayersByName(reference.name());
        for (PlayerEntity player : players) {
            this.addDisplayScore(player, reference);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BelownameDisplayScore addDisplayScore(PlayerEntity player, ScoreReference reference) {
        BelownameDisplayScore score = new BelownameDisplayScore(this, this.objective.getScoreboard().nextId(), reference, player);
        Long2ObjectMap<BelownameDisplayScore> long2ObjectMap = this.displayScores;
        synchronized (long2ObjectMap) {
            this.displayScores.put(player.getGeyserId(), score);
        }
        return score;
    }

    private void setBelowNameText(PlayerEntity player, ScoreReference reference) {
        player.setBelowNameText(this.calculateBelowNameText(reference));
        player.updateBedrockMetadata();
    }

    private void clearBelowNameText(PlayerEntity player) {
        player.setBelowNameText(null);
        player.updateBedrockMetadata();
    }

    private String calculateBelowNameText(ScoreReference reference) {
        String numberString;
        NumberFormat numberFormat = null;
        int score = 0;
        if (reference != null) {
            score = reference.score();
            numberFormat = reference.numberFormat();
        }
        if (numberFormat == null) {
            numberFormat = this.objective.getNumberFormat();
        }
        if (numberFormat instanceof BlankFormat) {
            numberString = "";
        } else if (numberFormat instanceof FixedFormat) {
            FixedFormat fixedFormat = (FixedFormat)numberFormat;
            numberString = MessageTranslator.convertMessage(fixedFormat.getValue(), this.session.locale());
        } else if (numberFormat instanceof StyledFormat) {
            StyledFormat styledFormat = (StyledFormat)numberFormat;
            NbtMapBuilder styledAmount = styledFormat.getStyle().toBuilder();
            styledAmount.putString("text", String.valueOf(score));
            numberString = MessageTranslator.convertJsonMessage(NbtComponentSerializer.tagComponentToJson(styledAmount.build()).toString(), this.session.locale());
        } else {
            numberString = String.valueOf(score);
        }
        return numberString + " \u00a7r" + this.objective.getDisplayName();
    }

    private ScoreReference scoreFor(String username) {
        return this.objective.getScores().get(username);
    }
}

