/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.session.dialog.input;

import java.util.Optional;
import org.cloudburstmc.nbt.NbtMap;
import org.cloudburstmc.nbt.NbtMapBuilder;
import org.geysermc.cumulus.form.CustomForm;
import org.geysermc.cumulus.response.CustomFormResponse;
import org.geysermc.geyser.platform.spigot.shaded.net.kyori.adventure.key.Key;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.session.dialog.input.BooleanInput;
import org.geysermc.geyser.session.dialog.input.DialogInputParseException;
import org.geysermc.geyser.session.dialog.input.NumberRangeInput;
import org.geysermc.geyser.session.dialog.input.SingleOptionInput;
import org.geysermc.geyser.session.dialog.input.TextInput;
import org.geysermc.geyser.translator.text.MessageTranslator;
import org.geysermc.geyser.util.MinecraftKey;

public abstract class DialogInput<T> {
    protected final String key;
    protected final String label;

    protected DialogInput(GeyserSession session, NbtMap map) {
        this.key = map.getString("key");
        this.label = MessageTranslator.convertFromNullableNbtTag(session, map.get("label"));
    }

    public void addComponent(CustomForm.Builder builder) {
        this.addComponent(builder, Optional.empty());
    }

    public abstract void addComponent(CustomForm.Builder var1, Optional<T> var2);

    public abstract T read(CustomFormResponse var1) throws DialogInputParseException;

    public abstract String asSubstitution(T var1);

    public abstract void addToMap(NbtMapBuilder var1, T var2);

    public abstract T defaultValue();

    public static DialogInput<?> read(GeyserSession session, NbtMap tag) {
        Key type = MinecraftKey.key(tag.getString("type"));
        if (type.equals(BooleanInput.TYPE)) {
            return new BooleanInput(session, tag);
        }
        if (type.equals(NumberRangeInput.TYPE)) {
            return new NumberRangeInput(session, tag);
        }
        if (type.equals(SingleOptionInput.TYPE)) {
            return new SingleOptionInput(session, tag);
        }
        if (type.equals(TextInput.TYPE)) {
            return new TextInput(session, tag);
        }
        throw new UnsupportedOperationException("Unknown dialog input type " + String.valueOf(type));
    }
}

