/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.inventory.horse;

import java.util.Arrays;
import org.cloudburstmc.protocol.bedrock.data.inventory.ContainerSlotType;
import org.cloudburstmc.protocol.bedrock.data.inventory.ItemData;
import org.cloudburstmc.protocol.bedrock.data.inventory.itemstack.request.ItemStackRequestSlotData;
import org.cloudburstmc.protocol.bedrock.packet.InventoryContentPacket;
import org.geysermc.geyser.inventory.BedrockContainerSlot;
import org.geysermc.geyser.inventory.Container;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.translator.inventory.horse.AbstractHorseInventoryTranslator;

public abstract class ChestedHorseInventoryTranslator
extends AbstractHorseInventoryTranslator {
    private final int chestSize;
    private final int equipSlot;

    public ChestedHorseInventoryTranslator(int size, int equipSlot) {
        super(size);
        this.chestSize = size - 2;
        this.equipSlot = equipSlot;
    }

    @Override
    public int bedrockSlotToJava(ItemStackRequestSlotData slotInfoData) {
        if (slotInfoData.getContainerName().getContainer() == ContainerSlotType.HORSE_EQUIP) {
            return this.equipSlot;
        }
        if (slotInfoData.getContainerName().getContainer() == ContainerSlotType.LEVEL_ENTITY) {
            return slotInfoData.getSlot() + 1;
        }
        return super.bedrockSlotToJava(slotInfoData);
    }

    @Override
    public BedrockContainerSlot javaSlotToBedrockContainer(int slot, Container container) {
        if (slot == this.equipSlot) {
            return new BedrockContainerSlot(ContainerSlotType.HORSE_EQUIP, 0);
        }
        if (slot <= this.size - 1) {
            return new BedrockContainerSlot(ContainerSlotType.LEVEL_ENTITY, slot - 1);
        }
        return super.javaSlotToBedrockContainer(slot, container);
    }

    @Override
    public int javaSlotToBedrock(int slot) {
        if (slot == 0 && this.equipSlot == 0) {
            return 0;
        }
        if (slot <= this.size - 1) {
            return slot - 1;
        }
        return super.javaSlotToBedrock(slot);
    }

    @Override
    public void updateInventory(GeyserSession session, Container container) {
        ItemData[] bedrockItems = new ItemData[36];
        for (int i = 0; i < 36; ++i) {
            int offset = i < 9 ? 27 : -9;
            bedrockItems[i] = container.getItem(this.size + i + offset).getItemData(session);
        }
        InventoryContentPacket contentPacket = new InventoryContentPacket();
        contentPacket.setContainerId(0);
        contentPacket.setContents(Arrays.asList(bedrockItems));
        session.sendUpstreamPacket(contentPacket);
        ItemData[] horseItems = new ItemData[this.chestSize + 1];
        horseItems[0] = container.getItem(this.equipSlot).getItemData(session);
        for (int i = 1; i < horseItems.length; ++i) {
            horseItems[i] = container.getItem(i + 1).getItemData(session);
        }
        InventoryContentPacket horseContentsPacket = new InventoryContentPacket();
        horseContentsPacket.setContainerId(container.getBedrockId());
        horseContentsPacket.setContents(Arrays.asList(horseItems));
        session.sendUpstreamPacket(horseContentsPacket);
    }
}

