/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.protocol.java.scoreboard;

import org.geysermc.geyser.scoreboard.Objective;
import org.geysermc.geyser.scoreboard.Scoreboard;
import org.geysermc.geyser.scoreboard.ScoreboardUpdater;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.session.cache.WorldCache;
import org.geysermc.geyser.translator.protocol.PacketTranslator;
import org.geysermc.geyser.translator.protocol.Translator;
import org.geysermc.mcprotocollib.protocol.data.game.scoreboard.ObjectiveAction;
import org.geysermc.mcprotocollib.protocol.packet.ingame.clientbound.scoreboard.ClientboundSetObjectivePacket;

@Translator(packet=ClientboundSetObjectivePacket.class)
public class JavaSetObjectiveTranslator
extends PacketTranslator<ClientboundSetObjectivePacket> {
    @Override
    public void translate(GeyserSession session, ClientboundSetObjectivePacket packet) {
        WorldCache worldCache = session.getWorldCache();
        Scoreboard scoreboard = worldCache.getScoreboard();
        int pps = worldCache.increaseAndGetScoreboardPacketsPerSecond();
        Objective objective = packet.getAction() == ObjectiveAction.ADD ? scoreboard.registerNewObjective(packet.getName()) : scoreboard.getObjective(packet.getName());
        if (objective == null) {
            return;
        }
        switch (packet.getAction()) {
            case ADD: 
            case UPDATE: {
                objective.updateProperties(packet.getDisplayName(), packet.getType(), packet.getNumberFormat());
                break;
            }
            case REMOVE: {
                scoreboard.removeObjective(objective);
            }
        }
        if (!objective.hasDisplaySlot()) {
            return;
        }
        if (pps < ScoreboardUpdater.FIRST_SCORE_PACKETS_PER_SECOND_THRESHOLD) {
            scoreboard.onUpdate();
        }
    }
}

