/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.level.block.entity;

import it.unimi.dsi.fastutil.longs.LongArrayList;
import java.util.List;
import java.util.UUID;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.cloudburstmc.nbt.NbtMap;
import org.cloudburstmc.nbt.NbtMapBuilder;
import org.cloudburstmc.nbt.NbtType;
import org.geysermc.geyser.entity.type.player.PlayerEntity;
import org.geysermc.geyser.item.parser.ItemStackParser;
import org.geysermc.geyser.level.block.type.BlockState;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.translator.level.block.entity.BlockEntity;
import org.geysermc.geyser.translator.level.block.entity.BlockEntityTranslator;
import org.geysermc.geyser.util.EntityUtils;
import org.geysermc.mcprotocollib.protocol.data.game.level.block.BlockEntityType;

@BlockEntity(type={BlockEntityType.VAULT})
public class VaultBlockEntityTranslator
extends BlockEntityTranslator {
    @Override
    public NbtMap getBlockEntityTag(GeyserSession session, BlockEntityType type, int x, int y, int z, @Nullable NbtMap javaNbt, BlockState blockState) {
        NbtMapBuilder builder = NbtMap.builder();
        if (javaNbt != null) {
            this.translateTag(session, builder, javaNbt, blockState);
        }
        return builder.build();
    }

    @Override
    public void translateTag(GeyserSession session, NbtMapBuilder bedrockNbt, NbtMap javaNbt, BlockState blockState) {
        NbtMap sharedData = javaNbt.getCompound("shared_data");
        bedrockNbt.putCompound("display_item", ItemStackParser.javaItemStackToBedrock(session, sharedData.getCompound("display_item")).build());
        List<int[]> connectedPlayers = sharedData.getList("connected_players", NbtType.INT_ARRAY);
        LongArrayList bedrockPlayers = new LongArrayList(connectedPlayers.size());
        for (int[] player : connectedPlayers) {
            UUID uuid = EntityUtils.uuidFromIntArray(player);
            if (uuid.equals(session.getPlayerEntity().getUuid())) {
                bedrockPlayers.add(session.getPlayerEntity().getGeyserId());
                continue;
            }
            PlayerEntity playerEntity = session.getEntityCache().getPlayerEntity(uuid);
            if (playerEntity == null) continue;
            bedrockPlayers.add(playerEntity.getGeyserId());
        }
        bedrockNbt.putList("connected_players", NbtType.LONG, bedrockPlayers);
        bedrockNbt.putFloat("connected_particle_range", (float)sharedData.getDouble("connected_particles_range", 4.5));
    }
}

