/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.mcprotocollib.protocol.packet.ingame.clientbound;

import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.geyser.platform.bungeecord.shaded.net.kyori.adventure.key.Key;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftPacket;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftTypes;
import org.geysermc.mcprotocollib.protocol.data.game.recipe.Ingredient;
import org.geysermc.mcprotocollib.protocol.data.game.recipe.display.slot.SlotDisplay;

public class ClientboundUpdateRecipesPacket
implements MinecraftPacket {
    private final Map<Key, int[]> itemSets;
    private final List<SelectableRecipe> stonecutterRecipes;

    public ClientboundUpdateRecipesPacket(ByteBuf in) {
        this.itemSets = new HashMap<Key, int[]>();
        int itemCount = MinecraftTypes.readVarInt(in);
        for (int i = 0; i < itemCount; ++i) {
            Key propertySetType = MinecraftTypes.readResourceLocation(in);
            int[] propertySet = new int[MinecraftTypes.readVarInt(in)];
            for (int j = 0; j < propertySet.length; ++j) {
                propertySet[j] = MinecraftTypes.readVarInt(in);
            }
            this.itemSets.put(propertySetType, propertySet);
        }
        this.stonecutterRecipes = MinecraftTypes.readList(in, buf -> {
            Ingredient input = MinecraftTypes.readRecipeIngredient(buf);
            SlotDisplay recipe = MinecraftTypes.readSlotDisplay(buf);
            return new SelectableRecipe(input, recipe);
        });
    }

    @Override
    public void serialize(ByteBuf out) {
        MinecraftTypes.writeVarInt(out, this.itemSets.size());
        for (Map.Entry<Key, int[]> itemSet : this.itemSets.entrySet()) {
            MinecraftTypes.writeResourceLocation(out, itemSet.getKey());
            MinecraftTypes.writeVarInt(out, itemSet.getValue().length);
            for (int property : itemSet.getValue()) {
                MinecraftTypes.writeVarInt(out, property);
            }
        }
        MinecraftTypes.writeList(out, this.stonecutterRecipes, (buf, recipes) -> {
            MinecraftTypes.writeRecipeIngredient(buf, recipes.input());
            MinecraftTypes.writeSlotDisplay(buf, recipes.recipe());
        });
    }

    @Override
    public boolean shouldRunOnGameThread() {
        return true;
    }

    public Map<Key, int[]> getItemSets() {
        return this.itemSets;
    }

    public List<SelectableRecipe> getStonecutterRecipes() {
        return this.stonecutterRecipes;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientboundUpdateRecipesPacket)) {
            return false;
        }
        ClientboundUpdateRecipesPacket other = (ClientboundUpdateRecipesPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Map<Key, int[]> this$itemSets = this.getItemSets();
        Map<Key, int[]> other$itemSets = other.getItemSets();
        if (this$itemSets == null ? other$itemSets != null : !((Object)this$itemSets).equals(other$itemSets)) {
            return false;
        }
        List<SelectableRecipe> this$stonecutterRecipes = this.getStonecutterRecipes();
        List<SelectableRecipe> other$stonecutterRecipes = other.getStonecutterRecipes();
        return !(this$stonecutterRecipes == null ? other$stonecutterRecipes != null : !((Object)this$stonecutterRecipes).equals(other$stonecutterRecipes));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ClientboundUpdateRecipesPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<Key, int[]> $itemSets = this.getItemSets();
        result = result * 59 + ($itemSets == null ? 43 : ((Object)$itemSets).hashCode());
        List<SelectableRecipe> $stonecutterRecipes = this.getStonecutterRecipes();
        result = result * 59 + ($stonecutterRecipes == null ? 43 : ((Object)$stonecutterRecipes).hashCode());
        return result;
    }

    public @NonNull String toString() {
        return "ClientboundUpdateRecipesPacket(itemSets=" + String.valueOf(this.getItemSets()) + ", stonecutterRecipes=" + String.valueOf(this.getStonecutterRecipes()) + ")";
    }

    public @NonNull ClientboundUpdateRecipesPacket withItemSets(Map<Key, int[]> itemSets) {
        return this.itemSets == itemSets ? this : new ClientboundUpdateRecipesPacket(itemSets, this.stonecutterRecipes);
    }

    public @NonNull ClientboundUpdateRecipesPacket withStonecutterRecipes(List<SelectableRecipe> stonecutterRecipes) {
        return this.stonecutterRecipes == stonecutterRecipes ? this : new ClientboundUpdateRecipesPacket(this.itemSets, stonecutterRecipes);
    }

    public ClientboundUpdateRecipesPacket(Map<Key, int[]> itemSets, List<SelectableRecipe> stonecutterRecipes) {
        this.itemSets = itemSets;
        this.stonecutterRecipes = stonecutterRecipes;
    }

    public record SelectableRecipe(Ingredient input, SlotDisplay recipe) {
    }
}

