/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.mcprotocollib.protocol.packet.ingame.clientbound.debug;

import io.netty.buffer.ByteBuf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.cloudburstmc.math.vector.Vector3i;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftPacket;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftTypes;
import org.geysermc.mcprotocollib.protocol.data.game.debug.DebugInfo;
import org.geysermc.mcprotocollib.protocol.data.game.debug.DebugSubscriptions;
import org.jetbrains.annotations.Nullable;

public class ClientboundDebugBlockValuePacket
implements MinecraftPacket {
    private final Vector3i blockPos;
    private final DebugSubscriptions subscriptionType;
    @Nullable
    private final DebugInfo subscription;

    public ClientboundDebugBlockValuePacket(ByteBuf in) {
        this.blockPos = MinecraftTypes.readPosition(in);
        this.subscriptionType = DebugSubscriptions.from(MinecraftTypes.readVarInt(in));
        this.subscription = MinecraftTypes.readDebugSubscriptionUpdate(in, this.subscriptionType);
    }

    @Override
    public void serialize(ByteBuf out) {
        MinecraftTypes.writePosition(out, this.blockPos);
        MinecraftTypes.writeVarInt(out, this.subscriptionType.ordinal());
        MinecraftTypes.writeDebugSubscriptionUpdate(out, this.subscriptionType, this.subscription);
    }

    @Override
    public boolean shouldRunOnGameThread() {
        return true;
    }

    public Vector3i getBlockPos() {
        return this.blockPos;
    }

    public DebugSubscriptions getSubscriptionType() {
        return this.subscriptionType;
    }

    @Nullable
    public DebugInfo getSubscription() {
        return this.subscription;
    }

    public boolean equals(@org.checkerframework.checker.nullness.qual.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientboundDebugBlockValuePacket)) {
            return false;
        }
        ClientboundDebugBlockValuePacket other = (ClientboundDebugBlockValuePacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Vector3i this$blockPos = this.getBlockPos();
        Vector3i other$blockPos = other.getBlockPos();
        if (this$blockPos == null ? other$blockPos != null : !this$blockPos.equals(other$blockPos)) {
            return false;
        }
        DebugSubscriptions this$subscriptionType = this.getSubscriptionType();
        DebugSubscriptions other$subscriptionType = other.getSubscriptionType();
        if (this$subscriptionType == null ? other$subscriptionType != null : !((Object)((Object)this$subscriptionType)).equals((Object)other$subscriptionType)) {
            return false;
        }
        DebugInfo this$subscription = this.getSubscription();
        DebugInfo other$subscription = other.getSubscription();
        return !(this$subscription == null ? other$subscription != null : !this$subscription.equals(other$subscription));
    }

    protected boolean canEqual(@org.checkerframework.checker.nullness.qual.Nullable Object other) {
        return other instanceof ClientboundDebugBlockValuePacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Vector3i $blockPos = this.getBlockPos();
        result = result * 59 + ($blockPos == null ? 43 : $blockPos.hashCode());
        DebugSubscriptions $subscriptionType = this.getSubscriptionType();
        result = result * 59 + ($subscriptionType == null ? 43 : ((Object)((Object)$subscriptionType)).hashCode());
        DebugInfo $subscription = this.getSubscription();
        result = result * 59 + ($subscription == null ? 43 : $subscription.hashCode());
        return result;
    }

    public @NonNull String toString() {
        return "ClientboundDebugBlockValuePacket(blockPos=" + String.valueOf(this.getBlockPos()) + ", subscriptionType=" + String.valueOf((Object)this.getSubscriptionType()) + ", subscription=" + String.valueOf(this.getSubscription()) + ")";
    }

    public @NonNull ClientboundDebugBlockValuePacket withBlockPos(Vector3i blockPos) {
        return this.blockPos == blockPos ? this : new ClientboundDebugBlockValuePacket(blockPos, this.subscriptionType, this.subscription);
    }

    public @NonNull ClientboundDebugBlockValuePacket withSubscriptionType(DebugSubscriptions subscriptionType) {
        return this.subscriptionType == subscriptionType ? this : new ClientboundDebugBlockValuePacket(this.blockPos, subscriptionType, this.subscription);
    }

    public @NonNull ClientboundDebugBlockValuePacket withSubscription(@Nullable DebugInfo subscription) {
        return this.subscription == subscription ? this : new ClientboundDebugBlockValuePacket(this.blockPos, this.subscriptionType, subscription);
    }

    public ClientboundDebugBlockValuePacket(Vector3i blockPos, DebugSubscriptions subscriptionType, @Nullable DebugInfo subscription) {
        this.blockPos = blockPos;
        this.subscriptionType = subscriptionType;
        this.subscription = subscription;
    }
}

