/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.item.parser;

import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.cloudburstmc.nbt.NbtMap;
import org.cloudburstmc.nbt.NbtMapBuilder;
import org.cloudburstmc.nbt.NbtType;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.inventory.item.DyeColor;
import org.geysermc.geyser.inventory.item.Potion;
import org.geysermc.geyser.item.Items;
import org.geysermc.geyser.item.hashing.data.FireworkExplosionShape;
import org.geysermc.geyser.item.type.Item;
import org.geysermc.geyser.platform.bungeecord.shaded.net.kyori.adventure.key.Key;
import org.geysermc.geyser.registry.Registries;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.session.cache.registry.JavaRegistries;
import org.geysermc.geyser.translator.item.BedrockItemBuilder;
import org.geysermc.geyser.translator.item.ItemTranslator;
import org.geysermc.geyser.translator.level.block.entity.SkullBlockEntityTranslator;
import org.geysermc.geyser.util.MinecraftKey;
import org.geysermc.mcprotocollib.protocol.data.game.Holder;
import org.geysermc.mcprotocollib.protocol.data.game.item.ItemStack;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.BannerPatternLayer;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.CustomModelData;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.DataComponentType;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.DataComponentTypes;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.DataComponents;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.Fireworks;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.ItemEnchantments;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.PotionContents;

public final class ItemStackParser {
    private static final Map<DataComponentType<?>, DataComponentParser<?, ?>> PARSERS = new Reference2ObjectOpenHashMap();

    private static <Raw, Parsed> void register(DataComponentType<Parsed> component, Class<Raw> rawClass, DataComponentParser<Raw, Parsed> parser) {
        if (PARSERS.containsKey(component)) {
            throw new IllegalStateException("Duplicate data component parser registered for " + String.valueOf(component));
        }
        PARSERS.put(component, parser);
    }

    private static <Raw, Parsed> void registerSimple(DataComponentType<Parsed> component, Class<Raw> rawClass, Function<Raw, Parsed> parser) {
        ItemStackParser.register(component, rawClass, (session, raw) -> parser.apply(raw));
    }

    private static <Parsed> void registerSimple(DataComponentType<Parsed> component, Class<Parsed> parsedClass) {
        ItemStackParser.registerSimple(component, parsedClass, Function.identity());
    }

    private static int javaItemIdentifierToNetworkId(String identifier) {
        if (identifier == null || identifier.isEmpty()) {
            return Items.AIR_ID;
        }
        Item item = (Item)Registries.JAVA_ITEM_IDENTIFIERS.get(identifier);
        if (item == null) {
            GeyserImpl.getInstance().getLogger().warning("Received unknown item ID " + identifier + " whilst parsing NBT item stack!");
            return Items.AIR_ID;
        }
        return item.javaId();
    }

    private static ItemEnchantments parseEnchantments(GeyserSession session, NbtMap map) {
        Int2IntOpenHashMap enchantments = new Int2IntOpenHashMap(map.size());
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            enchantments.put(JavaRegistries.ENCHANTMENT.networkId(session, MinecraftKey.key(entry.getKey())), (int)((Integer)entry.getValue()));
        }
        return new ItemEnchantments(enchantments);
    }

    private static <Raw, Parsed> void parseDataComponent(GeyserSession session, DataComponents patch, DataComponentType<?> type, DataComponentParser<Raw, Parsed> parser, Object raw) {
        try {
            patch.put(type, parser.parse(session, raw));
        }
        catch (ClassCastException exception) {
            GeyserImpl.getInstance().getLogger().error("Received incorrect object type for component " + String.valueOf(type) + "!", exception);
        }
        catch (Exception exception) {
            GeyserImpl.getInstance().getLogger().error("Failed to parse component" + String.valueOf(type) + " from " + String.valueOf(raw) + "!", exception);
        }
    }

    public static @Nullable DataComponents parseDataComponentPatch(GeyserSession session, @Nullable NbtMap map) {
        if (map == null || map.isEmpty()) {
            return null;
        }
        DataComponents patch = new DataComponents(new Reference2ObjectOpenHashMap());
        try {
            for (Map.Entry<String, Object> patchEntry : map.entrySet()) {
                DataComponentType<?> type;
                String rawType = patchEntry.getKey();
                boolean removal = rawType.startsWith("!");
                if (removal) {
                    rawType = rawType.substring(1);
                }
                if ((type = DataComponentTypes.fromKey(MinecraftKey.key(rawType))) == null) {
                    GeyserImpl.getInstance().getLogger().warning("Received unknown data component " + rawType + " in NBT data component patch: " + String.valueOf(map));
                    continue;
                }
                if (removal) {
                    patch.put(type, null);
                    continue;
                }
                DataComponentParser<?, ?> parser = PARSERS.get(type);
                if (parser != null) {
                    ItemStackParser.parseDataComponent(session, patch, type, parser, patchEntry.getValue());
                    continue;
                }
                GeyserImpl.getInstance().getLogger().debug("Ignoring data component " + String.valueOf(type) + " whilst parsing NBT patch because there is no parser registered for it");
            }
        }
        catch (Exception exception) {
            GeyserImpl.getInstance().getLogger().error("Failed to parse data component patch from NBT data!", exception);
        }
        return patch;
    }

    public static ItemStack parseItemStack(GeyserSession session, @Nullable NbtMap map) {
        if (map == null) {
            return new ItemStack(Items.AIR_ID);
        }
        try {
            int id = ItemStackParser.javaItemIdentifierToNetworkId(map.getString("id"));
            int count = map.getInt("count");
            DataComponents patch = ItemStackParser.parseDataComponentPatch(session, map.getCompound("components"));
            return new ItemStack(id, count, patch);
        }
        catch (Exception exception) {
            GeyserImpl.getInstance().getLogger().error("Failed to parse item stack from NBT data!", exception);
            return new ItemStack(Items.AIR_ID);
        }
    }

    public static NbtMapBuilder javaItemStackToBedrock(GeyserSession session, @Nullable NbtMap map) {
        return BedrockItemBuilder.createItemNbt(ItemTranslator.translateToBedrock(session, ItemStackParser.parseItemStack(session, map)));
    }

    private ItemStackParser() {
    }

    static {
        ItemStackParser.register(DataComponentTypes.BANNER_PATTERNS, List.class, (session, raw) -> {
            List casted = raw;
            ArrayList<BannerPatternLayer> layers = new ArrayList<BannerPatternLayer>();
            for (NbtMap layer : casted) {
                Holder<BannerPatternLayer.BannerPattern> patternHolder;
                DyeColor colour = DyeColor.getByJavaIdentifier(layer.getString("color"));
                Object pattern = layer.get("pattern");
                if (pattern instanceof String) {
                    String id = (String)pattern;
                    patternHolder = Holder.ofId(JavaRegistries.BANNER_PATTERN.networkId(session, MinecraftKey.key(id)));
                } else {
                    NbtMap inline = (NbtMap)pattern;
                    Key assetId = MinecraftKey.key(inline.getString("asset_id"));
                    String translationKey = inline.getString("translation_key");
                    patternHolder = Holder.ofCustom(new BannerPatternLayer.BannerPattern(assetId, translationKey));
                }
                layers.add(new BannerPatternLayer(patternHolder, colour.ordinal()));
            }
            return layers;
        });
        ItemStackParser.registerSimple(DataComponentTypes.BASE_COLOR, String.class, raw -> DyeColor.getByJavaIdentifier(raw).ordinal());
        ItemStackParser.register(DataComponentTypes.CHARGED_PROJECTILES, List.class, (session, projectiles) -> projectiles.stream().map(object -> ItemStackParser.parseItemStack(session, (NbtMap)object)).toList());
        ItemStackParser.registerSimple(DataComponentTypes.CUSTOM_MODEL_DATA, NbtMap.class, raw -> {
            List<Float> floats = raw.getList("floats", NbtType.FLOAT);
            List<Boolean> flags = raw.getList("flags", NbtType.BYTE).stream().map(b -> b != 0).toList();
            List<String> strings = raw.getList("strings", NbtType.STRING);
            List<Integer> colours = raw.getList("colors", NbtType.INT);
            return new CustomModelData(floats, flags, strings, colours);
        });
        ItemStackParser.registerSimple(DataComponentTypes.DYED_COLOR, Integer.class);
        ItemStackParser.registerSimple(DataComponentTypes.ENCHANTMENT_GLINT_OVERRIDE, Boolean.class);
        ItemStackParser.register(DataComponentTypes.ENCHANTMENTS, NbtMap.class, ItemStackParser::parseEnchantments);
        ItemStackParser.registerSimple(DataComponentTypes.FIREWORK_EXPLOSION, NbtMap.class, raw -> {
            FireworkExplosionShape shape = FireworkExplosionShape.fromJavaIdentifier(raw.getString("shape"));
            List<Integer> colours = raw.getList("colors", NbtType.INT);
            List<Integer> fadeColours = raw.getList("fade_colors", NbtType.INT);
            boolean hasTrail = raw.getBoolean("has_trail");
            boolean hasTwinkle = raw.getBoolean("has_twinkle");
            return new Fireworks.FireworkExplosion(shape.ordinal(), colours.stream().mapToInt(i -> i).toArray(), fadeColours.stream().mapToInt(i -> i).toArray(), hasTrail, hasTwinkle);
        });
        ItemStackParser.registerSimple(DataComponentTypes.ITEM_MODEL, String.class, MinecraftKey::key);
        ItemStackParser.registerSimple(DataComponentTypes.MAP_COLOR, Integer.class);
        ItemStackParser.registerSimple(DataComponentTypes.POT_DECORATIONS, List.class, list -> list.stream().map(item -> ItemStackParser.javaItemIdentifierToNetworkId((String)item)).toList());
        ItemStackParser.register(DataComponentTypes.POTION_CONTENTS, NbtMap.class, (session, map) -> {
            Potion potion = Potion.getByJavaIdentifier(map.getString("potion"));
            int customColour = map.getInt("custom_color", -1);
            String customName = map.getString("custom_name", null);
            return new PotionContents(potion == null ? -1 : potion.ordinal(), customColour, List.of(), customName);
        });
        ItemStackParser.registerSimple(DataComponentTypes.PROFILE, NbtMap.class, SkullBlockEntityTranslator::parseResolvableProfile);
        ItemStackParser.register(DataComponentTypes.STORED_ENCHANTMENTS, NbtMap.class, ItemStackParser::parseEnchantments);
    }

    @FunctionalInterface
    private static interface DataComponentParser<Raw, Parsed> {
        public Parsed parse(GeyserSession var1, Raw var2) throws Exception;
    }
}

