/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.item;

import org.geysermc.mcprotocollib.protocol.data.game.item.component.DataComponentType;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.DataComponentTypes;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.DataComponents;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.TooltipDisplay;

@FunctionalInterface
public interface TooltipOptions {
    public static final TooltipOptions ALL_SHOWN = component -> true;
    public static final TooltipOptions ALL_HIDDEN = component -> false;

    public boolean showInTooltip(DataComponentType<?> var1);

    public static TooltipOptions fromComponents(DataComponents components) {
        TooltipDisplay display = (TooltipDisplay)components.get(DataComponentTypes.TOOLTIP_DISPLAY);
        if (display == null) {
            return ALL_SHOWN;
        }
        if (display.hideTooltip()) {
            return ALL_HIDDEN;
        }
        if (display.hiddenComponents().isEmpty()) {
            return ALL_SHOWN;
        }
        return component -> !display.hiddenComponents().contains(component);
    }

    public static boolean hideTooltip(DataComponents components) {
        TooltipDisplay display = (TooltipDisplay)components.get(DataComponentTypes.TOOLTIP_DISPLAY);
        return display != null && display.hideTooltip();
    }
}

