/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.platform.mod;

import java.net.InetSocketAddress;
import java.util.Objects;
import net.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.Connection;
import net.minecraft.network.PacketSendListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.status.ClientboundStatusResponsePacket;
import net.minecraft.network.protocol.status.ServerStatus;
import net.minecraft.network.protocol.status.ServerboundStatusRequestPacket;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.network.ServerStatusPacketListenerImpl;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.geyser.GeyserLogger;
import org.geysermc.geyser.ping.GeyserPingInfo;
import org.geysermc.geyser.ping.IGeyserPingPassthrough;

public class ModPingPassthrough
implements IGeyserPingPassthrough {
    private static final GsonComponentSerializer GSON_SERIALIZER = GsonComponentSerializer.gson();
    private static final LegacyComponentSerializer LEGACY_SERIALIZER = LegacyComponentSerializer.legacySection();
    private final MinecraftServer server;
    private final GeyserLogger logger;

    @Override
    public @Nullable GeyserPingInfo getPingInformation(InetSocketAddress inetSocketAddress) {
        ServerStatus status;
        block3: {
            status = this.server.getStatus();
            if (status == null) {
                return null;
            }
            try {
                StatusInterceptor connection = new StatusInterceptor();
                ServerStatusPacketListenerImpl statusPacketListener = new ServerStatusPacketListenerImpl(status, (Connection)connection);
                statusPacketListener.handleStatusRequest(ServerboundStatusRequestPacket.INSTANCE);
                status = Objects.requireNonNull(connection.status, "status response");
            }
            catch (Exception e) {
                if (!this.logger.isDebug()) break block3;
                this.logger.debug("Failed to listen for modified ServerStatus: " + e.getMessage());
                e.printStackTrace();
            }
        }
        return new GeyserPingInfo(Component.Serializer.toJson((Component)status.description(), (HolderLookup.Provider)RegistryAccess.EMPTY), status.players().map(ServerStatus.Players::max).orElse(1), status.players().map(ServerStatus.Players::online).orElse(0));
    }

    public ModPingPassthrough(MinecraftServer server, GeyserLogger logger) {
        this.server = server;
        this.logger = logger;
    }

    private static class StatusInterceptor
    extends Connection {
        ServerStatus status;

        StatusInterceptor() {
            super(PacketFlow.SERVERBOUND);
        }

        public void send(@NonNull Packet<?> packet, @Nullable PacketSendListener packetSendListener, boolean bl) {
            if (packet instanceof ClientboundStatusResponsePacket) {
                ClientboundStatusResponsePacket statusResponse = (ClientboundStatusResponsePacket)packet;
                this.status = statusResponse.status();
            }
            super.send(packet, packetSendListener, bl);
        }
    }
}

