/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.platform.mod.command;

import com.google.gson.JsonElement;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.UUID;
import net.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.resources.RegistryOps;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.command.GeyserCommandSource;
import org.geysermc.geyser.text.ChatColor;

public class ModCommandSource
implements GeyserCommandSource {
    private final CommandSourceStack source;

    public ModCommandSource(CommandSourceStack source) {
        this.source = source;
    }

    @Override
    public String name() {
        return this.source.getTextName();
    }

    @Override
    public void sendMessage(@NonNull String message) {
        if (this.source.getEntity() instanceof ServerPlayer) {
            ((ServerPlayer)this.source.getEntity()).displayClientMessage((Component)Component.literal((String)message), false);
        } else {
            GeyserImpl.getInstance().getLogger().info(ChatColor.toANSI(message + "\u00a7r"));
        }
    }

    @Override
    public void sendMessage(net.kyori.adventure.text.Component message) {
        Entity entity = this.source.getEntity();
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            JsonElement jsonComponent = GsonComponentSerializer.gson().serializeToTree(message);
            player.displayClientMessage((Component)ComponentSerialization.CODEC.parse((DynamicOps)RegistryOps.create((DynamicOps)JsonOps.INSTANCE, (HolderLookup.Provider)player.registryAccess()), (Object)jsonComponent).getOrThrow(), false);
            return;
        }
        GeyserCommandSource.super.sendMessage(message);
    }

    @Override
    public boolean isConsole() {
        return !(this.source.getEntity() instanceof ServerPlayer);
    }

    @Override
    public @Nullable UUID playerUuid() {
        Entity entity = this.source.getEntity();
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            return player.getUUID();
        }
        return null;
    }

    @Override
    public boolean hasPermission(String permission) {
        return GeyserImpl.getInstance().commandRegistry().hasPermission(this, permission);
    }

    @Override
    public Object handle() {
        return this.source;
    }
}

