/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.level.block.type;

import org.cloudburstmc.math.vector.Vector3i;
import org.cloudburstmc.nbt.NbtMap;
import org.cloudburstmc.nbt.NbtMapBuilder;
import org.geysermc.geyser.level.block.Blocks;
import org.geysermc.geyser.level.block.type.Block;
import org.geysermc.geyser.level.block.type.BlockState;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.packet.UpdateBlockPacket;
import org.geysermc.geyser.translator.level.block.entity.BedrockChunkWantsBlockEntityTag;
import org.geysermc.geyser.translator.level.block.entity.BlockEntityTranslator;
import org.geysermc.geyser.util.BlockEntityUtils;

public class FlowerPotBlock
extends Block
implements BedrockChunkWantsBlockEntityTag {
    private final Block flower;

    public FlowerPotBlock(String javaIdentifier, Block flower, Block.Builder builder) {
        super(javaIdentifier, builder);
        this.flower = flower;
    }

    @Override
    public void updateBlock(GeyserSession session, BlockState state, Vector3i position) {
        super.updateBlock(session, state, position);
        NbtMap tag = this.createTag(session, position, state);
        BlockEntityUtils.updateBlockEntity(session, tag, position);
        UpdateBlockPacket updateBlockPacket = new UpdateBlockPacket();
        updateBlockPacket.setDataLayer(0);
        updateBlockPacket.setDefinition(session.getBlockMappings().getBedrockBlock(state));
        updateBlockPacket.setBlockPosition(position);
        updateBlockPacket.getFlags().add(UpdateBlockPacket.Flag.NEIGHBORS);
        updateBlockPacket.getFlags().add(UpdateBlockPacket.Flag.NETWORK);
        updateBlockPacket.getFlags().add(UpdateBlockPacket.Flag.PRIORITY);
        session.sendUpstreamPacket(updateBlockPacket);
        BlockEntityUtils.updateBlockEntity(session, tag, position);
    }

    @Override
    public NbtMap createTag(GeyserSession session, Vector3i position, BlockState blockState) {
        NbtMap plant;
        NbtMapBuilder tagBuilder = BlockEntityTranslator.getConstantBedrockTag("FlowerPot", position.getX(), position.getY(), position.getZ()).putByte("isMovable", (byte)1);
        if (this.flower != Blocks.AIR && (plant = session.getBlockMappings().getFlowerPotBlocks().get(this.flower)) != null) {
            tagBuilder.putCompound("PlantBlock", plant.toBuilder().build());
        }
        return tagBuilder.build();
    }

    public Block flower() {
        return this.flower;
    }
}

