/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.platform.spigot;

import com.destroystokyo.paper.event.server.PaperServerListPingEvent;
import com.destroystokyo.paper.network.StatusClient;
import java.lang.reflect.Constructor;
import java.net.InetSocketAddress;
import org.bukkit.Bukkit;
import org.bukkit.event.Event;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.geyser.network.GameProtocol;
import org.geysermc.geyser.ping.GeyserPingInfo;
import org.geysermc.geyser.ping.IGeyserPingPassthrough;
import org.geysermc.geyser.platform.spigot.GeyserSpigotLogger;
import org.geysermc.geyser.platform.spigot.ReflectedNames;
import org.geysermc.geyser.platform.spigot.shaded.net.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import org.geysermc.geyser.platform.spigot.shaded.net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;

public final class GeyserPaperPingPassthrough
implements IGeyserPingPassthrough {
    private static final Constructor<PaperServerListPingEvent> OLD_CONSTRUCTOR = ReflectedNames.getOldPaperPingConstructor();
    private final GeyserSpigotLogger logger;

    public GeyserPaperPingPassthrough(GeyserSpigotLogger logger) {
        this.logger = logger;
    }

    @Override
    public @Nullable GeyserPingInfo getPingInformation(InetSocketAddress inetSocketAddress) {
        try {
            PaperServerListPingEvent event = OLD_CONSTRUCTOR != null ? OLD_CONSTRUCTOR.newInstance(new GeyserStatusClient(inetSocketAddress), Bukkit.getMotd(), Bukkit.getOnlinePlayers().size(), Bukkit.getMaxPlayers(), Bukkit.getVersion(), GameProtocol.getJavaProtocolVersion(), null) : new PaperServerListPingEvent((StatusClient)new GeyserStatusClient(inetSocketAddress), Bukkit.getMotd(), Bukkit.getOnlinePlayers().size(), Bukkit.getMaxPlayers(), Bukkit.getVersion(), GameProtocol.getJavaProtocolVersion(), null);
            Bukkit.getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                return null;
            }
            GeyserPingInfo.Players players = event.shouldHidePlayers() ? new GeyserPingInfo.Players(1, 0) : new GeyserPingInfo.Players(event.getMaxPlayers(), event.getNumPlayers());
            return new GeyserPingInfo((String)GsonComponentSerializer.gson().serialize(LegacyComponentSerializer.legacySection().deserialize(event.getMotd())), players);
        }
        catch (Exception | LinkageError e) {
            this.logger.debug("Error while getting Paper ping passthrough: " + String.valueOf(e));
            return null;
        }
    }

    private record GeyserStatusClient(InetSocketAddress address) implements StatusClient
    {
        public @NonNull InetSocketAddress getAddress() {
            return this.address;
        }

        public int getProtocolVersion() {
            return GameProtocol.getJavaProtocolVersion();
        }

        public @Nullable InetSocketAddress getVirtualHost() {
            return null;
        }
    }
}

