/*
 * Decompiled with CFR 0.152.
 */
package org.cloudburstmc.math.vector;

import java.io.Serializable;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import org.cloudburstmc.math.GenericMath;
import org.cloudburstmc.math.vector.Vector2d;
import org.cloudburstmc.math.vector.Vector2f;
import org.cloudburstmc.math.vector.Vector2l;
import org.cloudburstmc.math.vector.Vector3i;
import org.cloudburstmc.math.vector.Vector4i;
import org.cloudburstmc.math.vector.VectorNi;
import org.cloudburstmc.math.vector.Vectori;
import org.cloudburstmc.math.vector.Vectors;

@ParametersAreNonnullByDefault
@Immutable
public abstract class Vector2i
implements Vectori,
Comparable<Vector2i>,
Serializable,
Cloneable {
    public static final Vector2i ZERO = Vector2i.from(0, 0);
    public static final Vector2i UNIT_X = Vector2i.from(1, 0);
    public static final Vector2i UNIT_Y = Vector2i.from(0, 1);
    public static final Vector2i ONE = Vector2i.from(1, 1);

    public abstract int getX();

    public abstract int getY();

    @Nonnull
    public Vector2i add(Vector2i v) {
        return this.add(v.getX(), v.getY());
    }

    @Nonnull
    public Vector2i add(double x, double y) {
        return this.add(GenericMath.floor(x), GenericMath.floor(y));
    }

    @Nonnull
    public abstract Vector2i add(int var1, int var2);

    @Nonnull
    public Vector2i sub(Vector2i v) {
        return this.sub(v.getX(), v.getY());
    }

    @Nonnull
    public Vector2i sub(double x, double y) {
        return this.sub(GenericMath.floor(x), GenericMath.floor(y));
    }

    @Nonnull
    public abstract Vector2i sub(int var1, int var2);

    @Nonnull
    public Vector2i mul(double a) {
        return this.mul(GenericMath.floor(a));
    }

    @Override
    @Nonnull
    public Vector2i mul(int a) {
        return this.mul(a, a);
    }

    @Nonnull
    public Vector2i mul(Vector2i v) {
        return this.mul(v.getX(), v.getY());
    }

    @Nonnull
    public Vector2i mul(double x, double y) {
        return this.mul(GenericMath.floor(x), GenericMath.floor(y));
    }

    @Nonnull
    public abstract Vector2i mul(int var1, int var2);

    @Nonnull
    public Vector2i div(double a) {
        return this.div(GenericMath.floor(a));
    }

    @Override
    @Nonnull
    public Vector2i div(int a) {
        return this.div(a, a);
    }

    @Nonnull
    public Vector2i div(Vector2i v) {
        return this.div(v.getX(), v.getY());
    }

    @Nonnull
    public Vector2i div(double x, double y) {
        return this.div(GenericMath.floor(x), GenericMath.floor(y));
    }

    @Nonnull
    public abstract Vector2i div(int var1, int var2);

    public int dot(Vector2i v) {
        return this.dot(v.getX(), v.getY());
    }

    public int dot(double x, double y) {
        return this.dot(GenericMath.floor(x), GenericMath.floor(y));
    }

    public int dot(int x, int y) {
        return this.getX() * x + this.getY() * y;
    }

    @Nonnull
    public Vector2i project(Vector2i v) {
        return this.project(v.getX(), v.getY());
    }

    @Nonnull
    public Vector2i project(double x, double y) {
        return this.project(GenericMath.floor(x), GenericMath.floor(y));
    }

    @Nonnull
    public abstract Vector2i project(int var1, int var2);

    @Nonnull
    public Vector2i pow(double pow) {
        return this.pow(GenericMath.floor(pow));
    }

    @Override
    @Nonnull
    public abstract Vector2i pow(int var1);

    @Override
    @Nonnull
    public abstract Vector2i abs();

    @Override
    @Nonnull
    public abstract Vector2i negate();

    @Nonnull
    public Vector2i min(Vector2i v) {
        return this.min(v.getX(), v.getY());
    }

    @Nonnull
    public Vector2i min(double x, double y) {
        return this.min(GenericMath.floor(x), GenericMath.floor(y));
    }

    @Nonnull
    public abstract Vector2i min(int var1, int var2);

    @Nonnull
    public Vector2i max(Vector2i v) {
        return this.max(v.getX(), v.getY());
    }

    @Nonnull
    public Vector2i max(double x, double y) {
        return this.max(GenericMath.floor(x), GenericMath.floor(y));
    }

    @Nonnull
    public abstract Vector2i max(int var1, int var2);

    public int distanceSquared(Vector2i v) {
        return this.distanceSquared(v.getX(), v.getY());
    }

    public int distanceSquared(double x, double y) {
        return this.distanceSquared(GenericMath.floor(x), GenericMath.floor(y));
    }

    public int distanceSquared(int x, int y) {
        int dx = this.getX() - x;
        int dy = this.getY() - y;
        return dx * dx + dy * dy;
    }

    public float distance(Vector2i v) {
        return this.distance(v.getX(), v.getY());
    }

    public float distance(double x, double y) {
        return this.distance(GenericMath.floor(x), GenericMath.floor(y));
    }

    public float distance(int x, int y) {
        return (float)Math.sqrt(this.distanceSquared(x, y));
    }

    @Nonnull
    public Vector2i north() {
        return this.north(1);
    }

    @Nonnull
    public abstract Vector2i north(int var1);

    @Nonnull
    public Vector2i south() {
        return this.south(1);
    }

    @Nonnull
    public abstract Vector2i south(int var1);

    @Nonnull
    public Vector2i east() {
        return this.east(1);
    }

    @Nonnull
    public abstract Vector2i east(int var1);

    @Nonnull
    public Vector2i west() {
        return this.west(1);
    }

    @Nonnull
    public abstract Vector2i west(int var1);

    @Override
    public int lengthSquared() {
        return this.getX() * this.getX() + this.getY() * this.getY();
    }

    @Override
    public float length() {
        return (float)Math.sqrt(this.lengthSquared());
    }

    @Override
    public int getMinAxis() {
        return this.getX() < this.getY() ? 0 : 1;
    }

    @Override
    public int getMaxAxis() {
        return this.getX() > this.getY() ? 0 : 1;
    }

    @Nonnull
    public Vector3i toVector3() {
        return this.toVector3(0);
    }

    @Nonnull
    public Vector3i toVector3(double z) {
        return this.toVector3(GenericMath.floor(z));
    }

    @Nonnull
    public Vector3i toVector3(int z) {
        return Vector3i.from(this, z);
    }

    @Nonnull
    public Vector4i toVector4() {
        return this.toVector4(0, 0);
    }

    @Nonnull
    public Vector4i toVector4(double z, double w) {
        return this.toVector4(GenericMath.floor(z), GenericMath.floor(w));
    }

    @Nonnull
    public Vector4i toVector4(int z, int w) {
        return Vector4i.from(this, z, w);
    }

    @Nonnull
    public VectorNi toVectorN() {
        return VectorNi.from(this);
    }

    @Override
    @Nonnull
    public int[] toArray() {
        return new int[]{this.getX(), this.getY()};
    }

    @Override
    @Nonnull
    public Vector2i toInt() {
        return Vector2i.from(this.getX(), this.getY());
    }

    @Override
    @Nonnull
    public Vector2l toLong() {
        return Vector2l.from(this.getX(), this.getY());
    }

    @Override
    @Nonnull
    public Vector2f toFloat() {
        return Vector2f.from(this.getX(), this.getY());
    }

    @Override
    @Nonnull
    public Vector2d toDouble() {
        return Vector2d.from(this.getX(), this.getY());
    }

    @Override
    public int compareTo(Vector2i v) {
        return this.lengthSquared() - v.lengthSquared();
    }

    @Nonnull
    public Vector2i clone() {
        return Vector2i.from(this);
    }

    @Nonnull
    public String toString() {
        return "(" + this.getX() + ", " + this.getY() + ")";
    }

    @Nonnull
    public static Vector2i from(int n) {
        return Vectors.createVector2i(n, n);
    }

    @Nonnull
    public static Vector2i from(Vector2i v) {
        return Vector2i.from(v.getX(), v.getY());
    }

    @Nonnull
    public static Vector2i from(Vector3i v) {
        return Vector2i.from(v.getX(), v.getY());
    }

    @Nonnull
    public static Vector2i from(Vector4i v) {
        return Vector2i.from(v.getX(), v.getY());
    }

    @Nonnull
    public static Vector2i from(VectorNi v) {
        return Vector2i.from(v.get(0), v.get(1));
    }

    @Nonnull
    public static Vector2i from(double x, double y) {
        return Vector2i.from(GenericMath.floor(x), GenericMath.floor(y));
    }

    @Nonnull
    public static Vector2i from(int x, int y) {
        return Vectors.createVector2i(x, y);
    }
}

