/*
 * Decompiled with CFR 0.152.
 */
package org.cloudburstmc.protocol.bedrock.packet;

import java.util.List;
import org.cloudburstmc.math.vector.Vector2f;
import org.cloudburstmc.math.vector.Vector3f;
import org.cloudburstmc.protocol.bedrock.data.AttributeData;
import org.cloudburstmc.protocol.bedrock.data.entity.EntityDataMap;
import org.cloudburstmc.protocol.bedrock.data.entity.EntityLinkData;
import org.cloudburstmc.protocol.bedrock.data.entity.EntityProperties;
import org.cloudburstmc.protocol.bedrock.packet.BedrockPacket;
import org.cloudburstmc.protocol.bedrock.packet.BedrockPacketHandler;
import org.cloudburstmc.protocol.bedrock.packet.BedrockPacketType;
import org.cloudburstmc.protocol.common.PacketSignal;
import org.geysermc.geyser.platform.spigot.shaded.it.unimi.dsi.fastutil.objects.ObjectArrayList;

public class AddEntityPacket
implements BedrockPacket {
    private List<AttributeData> attributes = new ObjectArrayList<AttributeData>();
    private EntityDataMap metadata = new EntityDataMap();
    private List<EntityLinkData> entityLinks = new ObjectArrayList<EntityLinkData>();
    private long uniqueEntityId;
    private long runtimeEntityId;
    private String identifier;
    private int entityType;
    private Vector3f position;
    private Vector3f motion;
    private Vector2f rotation;
    private float headRotation;
    private float bodyRotation;
    private final EntityProperties properties = new EntityProperties();

    @Override
    public final PacketSignal handle(BedrockPacketHandler handler) {
        return handler.handle(this);
    }

    @Override
    public BedrockPacketType getPacketType() {
        return BedrockPacketType.ADD_ENTITY;
    }

    @Override
    public AddEntityPacket clone() {
        try {
            return (AddEntityPacket)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public List<AttributeData> getAttributes() {
        return this.attributes;
    }

    public EntityDataMap getMetadata() {
        return this.metadata;
    }

    public List<EntityLinkData> getEntityLinks() {
        return this.entityLinks;
    }

    public long getUniqueEntityId() {
        return this.uniqueEntityId;
    }

    public long getRuntimeEntityId() {
        return this.runtimeEntityId;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public int getEntityType() {
        return this.entityType;
    }

    public Vector3f getPosition() {
        return this.position;
    }

    public Vector3f getMotion() {
        return this.motion;
    }

    public Vector2f getRotation() {
        return this.rotation;
    }

    public float getHeadRotation() {
        return this.headRotation;
    }

    public float getBodyRotation() {
        return this.bodyRotation;
    }

    public EntityProperties getProperties() {
        return this.properties;
    }

    public void setAttributes(List<AttributeData> attributes) {
        this.attributes = attributes;
    }

    public void setMetadata(EntityDataMap metadata) {
        this.metadata = metadata;
    }

    public void setEntityLinks(List<EntityLinkData> entityLinks) {
        this.entityLinks = entityLinks;
    }

    public void setUniqueEntityId(long uniqueEntityId) {
        this.uniqueEntityId = uniqueEntityId;
    }

    public void setRuntimeEntityId(long runtimeEntityId) {
        this.runtimeEntityId = runtimeEntityId;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public void setEntityType(int entityType) {
        this.entityType = entityType;
    }

    public void setPosition(Vector3f position) {
        this.position = position;
    }

    public void setMotion(Vector3f motion) {
        this.motion = motion;
    }

    public void setRotation(Vector2f rotation) {
        this.rotation = rotation;
    }

    public void setHeadRotation(float headRotation) {
        this.headRotation = headRotation;
    }

    public void setBodyRotation(float bodyRotation) {
        this.bodyRotation = bodyRotation;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AddEntityPacket)) {
            return false;
        }
        AddEntityPacket other = (AddEntityPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.uniqueEntityId != other.uniqueEntityId) {
            return false;
        }
        if (this.runtimeEntityId != other.runtimeEntityId) {
            return false;
        }
        if (this.entityType != other.entityType) {
            return false;
        }
        if (Float.compare(this.headRotation, other.headRotation) != 0) {
            return false;
        }
        if (Float.compare(this.bodyRotation, other.bodyRotation) != 0) {
            return false;
        }
        List<AttributeData> this$attributes = this.attributes;
        List<AttributeData> other$attributes = other.attributes;
        if (this$attributes == null ? other$attributes != null : !((Object)this$attributes).equals(other$attributes)) {
            return false;
        }
        EntityDataMap this$metadata = this.metadata;
        EntityDataMap other$metadata = other.metadata;
        if (this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata)) {
            return false;
        }
        List<EntityLinkData> this$entityLinks = this.entityLinks;
        List<EntityLinkData> other$entityLinks = other.entityLinks;
        if (this$entityLinks == null ? other$entityLinks != null : !((Object)this$entityLinks).equals(other$entityLinks)) {
            return false;
        }
        String this$identifier = this.identifier;
        String other$identifier = other.identifier;
        if (this$identifier == null ? other$identifier != null : !this$identifier.equals(other$identifier)) {
            return false;
        }
        Vector3f this$position = this.position;
        Vector3f other$position = other.position;
        if (this$position == null ? other$position != null : !this$position.equals(other$position)) {
            return false;
        }
        Vector3f this$motion = this.motion;
        Vector3f other$motion = other.motion;
        if (this$motion == null ? other$motion != null : !this$motion.equals(other$motion)) {
            return false;
        }
        Vector2f this$rotation = this.rotation;
        Vector2f other$rotation = other.rotation;
        if (this$rotation == null ? other$rotation != null : !this$rotation.equals(other$rotation)) {
            return false;
        }
        EntityProperties this$properties = this.properties;
        EntityProperties other$properties = other.properties;
        return !(this$properties == null ? other$properties != null : !((Object)this$properties).equals(other$properties));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AddEntityPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $uniqueEntityId = this.uniqueEntityId;
        result = result * 59 + (int)($uniqueEntityId >>> 32 ^ $uniqueEntityId);
        long $runtimeEntityId = this.runtimeEntityId;
        result = result * 59 + (int)($runtimeEntityId >>> 32 ^ $runtimeEntityId);
        result = result * 59 + this.entityType;
        result = result * 59 + Float.floatToIntBits(this.headRotation);
        result = result * 59 + Float.floatToIntBits(this.bodyRotation);
        List<AttributeData> $attributes = this.attributes;
        result = result * 59 + ($attributes == null ? 43 : ((Object)$attributes).hashCode());
        EntityDataMap $metadata = this.metadata;
        result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
        List<EntityLinkData> $entityLinks = this.entityLinks;
        result = result * 59 + ($entityLinks == null ? 43 : ((Object)$entityLinks).hashCode());
        String $identifier = this.identifier;
        result = result * 59 + ($identifier == null ? 43 : $identifier.hashCode());
        Vector3f $position = this.position;
        result = result * 59 + ($position == null ? 43 : $position.hashCode());
        Vector3f $motion = this.motion;
        result = result * 59 + ($motion == null ? 43 : $motion.hashCode());
        Vector2f $rotation = this.rotation;
        result = result * 59 + ($rotation == null ? 43 : $rotation.hashCode());
        EntityProperties $properties = this.properties;
        result = result * 59 + ($properties == null ? 43 : ((Object)$properties).hashCode());
        return result;
    }

    public String toString() {
        return "AddEntityPacket(attributes=" + this.attributes + ", metadata=" + this.metadata + ", entityLinks=" + this.entityLinks + ", uniqueEntityId=" + this.uniqueEntityId + ", runtimeEntityId=" + this.runtimeEntityId + ", identifier=" + this.identifier + ", entityType=" + this.entityType + ", position=" + this.position + ", motion=" + this.motion + ", rotation=" + this.rotation + ", headRotation=" + this.headRotation + ", bodyRotation=" + this.bodyRotation + ", properties=" + this.properties + ")";
    }
}

