/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.item.type;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.cloudburstmc.nbt.NbtList;
import org.cloudburstmc.nbt.NbtMap;
import org.cloudburstmc.nbt.NbtType;
import org.geysermc.geyser.inventory.item.BannerPattern;
import org.geysermc.geyser.inventory.item.DyeColor;
import org.geysermc.geyser.item.TooltipOptions;
import org.geysermc.geyser.item.type.BlockItem;
import org.geysermc.geyser.item.type.Item;
import org.geysermc.geyser.level.block.type.Block;
import org.geysermc.geyser.platform.spigot.shaded.it.unimi.dsi.fastutil.Pair;
import org.geysermc.geyser.platform.spigot.shaded.net.kyori.adventure.key.Key;
import org.geysermc.geyser.platform.spigot.shaded.net.kyori.adventure.text.Component;
import org.geysermc.geyser.platform.spigot.shaded.net.kyori.adventure.text.format.Style;
import org.geysermc.geyser.platform.spigot.shaded.net.kyori.adventure.text.format.TextColor;
import org.geysermc.geyser.registry.type.ItemMapping;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.session.cache.registry.JavaRegistries;
import org.geysermc.geyser.session.cache.registry.JavaRegistry;
import org.geysermc.geyser.translator.item.BedrockItemBuilder;
import org.geysermc.geyser.util.MinecraftKey;
import org.geysermc.mcprotocollib.protocol.data.game.Holder;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.BannerPatternLayer;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.DataComponentTypes;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.DataComponents;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.TooltipDisplay;

public class BannerItem
extends BlockItem {
    private static final List<Pair<BannerPattern, DyeColor>> OMINOUS_BANNER_PATTERN = List.of(Pair.of(BannerPattern.RHOMBUS, DyeColor.CYAN), Pair.of(BannerPattern.STRIPE_BOTTOM, DyeColor.LIGHT_GRAY), Pair.of(BannerPattern.STRIPE_CENTER, DyeColor.GRAY), Pair.of(BannerPattern.BORDER, DyeColor.LIGHT_GRAY), Pair.of(BannerPattern.STRIPE_MIDDLE, DyeColor.BLACK), Pair.of(BannerPattern.HALF_HORIZONTAL, DyeColor.LIGHT_GRAY), Pair.of(BannerPattern.CIRCLE, DyeColor.LIGHT_GRAY), Pair.of(BannerPattern.BORDER, DyeColor.BLACK));

    public static boolean isOminous(GeyserSession session, List<BannerPatternLayer> patternLayers) {
        if (OMINOUS_BANNER_PATTERN.size() != patternLayers.size()) {
            return false;
        }
        for (int i = 0; i < OMINOUS_BANNER_PATTERN.size(); ++i) {
            BannerPatternLayer patternLayer = patternLayers.get(i);
            Pair<BannerPattern, DyeColor> pair = OMINOUS_BANNER_PATTERN.get(i);
            if (patternLayer.getColorId() != pair.right().ordinal() || !patternLayer.getPattern().isId()) {
                return false;
            }
            BannerPattern bannerPattern = session.getRegistryCache().registry(JavaRegistries.BANNER_PATTERN).byId(patternLayer.getPattern().id());
            if (bannerPattern == pair.left()) continue;
            return false;
        }
        return true;
    }

    public static boolean isOminous(List<NbtMap> blockEntityPatterns) {
        if (OMINOUS_BANNER_PATTERN.size() != blockEntityPatterns.size()) {
            return false;
        }
        for (int i = 0; i < OMINOUS_BANNER_PATTERN.size(); ++i) {
            NbtMap patternLayer = blockEntityPatterns.get(i);
            Pair<BannerPattern, DyeColor> pair = OMINOUS_BANNER_PATTERN.get(i);
            DyeColor color = DyeColor.getByJavaIdentifier(patternLayer.getString("color"));
            if (color != pair.right()) {
                return false;
            }
            Key id = MinecraftKey.key(patternLayer.getString("pattern"));
            BannerPattern bannerPattern = BannerPattern.getByJavaIdentifier(id);
            if (bannerPattern == pair.left()) continue;
            return false;
        }
        return true;
    }

    public static NbtList<NbtMap> convertBannerPattern(List<NbtMap> patterns) {
        ArrayList<NbtMap> tagsList = new ArrayList<NbtMap>();
        for (NbtMap patternTag : patterns) {
            NbtMap bedrockBannerPattern = BannerItem.getBedrockBannerPattern(patternTag);
            if (bedrockBannerPattern == null) continue;
            tagsList.add(bedrockBannerPattern);
        }
        return new NbtList<NbtMap>(NbtType.COMPOUND, (Collection<NbtMap>)tagsList);
    }

    static void convertBannerPattern(GeyserSession session, List<BannerPatternLayer> patterns, BedrockItemBuilder builder) {
        if (BannerItem.isOminous(session, patterns)) {
            builder.putInt("Type", 1);
        } else {
            ArrayList patternList = new ArrayList(patterns.size());
            for (BannerPatternLayer patternLayer : patterns) {
                patternLayer.getPattern().ifId(id -> {
                    BannerPattern bannerPattern = session.getRegistryCache().registry(JavaRegistries.BANNER_PATTERN).byId(id);
                    NbtMap tag = NbtMap.builder().putString("Pattern", bannerPattern.getBedrockIdentifier()).putInt("Color", 15 - patternLayer.getColorId()).build();
                    patternList.add(tag);
                });
            }
            builder.putList("Patterns", NbtType.COMPOUND, patternList);
        }
    }

    private static NbtMap getBedrockBannerPattern(NbtMap pattern) {
        BannerPattern bannerPattern = BannerPattern.getByJavaIdentifier(MinecraftKey.key(pattern.getString("pattern")));
        DyeColor dyeColor = DyeColor.getByJavaIdentifier(pattern.getString("color"));
        if (bannerPattern == null || dyeColor == null) {
            return null;
        }
        return NbtMap.builder().putString("Pattern", bannerPattern.getBedrockIdentifier()).putInt("Color", 15 - dyeColor.ordinal()).build();
    }

    public static BannerPatternLayer getJavaBannerPattern(GeyserSession session, NbtMap pattern) {
        int id;
        JavaRegistry<BannerPattern> registry = session.getRegistryCache().registry(JavaRegistries.BANNER_PATTERN);
        BannerPattern bannerPattern = BannerPattern.getByBedrockIdentifier(pattern.getString("Pattern"));
        DyeColor dyeColor = DyeColor.getById(15 - pattern.getInt("Color"));
        if (dyeColor != null && (id = registry.byValue(bannerPattern)) != -1) {
            return new BannerPatternLayer(Holder.ofId(id), dyeColor.ordinal());
        }
        return null;
    }

    public BannerItem(Item.Builder builder, Block block, Block ... otherBlocks) {
        super(builder, block, otherBlocks);
    }

    @Override
    public void translateComponentsToBedrock(@NonNull GeyserSession session, @NonNull DataComponents components, @NonNull TooltipOptions tooltip, @NonNull BedrockItemBuilder builder) {
        super.translateComponentsToBedrock(session, components, tooltip, builder);
        List<BannerPatternLayer> patterns = components.get(DataComponentTypes.BANNER_PATTERNS);
        if (patterns != null) {
            BannerItem.convertBannerPattern(session, patterns, builder);
        }
    }

    @Override
    public void translateNbtToJava(@NonNull GeyserSession session, @NonNull NbtMap bedrockTag, @NonNull DataComponents components, @NonNull ItemMapping mapping) {
        super.translateNbtToJava(session, bedrockTag, components, mapping);
        if (bedrockTag.getInt("Type") == 1) {
            ArrayList<BannerPatternLayer> patternLayers = new ArrayList<BannerPatternLayer>();
            for (int i = 0; i < OMINOUS_BANNER_PATTERN.size(); ++i) {
                Pair<BannerPattern, DyeColor> pair = OMINOUS_BANNER_PATTERN.get(i);
                patternLayers.add(new BannerPatternLayer(Holder.ofId(session.getRegistryCache().registry(JavaRegistries.BANNER_PATTERN).byValue(pair.left())), pair.right().ordinal()));
            }
            components.put(DataComponentTypes.BANNER_PATTERNS, patternLayers);
            components.put(DataComponentTypes.TOOLTIP_DISPLAY, new TooltipDisplay(false, List.of(DataComponentTypes.BANNER_PATTERNS)));
            components.put(DataComponentTypes.ITEM_NAME, Component.translatable("block.minecraft.ominous_banner").style(Style.style(TextColor.color(0xFFAA00))));
        }
    }
}

