/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.network.netty;

import io.netty.bootstrap.AbstractBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.epoll.Native;
import io.netty.channel.unix.UnixChannelOption;
import java.util.concurrent.CompletableFuture;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.geysermc.geyser.GeyserImpl;

public final class Bootstraps {
    private static final int[] REUSEPORT_VERSION;
    private static final boolean REUSEPORT_AVAILABLE;

    public static boolean isReusePortAvailable() {
        return REUSEPORT_AVAILABLE;
    }

    public static boolean setupBootstrap(AbstractBootstrap bootstrap) {
        boolean success = true;
        if (REUSEPORT_AVAILABLE) {
            Channel channel = bootstrap.register().channel();
            if (channel.config().setOption(UnixChannelOption.SO_REUSEPORT, (Object)true)) {
                bootstrap.option(UnixChannelOption.SO_REUSEPORT, (Object)true);
            } else {
                GeyserImpl.getInstance().getLogger().debug("so_reuseport is not available despite version being " + Native.KERNEL_VERSION);
                success = false;
            }
            channel.close();
        }
        return success;
    }

    private static int[] fromString(String input) {
        Pattern pattern = Pattern.compile("^(\\d+)\\.(\\d+)");
        Matcher matcher = pattern.matcher(input);
        int[] version = new int[]{0, 0};
        if (matcher.find()) {
            version[0] = Integer.parseInt(matcher.group(1));
            version[1] = Integer.parseInt(matcher.group(2));
        }
        return version;
    }

    private static boolean checkVersion(int[] ver, int i) {
        if (ver[i] > REUSEPORT_VERSION[i]) {
            return true;
        }
        if (ver[i] == REUSEPORT_VERSION[i]) {
            if (ver.length == i + 1) {
                return true;
            }
            return Bootstraps.checkVersion(ver, i + 1);
        }
        return false;
    }

    public static CompletableFuture<Void> allOf(ChannelFuture ... futures) {
        if (futures == null || futures.length == 0) {
            return CompletableFuture.completedFuture(null);
        }
        CompletableFuture[] completableFutures = new CompletableFuture[futures.length];
        for (int i = 0; i < futures.length; ++i) {
            ChannelFuture channelFuture = futures[i];
            CompletableFuture completableFuture = new CompletableFuture();
            channelFuture.addListener(future -> {
                if (future.cause() != null) {
                    completableFuture.completeExceptionally(future.cause());
                }
                completableFuture.complete(channelFuture.channel());
            });
            completableFutures[i] = completableFuture;
        }
        return CompletableFuture.allOf(completableFutures);
    }

    private Bootstraps() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    static {
        String kernelVersion;
        REUSEPORT_VERSION = new int[]{3, 9};
        try {
            kernelVersion = Native.KERNEL_VERSION;
            GeyserImpl.getInstance().getLogger().debug("Kernel version: " + kernelVersion);
        }
        catch (Throwable e) {
            GeyserImpl.getInstance().getLogger().debug("Could not determine kernel version! " + e.getMessage());
            kernelVersion = null;
        }
        if (kernelVersion == null) {
            REUSEPORT_AVAILABLE = false;
        } else {
            int[] kernelVer = Bootstraps.fromString(kernelVersion);
            REUSEPORT_AVAILABLE = Bootstraps.checkVersion(kernelVer, 0);
        }
    }
}

