/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.session.cache;

import org.cloudburstmc.math.vector.Vector2f;
import org.cloudburstmc.math.vector.Vector3f;
import org.cloudburstmc.protocol.bedrock.data.entity.EntityDataMap;
import org.cloudburstmc.protocol.bedrock.data.entity.EntityDataTypes;
import org.cloudburstmc.protocol.bedrock.packet.AddEntityPacket;
import org.cloudburstmc.protocol.bedrock.packet.BossEventPacket;
import org.cloudburstmc.protocol.bedrock.packet.RemoveEntityPacket;
import org.geysermc.geyser.platform.spigot.shaded.net.kyori.adventure.text.Component;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.translator.text.MessageTranslator;

public class BossBar {
    private final GeyserSession session;
    private final long entityId;
    private Component title;
    private float health;
    private int color;
    private final int overlay;
    private final int darkenSky;

    public void addBossBar() {
        this.addBossEntity();
        this.updateBossBar();
    }

    public void updateBossBar() {
        BossEventPacket bossEventPacket = new BossEventPacket();
        bossEventPacket.setBossUniqueEntityId(this.entityId);
        bossEventPacket.setAction(BossEventPacket.Action.CREATE);
        bossEventPacket.setTitle(MessageTranslator.convertMessage(this.title, this.session.locale()));
        bossEventPacket.setHealthPercentage(this.health);
        bossEventPacket.setColor(this.color);
        bossEventPacket.setOverlay(this.overlay);
        bossEventPacket.setDarkenSky(this.darkenSky);
        this.session.sendUpstreamPacket(bossEventPacket);
    }

    public void updateTitle(Component title) {
        this.title = title;
        BossEventPacket bossEventPacket = new BossEventPacket();
        bossEventPacket.setBossUniqueEntityId(this.entityId);
        bossEventPacket.setAction(BossEventPacket.Action.UPDATE_NAME);
        bossEventPacket.setTitle(MessageTranslator.convertMessage(title, this.session.locale()));
        this.session.sendUpstreamPacket(bossEventPacket);
    }

    public void updateHealth(float health) {
        this.health = health;
        BossEventPacket bossEventPacket = new BossEventPacket();
        bossEventPacket.setBossUniqueEntityId(this.entityId);
        bossEventPacket.setAction(BossEventPacket.Action.UPDATE_PERCENTAGE);
        bossEventPacket.setHealthPercentage(health);
        this.session.sendUpstreamPacket(bossEventPacket);
    }

    public void updateColor(int color) {
        this.color = color;
        BossEventPacket bossEventPacket = new BossEventPacket();
        bossEventPacket.setBossUniqueEntityId(this.entityId);
        bossEventPacket.setAction(BossEventPacket.Action.UPDATE_STYLE);
        bossEventPacket.setColor(color);
        this.session.sendUpstreamPacket(bossEventPacket);
    }

    public void removeBossBar() {
        BossEventPacket bossEventPacket = new BossEventPacket();
        bossEventPacket.setBossUniqueEntityId(this.entityId);
        bossEventPacket.setAction(BossEventPacket.Action.REMOVE);
        this.session.sendUpstreamPacket(bossEventPacket);
        this.removeBossEntity();
    }

    private void addBossEntity() {
        AddEntityPacket addEntityPacket = new AddEntityPacket();
        addEntityPacket.setUniqueEntityId(this.entityId);
        addEntityPacket.setRuntimeEntityId(this.entityId);
        addEntityPacket.setIdentifier("minecraft:creeper");
        addEntityPacket.setEntityType(33);
        addEntityPacket.setPosition(this.session.getPlayerEntity().getPosition().sub(0.0, -10.0, 0.0));
        addEntityPacket.setRotation(Vector2f.ZERO);
        addEntityPacket.setMotion(Vector3f.ZERO);
        EntityDataMap metadata = addEntityPacket.getMetadata();
        metadata.put(EntityDataTypes.SCALE, (Object)Float.valueOf(0.0f));
        metadata.put(EntityDataTypes.WIDTH, (Object)Float.valueOf(0.0f));
        metadata.put(EntityDataTypes.HEIGHT, (Object)Float.valueOf(0.0f));
        this.session.sendUpstreamPacket(addEntityPacket);
    }

    private void removeBossEntity() {
        RemoveEntityPacket removeEntityPacket = new RemoveEntityPacket();
        removeEntityPacket.setUniqueEntityId(this.entityId);
        this.session.sendUpstreamPacket(removeEntityPacket);
    }

    public BossBar(GeyserSession session, long entityId, Component title, float health, int color, int overlay, int darkenSky) {
        this.session = session;
        this.entityId = entityId;
        this.title = title;
        this.health = health;
        this.color = color;
        this.overlay = overlay;
        this.darkenSky = darkenSky;
    }
}

