/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.mcprotocollib.protocol.packet.ingame.clientbound.level;

import io.netty.buffer.ByteBuf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftPacket;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftTypes;
import org.geysermc.mcprotocollib.protocol.data.game.level.sound.BuiltinSound;
import org.geysermc.mcprotocollib.protocol.data.game.level.sound.CustomSound;
import org.geysermc.mcprotocollib.protocol.data.game.level.sound.Sound;
import org.geysermc.mcprotocollib.protocol.data.game.level.sound.SoundCategory;

public class ClientboundSoundPacket
implements MinecraftPacket {
    @lombok.NonNull
    private final Sound sound;
    @lombok.NonNull
    private final SoundCategory category;
    private final double x;
    private final double y;
    private final double z;
    private final float volume;
    private final float pitch;
    private final long seed;

    public ClientboundSoundPacket(ByteBuf in) {
        this.sound = MinecraftTypes.readById(in, BuiltinSound::from, MinecraftTypes::readSoundEvent);
        this.category = MinecraftTypes.readSoundCategory(in);
        this.x = (double)in.readInt() / 8.0;
        this.y = (double)in.readInt() / 8.0;
        this.z = (double)in.readInt() / 8.0;
        this.volume = in.readFloat();
        this.pitch = in.readFloat();
        this.seed = in.readLong();
    }

    @Override
    public void serialize(ByteBuf out) {
        if (this.sound instanceof CustomSound) {
            MinecraftTypes.writeVarInt(out, 0);
            MinecraftTypes.writeSoundEvent(out, this.sound);
        } else {
            MinecraftTypes.writeVarInt(out, ((BuiltinSound)this.sound).ordinal() + 1);
        }
        MinecraftTypes.writeSoundCategory(out, this.category);
        out.writeInt((int)(this.x * 8.0));
        out.writeInt((int)(this.y * 8.0));
        out.writeInt((int)(this.z * 8.0));
        out.writeFloat(this.volume);
        out.writeFloat(this.pitch);
        out.writeLong(this.seed);
    }

    @Override
    public boolean shouldRunOnGameThread() {
        return true;
    }

    @lombok.NonNull
    public Sound getSound() {
        return this.sound;
    }

    @lombok.NonNull
    public SoundCategory getCategory() {
        return this.category;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getZ() {
        return this.z;
    }

    public float getVolume() {
        return this.volume;
    }

    public float getPitch() {
        return this.pitch;
    }

    public long getSeed() {
        return this.seed;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientboundSoundPacket)) {
            return false;
        }
        ClientboundSoundPacket other = (ClientboundSoundPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Double.compare(this.getX(), other.getX()) != 0) {
            return false;
        }
        if (Double.compare(this.getY(), other.getY()) != 0) {
            return false;
        }
        if (Double.compare(this.getZ(), other.getZ()) != 0) {
            return false;
        }
        if (Float.compare(this.getVolume(), other.getVolume()) != 0) {
            return false;
        }
        if (Float.compare(this.getPitch(), other.getPitch()) != 0) {
            return false;
        }
        if (this.getSeed() != other.getSeed()) {
            return false;
        }
        Sound this$sound = this.getSound();
        Sound other$sound = other.getSound();
        if (this$sound == null ? other$sound != null : !this$sound.equals(other$sound)) {
            return false;
        }
        SoundCategory this$category = this.getCategory();
        SoundCategory other$category = other.getCategory();
        return !(this$category == null ? other$category != null : !((Object)((Object)this$category)).equals((Object)other$category));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ClientboundSoundPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $x = Double.doubleToLongBits(this.getX());
        result = result * 59 + (int)($x >>> 32 ^ $x);
        long $y = Double.doubleToLongBits(this.getY());
        result = result * 59 + (int)($y >>> 32 ^ $y);
        long $z = Double.doubleToLongBits(this.getZ());
        result = result * 59 + (int)($z >>> 32 ^ $z);
        result = result * 59 + Float.floatToIntBits(this.getVolume());
        result = result * 59 + Float.floatToIntBits(this.getPitch());
        long $seed = this.getSeed();
        result = result * 59 + (int)($seed >>> 32 ^ $seed);
        Sound $sound = this.getSound();
        result = result * 59 + ($sound == null ? 43 : $sound.hashCode());
        SoundCategory $category = this.getCategory();
        result = result * 59 + ($category == null ? 43 : ((Object)((Object)$category)).hashCode());
        return result;
    }

    public @NonNull String toString() {
        return "ClientboundSoundPacket(sound=" + String.valueOf(this.getSound()) + ", category=" + String.valueOf((Object)this.getCategory()) + ", x=" + this.getX() + ", y=" + this.getY() + ", z=" + this.getZ() + ", volume=" + this.getVolume() + ", pitch=" + this.getPitch() + ", seed=" + this.getSeed() + ")";
    }

    public @NonNull ClientboundSoundPacket withSound(@lombok.NonNull Sound sound) {
        if (sound == null) {
            throw new NullPointerException("sound is marked non-null but is null");
        }
        return this.sound == sound ? this : new ClientboundSoundPacket(sound, this.category, this.x, this.y, this.z, this.volume, this.pitch, this.seed);
    }

    public @NonNull ClientboundSoundPacket withCategory(@lombok.NonNull SoundCategory category) {
        if (category == null) {
            throw new NullPointerException("category is marked non-null but is null");
        }
        return this.category == category ? this : new ClientboundSoundPacket(this.sound, category, this.x, this.y, this.z, this.volume, this.pitch, this.seed);
    }

    public @NonNull ClientboundSoundPacket withX(double x) {
        return this.x == x ? this : new ClientboundSoundPacket(this.sound, this.category, x, this.y, this.z, this.volume, this.pitch, this.seed);
    }

    public @NonNull ClientboundSoundPacket withY(double y) {
        return this.y == y ? this : new ClientboundSoundPacket(this.sound, this.category, this.x, y, this.z, this.volume, this.pitch, this.seed);
    }

    public @NonNull ClientboundSoundPacket withZ(double z) {
        return this.z == z ? this : new ClientboundSoundPacket(this.sound, this.category, this.x, this.y, z, this.volume, this.pitch, this.seed);
    }

    public @NonNull ClientboundSoundPacket withVolume(float volume) {
        return this.volume == volume ? this : new ClientboundSoundPacket(this.sound, this.category, this.x, this.y, this.z, volume, this.pitch, this.seed);
    }

    public @NonNull ClientboundSoundPacket withPitch(float pitch) {
        return this.pitch == pitch ? this : new ClientboundSoundPacket(this.sound, this.category, this.x, this.y, this.z, this.volume, pitch, this.seed);
    }

    public @NonNull ClientboundSoundPacket withSeed(long seed) {
        return this.seed == seed ? this : new ClientboundSoundPacket(this.sound, this.category, this.x, this.y, this.z, this.volume, this.pitch, seed);
    }

    public ClientboundSoundPacket(@lombok.NonNull Sound sound, @lombok.NonNull SoundCategory category, double x, double y, double z, float volume, float pitch, long seed) {
        if (sound == null) {
            throw new NullPointerException("sound is marked non-null but is null");
        }
        if (category == null) {
            throw new NullPointerException("category is marked non-null but is null");
        }
        this.sound = sound;
        this.category = category;
        this.x = x;
        this.y = y;
        this.z = z;
        this.volume = volume;
        this.pitch = pitch;
        this.seed = seed;
    }
}

