/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.mcprotocollib.protocol.data.game.level;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftTypes;

public class LightUpdateData {
    @lombok.NonNull
    private final BitSet skyYMask;
    @lombok.NonNull
    private final BitSet blockYMask;
    @lombok.NonNull
    private final BitSet emptySkyYMask;
    @lombok.NonNull
    private final BitSet emptyBlockYMask;
    @lombok.NonNull
    private final List<byte[]> skyUpdates;
    @lombok.NonNull
    private final List<byte[]> blockUpdates;

    public static LightUpdateData read(ByteBuf in) {
        return new LightUpdateData(in);
    }

    private LightUpdateData(ByteBuf in) {
        this.skyYMask = BitSet.valueOf(MinecraftTypes.readLongArray(in));
        this.blockYMask = BitSet.valueOf(MinecraftTypes.readLongArray(in));
        this.emptySkyYMask = BitSet.valueOf(MinecraftTypes.readLongArray(in));
        this.emptyBlockYMask = BitSet.valueOf(MinecraftTypes.readLongArray(in));
        int skyUpdateSize = MinecraftTypes.readVarInt(in);
        this.skyUpdates = new ArrayList<byte[]>(skyUpdateSize);
        for (int i = 0; i < skyUpdateSize; ++i) {
            this.skyUpdates.add(MinecraftTypes.readByteArray(in));
        }
        int blockUpdateSize = MinecraftTypes.readVarInt(in);
        this.blockUpdates = new ArrayList<byte[]>(blockUpdateSize);
        for (int i = 0; i < blockUpdateSize; ++i) {
            this.blockUpdates.add(MinecraftTypes.readByteArray(in));
        }
    }

    public static void write(ByteBuf out, LightUpdateData data) {
        data.write(out);
    }

    private void write(ByteBuf out) {
        this.writeBitSet(out, this.skyYMask);
        this.writeBitSet(out, this.blockYMask);
        this.writeBitSet(out, this.emptySkyYMask);
        this.writeBitSet(out, this.emptyBlockYMask);
        MinecraftTypes.writeVarInt(out, this.skyUpdates.size());
        for (byte[] array : this.skyUpdates) {
            MinecraftTypes.writeByteArray(out, array);
        }
        MinecraftTypes.writeVarInt(out, this.blockUpdates.size());
        for (byte[] array : this.blockUpdates) {
            MinecraftTypes.writeByteArray(out, array);
        }
    }

    private void writeBitSet(ByteBuf out, BitSet bitSet) {
        long[] array = bitSet.toLongArray();
        MinecraftTypes.writeLongArray(out, array);
    }

    @lombok.NonNull
    public BitSet getSkyYMask() {
        return this.skyYMask;
    }

    @lombok.NonNull
    public BitSet getBlockYMask() {
        return this.blockYMask;
    }

    @lombok.NonNull
    public BitSet getEmptySkyYMask() {
        return this.emptySkyYMask;
    }

    @lombok.NonNull
    public BitSet getEmptyBlockYMask() {
        return this.emptyBlockYMask;
    }

    @lombok.NonNull
    public List<byte[]> getSkyUpdates() {
        return this.skyUpdates;
    }

    @lombok.NonNull
    public List<byte[]> getBlockUpdates() {
        return this.blockUpdates;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LightUpdateData)) {
            return false;
        }
        LightUpdateData other = (LightUpdateData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        BitSet this$skyYMask = this.getSkyYMask();
        BitSet other$skyYMask = other.getSkyYMask();
        if (this$skyYMask == null ? other$skyYMask != null : !((Object)this$skyYMask).equals(other$skyYMask)) {
            return false;
        }
        BitSet this$blockYMask = this.getBlockYMask();
        BitSet other$blockYMask = other.getBlockYMask();
        if (this$blockYMask == null ? other$blockYMask != null : !((Object)this$blockYMask).equals(other$blockYMask)) {
            return false;
        }
        BitSet this$emptySkyYMask = this.getEmptySkyYMask();
        BitSet other$emptySkyYMask = other.getEmptySkyYMask();
        if (this$emptySkyYMask == null ? other$emptySkyYMask != null : !((Object)this$emptySkyYMask).equals(other$emptySkyYMask)) {
            return false;
        }
        BitSet this$emptyBlockYMask = this.getEmptyBlockYMask();
        BitSet other$emptyBlockYMask = other.getEmptyBlockYMask();
        if (this$emptyBlockYMask == null ? other$emptyBlockYMask != null : !((Object)this$emptyBlockYMask).equals(other$emptyBlockYMask)) {
            return false;
        }
        List<byte[]> this$skyUpdates = this.getSkyUpdates();
        List<byte[]> other$skyUpdates = other.getSkyUpdates();
        if (this$skyUpdates == null ? other$skyUpdates != null : !((Object)this$skyUpdates).equals(other$skyUpdates)) {
            return false;
        }
        List<byte[]> this$blockUpdates = this.getBlockUpdates();
        List<byte[]> other$blockUpdates = other.getBlockUpdates();
        return !(this$blockUpdates == null ? other$blockUpdates != null : !((Object)this$blockUpdates).equals(other$blockUpdates));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof LightUpdateData;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        BitSet $skyYMask = this.getSkyYMask();
        result = result * 59 + ($skyYMask == null ? 43 : ((Object)$skyYMask).hashCode());
        BitSet $blockYMask = this.getBlockYMask();
        result = result * 59 + ($blockYMask == null ? 43 : ((Object)$blockYMask).hashCode());
        BitSet $emptySkyYMask = this.getEmptySkyYMask();
        result = result * 59 + ($emptySkyYMask == null ? 43 : ((Object)$emptySkyYMask).hashCode());
        BitSet $emptyBlockYMask = this.getEmptyBlockYMask();
        result = result * 59 + ($emptyBlockYMask == null ? 43 : ((Object)$emptyBlockYMask).hashCode());
        List<byte[]> $skyUpdates = this.getSkyUpdates();
        result = result * 59 + ($skyUpdates == null ? 43 : ((Object)$skyUpdates).hashCode());
        List<byte[]> $blockUpdates = this.getBlockUpdates();
        result = result * 59 + ($blockUpdates == null ? 43 : ((Object)$blockUpdates).hashCode());
        return result;
    }

    public @NonNull String toString() {
        return "LightUpdateData(skyYMask=" + String.valueOf(this.getSkyYMask()) + ", blockYMask=" + String.valueOf(this.getBlockYMask()) + ", emptySkyYMask=" + String.valueOf(this.getEmptySkyYMask()) + ", emptyBlockYMask=" + String.valueOf(this.getEmptyBlockYMask()) + ", skyUpdates=" + String.valueOf(this.getSkyUpdates()) + ", blockUpdates=" + String.valueOf(this.getBlockUpdates()) + ")";
    }

    public LightUpdateData(@lombok.NonNull BitSet skyYMask, @lombok.NonNull BitSet blockYMask, @lombok.NonNull BitSet emptySkyYMask, @lombok.NonNull BitSet emptyBlockYMask, @lombok.NonNull List<byte[]> skyUpdates, @lombok.NonNull List<byte[]> blockUpdates) {
        if (skyYMask == null) {
            throw new NullPointerException("skyYMask is marked non-null but is null");
        }
        if (blockYMask == null) {
            throw new NullPointerException("blockYMask is marked non-null but is null");
        }
        if (emptySkyYMask == null) {
            throw new NullPointerException("emptySkyYMask is marked non-null but is null");
        }
        if (emptyBlockYMask == null) {
            throw new NullPointerException("emptyBlockYMask is marked non-null but is null");
        }
        if (skyUpdates == null) {
            throw new NullPointerException("skyUpdates is marked non-null but is null");
        }
        if (blockUpdates == null) {
            throw new NullPointerException("blockUpdates is marked non-null but is null");
        }
        this.skyYMask = skyYMask;
        this.blockYMask = blockYMask;
        this.emptySkyYMask = emptySkyYMask;
        this.emptyBlockYMask = emptyBlockYMask;
        this.skyUpdates = skyUpdates;
        this.blockUpdates = blockUpdates;
    }
}

