/*
 * Decompiled with CFR 0.152.
 */
package org.cloudburstmc.protocol.bedrock.data;

import org.cloudburstmc.math.vector.Vector3i;
import org.cloudburstmc.protocol.bedrock.data.definitions.BlockDefinition;

public final class BlockChangeEntry {
    private final Vector3i position;
    private final BlockDefinition definition;
    private final int updateFlags;
    private final long messageEntityId;
    private final MessageType messageType;

    public BlockChangeEntry(Vector3i position, BlockDefinition definition, int updateFlags, long messageEntityId, MessageType messageType) {
        this.position = position;
        this.definition = definition;
        this.updateFlags = updateFlags;
        this.messageEntityId = messageEntityId;
        this.messageType = messageType;
    }

    public Vector3i getPosition() {
        return this.position;
    }

    public BlockDefinition getDefinition() {
        return this.definition;
    }

    public int getUpdateFlags() {
        return this.updateFlags;
    }

    public long getMessageEntityId() {
        return this.messageEntityId;
    }

    public MessageType getMessageType() {
        return this.messageType;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BlockChangeEntry)) {
            return false;
        }
        BlockChangeEntry other = (BlockChangeEntry)o;
        if (this.getUpdateFlags() != other.getUpdateFlags()) {
            return false;
        }
        if (this.getMessageEntityId() != other.getMessageEntityId()) {
            return false;
        }
        Vector3i this$position = this.getPosition();
        Vector3i other$position = other.getPosition();
        if (this$position == null ? other$position != null : !this$position.equals(other$position)) {
            return false;
        }
        BlockDefinition this$definition = this.getDefinition();
        BlockDefinition other$definition = other.getDefinition();
        if (this$definition == null ? other$definition != null : !this$definition.equals(other$definition)) {
            return false;
        }
        MessageType this$messageType = this.getMessageType();
        MessageType other$messageType = other.getMessageType();
        return !(this$messageType == null ? other$messageType != null : !((Object)((Object)this$messageType)).equals((Object)other$messageType));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getUpdateFlags();
        long $messageEntityId = this.getMessageEntityId();
        result = result * 59 + (int)($messageEntityId >>> 32 ^ $messageEntityId);
        Vector3i $position = this.getPosition();
        result = result * 59 + ($position == null ? 43 : $position.hashCode());
        BlockDefinition $definition = this.getDefinition();
        result = result * 59 + ($definition == null ? 43 : $definition.hashCode());
        MessageType $messageType = this.getMessageType();
        result = result * 59 + ($messageType == null ? 43 : ((Object)((Object)$messageType)).hashCode());
        return result;
    }

    public String toString() {
        return "BlockChangeEntry(position=" + this.getPosition() + ", definition=" + this.getDefinition() + ", updateFlags=" + this.getUpdateFlags() + ", messageEntityId=" + this.getMessageEntityId() + ", messageType=" + (Object)((Object)this.getMessageType()) + ")";
    }

    public static enum MessageType {
        NONE,
        CREATE,
        DESTROY;

    }
}

