/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.entity.type;

import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import net.kyori.adventure.text.Component;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.cloudburstmc.math.vector.Vector2f;
import org.cloudburstmc.math.vector.Vector3f;
import org.cloudburstmc.protocol.bedrock.data.entity.EntityDataTypes;
import org.cloudburstmc.protocol.bedrock.data.entity.EntityEventType;
import org.cloudburstmc.protocol.bedrock.data.entity.EntityFlag;
import org.cloudburstmc.protocol.bedrock.packet.AddEntityPacket;
import org.cloudburstmc.protocol.bedrock.packet.EntityEventPacket;
import org.cloudburstmc.protocol.bedrock.packet.MoveEntityAbsolutePacket;
import org.cloudburstmc.protocol.bedrock.packet.MoveEntityDeltaPacket;
import org.cloudburstmc.protocol.bedrock.packet.RemoveEntityPacket;
import org.cloudburstmc.protocol.bedrock.packet.SetEntityDataPacket;
import org.geysermc.geyser.api.entity.property.BatchPropertyUpdater;
import org.geysermc.geyser.api.entity.property.GeyserEntityProperty;
import org.geysermc.geyser.api.entity.type.GeyserEntity;
import org.geysermc.geyser.entity.EntityDefinition;
import org.geysermc.geyser.entity.GeyserDirtyMetadata;
import org.geysermc.geyser.entity.properties.GeyserEntityProperties;
import org.geysermc.geyser.entity.properties.GeyserEntityPropertyManager;
import org.geysermc.geyser.entity.properties.type.PropertyType;
import org.geysermc.geyser.entity.type.Leashable;
import org.geysermc.geyser.entity.type.living.MobEntity;
import org.geysermc.geyser.entity.type.player.PlayerEntity;
import org.geysermc.geyser.item.Items;
import org.geysermc.geyser.item.type.Item;
import org.geysermc.geyser.level.physics.BoundingBox;
import org.geysermc.geyser.scoreboard.Team;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.translator.text.MessageTranslator;
import org.geysermc.geyser.util.EntityUtils;
import org.geysermc.geyser.util.InteractionResult;
import org.geysermc.geyser.util.InteractiveTag;
import org.geysermc.geyser.util.MathUtils;
import org.geysermc.mcprotocollib.protocol.data.game.entity.metadata.EntityMetadata;
import org.geysermc.mcprotocollib.protocol.data.game.entity.metadata.Pose;
import org.geysermc.mcprotocollib.protocol.data.game.entity.metadata.type.BooleanEntityMetadata;
import org.geysermc.mcprotocollib.protocol.data.game.entity.metadata.type.ByteEntityMetadata;
import org.geysermc.mcprotocollib.protocol.data.game.entity.metadata.type.IntEntityMetadata;
import org.geysermc.mcprotocollib.protocol.data.game.entity.player.Hand;
import org.geysermc.mcprotocollib.protocol.data.game.entity.type.EntityType;

public class Entity
implements GeyserEntity {
    private static final boolean PRINT_ENTITY_SPAWN_DEBUG = Boolean.parseBoolean(System.getProperty("Geyser.PrintEntitySpawnDebug", "false"));
    protected final GeyserSession session;
    protected int entityId;
    protected final long geyserId;
    protected UUID uuid;
    protected String nametag = "";
    protected Vector3f position;
    protected Vector3f motion;
    protected float yaw;
    protected float pitch;
    protected float headYaw;
    protected boolean onGround;
    protected EntityDefinition<?> definition;
    protected boolean valid;
    private float boundingBoxHeight;
    private float boundingBoxWidth;
    protected String displayName;
    protected boolean silent = false;
    protected List<Entity> passengers = Collections.emptyList();
    protected Entity vehicle;
    protected final GeyserDirtyMetadata dirtyMetadata = new GeyserDirtyMetadata();
    protected final EnumSet<EntityFlag> flags = EnumSet.noneOf(EntityFlag.class);
    private boolean flagsDirty = false;
    protected final GeyserEntityPropertyManager propertyManager;

    public Entity(GeyserSession session, int entityId, long geyserId, UUID uuid, EntityDefinition<?> definition, Vector3f position, Vector3f motion, float yaw, float pitch, float headYaw) {
        this.session = session;
        this.definition = definition;
        this.displayName = this.standardDisplayName();
        this.entityId = entityId;
        this.geyserId = geyserId;
        this.uuid = uuid;
        this.motion = motion;
        this.yaw = yaw;
        this.pitch = pitch;
        this.headYaw = headYaw;
        this.valid = false;
        this.propertyManager = definition.registeredProperties() == null ? null : new GeyserEntityPropertyManager(definition.registeredProperties());
        this.setPosition(position);
        this.setAirSupply(this.getMaxAir());
        this.initializeMetadata();
    }

    protected void initializeMetadata() {
        this.dirtyMetadata.put(EntityDataTypes.SCALE, Float.valueOf(1.0f));
        this.dirtyMetadata.put(EntityDataTypes.COLOR, (byte)0);
        this.dirtyMetadata.put(EntityDataTypes.AIR_SUPPLY_MAX, this.getMaxAir());
        this.setDimensionsFromPose(Pose.STANDING);
        this.setFlag(EntityFlag.HAS_GRAVITY, true);
        this.setFlag(EntityFlag.HAS_COLLISION, true);
        this.setFlag(EntityFlag.CAN_SHOW_NAME, true);
        this.setFlag(EntityFlag.CAN_CLIMB, true);
        this.setFlag(EntityFlag.HIDDEN_WHEN_INVISIBLE, true);
        this.setClientSideSilent();
    }

    protected void setClientSideSilent() {
        this.setFlag(EntityFlag.SILENT, true);
    }

    public void spawnEntity() {
        AddEntityPacket addEntityPacket = new AddEntityPacket();
        addEntityPacket.setIdentifier(this.definition.identifier());
        addEntityPacket.setRuntimeEntityId(this.geyserId);
        addEntityPacket.setUniqueEntityId(this.geyserId);
        addEntityPacket.setPosition(this.position);
        addEntityPacket.setMotion(this.motion);
        addEntityPacket.setRotation(Vector2f.from(this.pitch, this.yaw));
        addEntityPacket.setHeadRotation(this.headYaw);
        addEntityPacket.setBodyRotation(this.yaw);
        addEntityPacket.getMetadata().putFlags(this.flags);
        this.dirtyMetadata.apply(addEntityPacket.getMetadata());
        if (this.propertyManager != null) {
            this.propertyManager.applyIntProperties(addEntityPacket.getProperties().getIntProperties());
            this.propertyManager.applyFloatProperties(addEntityPacket.getProperties().getFloatProperties());
        }
        this.addAdditionalSpawnData(addEntityPacket);
        this.valid = true;
        this.session.sendUpstreamPacket(addEntityPacket);
        this.flagsDirty = false;
        if (this.session.getGeyser().getConfig().isDebugMode() && PRINT_ENTITY_SPAWN_DEBUG) {
            EntityType type = this.definition.entityType();
            String name = type != null ? type.name() : this.getClass().getSimpleName();
            this.session.getGeyser().getLogger().debug("Spawned entity " + name + " at location " + String.valueOf(this.position) + " with id " + this.geyserId + " (java id " + this.entityId + ")");
        }
    }

    public void addAdditionalSpawnData(AddEntityPacket addEntityPacket) {
    }

    public void despawnEntity() {
        if (!this.valid) {
            return;
        }
        for (Entity passenger : this.passengers) {
            if (passenger == null) continue;
            passenger.setVehicle(null);
            passenger.setFlag(EntityFlag.RIDING, false);
            passenger.updateBedrockMetadata();
        }
        RemoveEntityPacket removeEntityPacket = new RemoveEntityPacket();
        removeEntityPacket.setUniqueEntityId(this.geyserId);
        this.session.sendUpstreamPacket(removeEntityPacket);
        this.valid = false;
    }

    public void moveRelative(double relX, double relY, double relZ, float yaw, float pitch, boolean isOnGround) {
        this.moveRelative(relX, relY, relZ, yaw, pitch, this.getHeadYaw(), isOnGround);
    }

    public void moveRelative(double relX, double relY, double relZ, float yaw, float pitch, float headYaw, boolean isOnGround) {
        this.position = Vector3f.from((double)this.position.getX() + relX, (double)this.position.getY() + relY, (double)this.position.getZ() + relZ);
        MoveEntityDeltaPacket moveEntityPacket = new MoveEntityDeltaPacket();
        moveEntityPacket.setRuntimeEntityId(this.geyserId);
        if (relX != 0.0) {
            moveEntityPacket.setX(this.position.getX());
            moveEntityPacket.getFlags().add(MoveEntityDeltaPacket.Flag.HAS_X);
        }
        if (relY != 0.0) {
            moveEntityPacket.setY(this.position.getY());
            moveEntityPacket.getFlags().add(MoveEntityDeltaPacket.Flag.HAS_Y);
        }
        if (relZ != 0.0) {
            moveEntityPacket.setZ(this.position.getZ());
            moveEntityPacket.getFlags().add(MoveEntityDeltaPacket.Flag.HAS_Z);
        }
        if (pitch != this.pitch) {
            this.pitch = pitch;
            moveEntityPacket.setPitch(pitch);
            moveEntityPacket.getFlags().add(MoveEntityDeltaPacket.Flag.HAS_PITCH);
        }
        if (yaw != this.yaw) {
            this.yaw = yaw;
            moveEntityPacket.setYaw(yaw);
            moveEntityPacket.getFlags().add(MoveEntityDeltaPacket.Flag.HAS_YAW);
        }
        if (headYaw != this.headYaw) {
            this.headYaw = headYaw;
            moveEntityPacket.setHeadYaw(headYaw);
            moveEntityPacket.getFlags().add(MoveEntityDeltaPacket.Flag.HAS_HEAD_YAW);
        }
        this.setOnGround(isOnGround);
        if (isOnGround) {
            moveEntityPacket.getFlags().add(MoveEntityDeltaPacket.Flag.ON_GROUND);
        }
        this.session.sendUpstreamPacket(moveEntityPacket);
    }

    public void moveAbsolute(Vector3f position, float yaw, float pitch, boolean isOnGround, boolean teleported) {
        this.moveAbsolute(position, yaw, pitch, this.getHeadYaw(), isOnGround, teleported);
    }

    public void moveAbsolute(Vector3f position, float yaw, float pitch, float headYaw, boolean isOnGround, boolean teleported) {
        this.setPosition(position);
        this.setYaw(yaw);
        this.setPitch(pitch);
        this.setHeadYaw(headYaw);
        this.setOnGround(isOnGround);
        MoveEntityAbsolutePacket moveEntityPacket = new MoveEntityAbsolutePacket();
        moveEntityPacket.setRuntimeEntityId(this.geyserId);
        moveEntityPacket.setPosition(position);
        moveEntityPacket.setRotation(this.getBedrockRotation());
        moveEntityPacket.setOnGround(isOnGround);
        moveEntityPacket.setTeleported(teleported);
        this.session.sendUpstreamPacket(moveEntityPacket);
    }

    public void teleport(Vector3f position, float yaw, float pitch, boolean isOnGround) {
        this.moveAbsolute(position, yaw, pitch, yaw, isOnGround, false);
    }

    public void updateHeadLookRotation(float headYaw) {
        this.moveRelative(0.0, 0.0, 0.0, this.getYaw(), this.getPitch(), headYaw, this.isOnGround());
    }

    public void updatePositionAndRotation(double moveX, double moveY, double moveZ, float yaw, float pitch, boolean isOnGround) {
        this.moveRelative(moveX, moveY, moveZ, yaw, pitch, this.getHeadYaw(), isOnGround);
    }

    public void updateRotation(float yaw, float pitch, boolean isOnGround) {
        this.updatePositionAndRotation(0.0, 0.0, 0.0, yaw, pitch, isOnGround);
    }

    public final boolean getFlag(EntityFlag flag) {
        return this.flags.contains((Object)flag);
    }

    public final void setFlag(EntityFlag flag, boolean value) {
        this.flagsDirty |= value ? this.flags.add(flag) : this.flags.remove((Object)flag);
    }

    public void updateBedrockMetadata() {
        if (!this.isValid()) {
            return;
        }
        if (this.dirtyMetadata.hasEntries() || this.flagsDirty) {
            SetEntityDataPacket entityDataPacket = new SetEntityDataPacket();
            entityDataPacket.setRuntimeEntityId(this.geyserId);
            if (this.flagsDirty) {
                entityDataPacket.getMetadata().putFlags(this.flags);
                this.flagsDirty = false;
            }
            this.dirtyMetadata.apply(entityDataPacket.getMetadata());
            if (this.propertyManager != null && this.propertyManager.hasProperties()) {
                this.propertyManager.applyIntProperties(entityDataPacket.getProperties().getIntProperties());
                this.propertyManager.applyFloatProperties(entityDataPacket.getProperties().getFloatProperties());
            }
            this.session.sendUpstreamPacket(entityDataPacket);
        }
    }

    public void updateBedrockEntityProperties() {
        if (!this.valid) {
            return;
        }
        if (this.propertyManager != null && this.propertyManager.hasProperties()) {
            SetEntityDataPacket entityDataPacket = new SetEntityDataPacket();
            entityDataPacket.setRuntimeEntityId(this.geyserId);
            this.propertyManager.applyIntProperties(entityDataPacket.getProperties().getIntProperties());
            this.propertyManager.applyFloatProperties(entityDataPacket.getProperties().getFloatProperties());
            this.session.sendUpstreamPacket(entityDataPacket);
        }
    }

    public void setFlags(ByteEntityMetadata entityMetadata) {
        byte xd = entityMetadata.getPrimitiveValue();
        this.setFlag(EntityFlag.ON_FIRE, (xd & 1) == 1 && !this.getFlag(EntityFlag.FIRE_IMMUNE));
        this.setSneaking((xd & 2) == 2);
        this.setSprinting((xd & 8) == 8);
        this.setGliding((xd & 0x80) == 128);
        this.setInvisible((xd & 0x20) == 32);
    }

    protected void setInvisible(boolean value) {
        this.setFlag(EntityFlag.INVISIBLE, value);
    }

    protected void setGliding(boolean value) {
        this.setFlag(EntityFlag.GLIDING, value);
    }

    protected void setSprinting(boolean value) {
        this.setFlag(EntityFlag.SPRINTING, value);
    }

    protected void setSneaking(boolean value) {
        this.setFlag(EntityFlag.SNEAKING, value);
    }

    public final void setAir(IntEntityMetadata entityMetadata) {
        this.setAirSupply(entityMetadata.getPrimitiveValue());
    }

    protected void setAirSupply(int amount) {
        this.dirtyMetadata.put(EntityDataTypes.AIR_SUPPLY, (short)MathUtils.constrain(amount, 0, this.getMaxAir()));
    }

    protected short getMaxAir() {
        return 300;
    }

    public String teamIdentifier() {
        return this.uuid != null ? this.uuid.toString() : null;
    }

    public void setDisplayName(EntityMetadata<Optional<Component>, ?> entityMetadata) {
        Optional<Component> name = entityMetadata.getValue();
        if (name.isPresent()) {
            String displayName;
            this.displayName = displayName = MessageTranslator.convertMessage(name.get(), this.session.locale());
            this.setNametag(displayName, true);
            return;
        }
        this.displayName = this.standardDisplayName();
        this.setNametag(null, true);
    }

    protected String standardDisplayName() {
        return EntityUtils.translatedEntityName(this.definition.entityType(), this.session);
    }

    protected void setNametag(@Nullable String nametag, boolean fromDisplayName) {
        Team team;
        if (nametag != null && fromDisplayName && (team = this.session.getWorldCache().getScoreboard().getTeamFor(this.teamIdentifier())) != null) {
            this.updateNametag(team);
            return;
        }
        if (nametag == null) {
            nametag = "";
        }
        boolean changed = !Objects.equals(this.nametag, nametag);
        this.nametag = nametag;
        if (!changed) {
            return;
        }
        this.dirtyMetadata.put(EntityDataTypes.NAME, nametag);
        this.scoreVisibility(!nametag.isEmpty());
    }

    public void updateNametag(@Nullable Team team) {
        this.updateNametag(team, true);
    }

    protected void updateNametag(@Nullable Team team, boolean visible) {
        if (team != null) {
            String newNametag = visible ? team.displayName(this.getDisplayName()) : "";
            this.setNametag(newNametag, false);
            return;
        }
        this.setNametag(null, false);
    }

    protected void scoreVisibility(boolean show) {
    }

    public void setDisplayNameVisible(BooleanEntityMetadata entityMetadata) {
        this.dirtyMetadata.put(EntityDataTypes.NAMETAG_ALWAYS_SHOW, (byte)(entityMetadata.getPrimitiveValue() ? 1 : 0));
    }

    public final void setSilent(BooleanEntityMetadata entityMetadata) {
        this.silent = entityMetadata.getPrimitiveValue();
    }

    public void setGravity(BooleanEntityMetadata entityMetadata) {
        this.setFlag(EntityFlag.HAS_GRAVITY, !entityMetadata.getPrimitiveValue());
    }

    public void setPose(Pose pose) {
        this.setFlag(EntityFlag.SLEEPING, pose.equals((Object)Pose.SLEEPING));
        this.setFlag(EntityFlag.SWIMMING, pose.equals((Object)Pose.SWIMMING));
        this.setDimensionsFromPose(pose);
    }

    protected void setDimensionsFromPose(Pose pose) {
        this.setBoundingBoxHeight(this.definition.height());
        this.setBoundingBoxWidth(this.definition.width());
    }

    public boolean setBoundingBoxHeight(float height) {
        if (height != this.boundingBoxHeight) {
            this.boundingBoxHeight = height;
            this.dirtyMetadata.put(EntityDataTypes.HEIGHT, Float.valueOf(this.boundingBoxHeight));
            this.updatePassengerOffsets();
            return true;
        }
        return false;
    }

    public void setBoundingBoxWidth(float width) {
        if (width != this.boundingBoxWidth) {
            this.boundingBoxWidth = width;
            this.dirtyMetadata.put(EntityDataTypes.WIDTH, Float.valueOf(this.boundingBoxWidth));
        }
    }

    public float setFreezing(IntEntityMetadata entityMetadata) {
        int freezingTicks = Math.min(entityMetadata.getPrimitiveValue(), 140);
        float freezingPercentage = (float)freezingTicks / 140.0f;
        this.dirtyMetadata.put(EntityDataTypes.FREEZING_EFFECT_STRENGTH, Float.valueOf(freezingPercentage));
        return freezingPercentage;
    }

    public void setRiderSeatPosition(Vector3f position) {
        this.dirtyMetadata.put(EntityDataTypes.SEAT_OFFSET, position);
    }

    protected boolean isShaking() {
        return false;
    }

    public Vector3f getBedrockRotation() {
        return Vector3f.from(this.getPitch(), this.getYaw(), this.getHeadYaw());
    }

    protected void updatePassengerOffsets() {
        for (int i = 0; i < this.passengers.size(); ++i) {
            Entity passenger = this.passengers.get(i);
            if (passenger == null) continue;
            boolean rider = i == 0;
            EntityUtils.updateMountOffset(passenger, this, rider, true, i, this.passengers.size());
            passenger.updateBedrockMetadata();
        }
    }

    protected void updateMountOffset() {
        if (this.vehicle != null) {
            boolean rider = this.vehicle.getPassengers().get(0) == this;
            EntityUtils.updateMountOffset(this, this.vehicle, rider, true, this.vehicle.getPassengers().indexOf(this), this.vehicle.getPassengers().size());
            this.updateBedrockMetadata();
        }
    }

    @Override
    public int javaId() {
        return this.entityId;
    }

    public boolean isAlive() {
        return this.valid;
    }

    public final void updateInteractiveTag() {
        Hand hand;
        InteractiveTag tag = InteractiveTag.NONE;
        Hand[] handArray = EntityUtils.HANDS;
        int n = handArray.length;
        for (int i = 0; i < n && (tag = this.testInteraction(hand = handArray[i])) == InteractiveTag.NONE; ++i) {
        }
        this.session.getPlayerEntity().getDirtyMetadata().put(EntityDataTypes.INTERACT_TEXT, tag.getValue());
        this.session.getPlayerEntity().updateBedrockMetadata();
    }

    protected InteractiveTag testInteraction(Hand hand) {
        Entity entity;
        if (this.isAlive() && (entity = this) instanceof Leashable) {
            Leashable leashable = (Leashable)((Object)entity);
            if (leashable.leashHolderBedrockId() == this.session.getPlayerEntity().getGeyserId()) {
                return InteractiveTag.REMOVE_LEASH;
            }
            if (this.session.getPlayerInventory().getItemInHand(hand).is(Items.LEAD) && leashable.canBeLeashed()) {
                return InteractiveTag.LEASH;
            }
        }
        return InteractiveTag.NONE;
    }

    public InteractionResult interact(Hand hand) {
        Entity entity;
        Item itemInHand = this.session.getPlayerInventory().getItemInHand(hand).asItem();
        if (itemInHand == Items.SHEARS) {
            if (this.hasLeashesToDrop()) {
                return InteractionResult.SUCCESS;
            }
            Entity entity2 = this;
            if (entity2 instanceof MobEntity) {
                MobEntity mob = (MobEntity)entity2;
                if (!this.session.isSneaking() && mob.canShearEquipment()) {
                    return InteractionResult.SUCCESS;
                }
            }
        } else if (this.isAlive() && (entity = this) instanceof Leashable) {
            Leashable leashable = (Leashable)((Object)entity);
            if (leashable.leashHolderBedrockId() == this.session.getPlayerEntity().getGeyserId()) {
                return InteractionResult.SUCCESS;
            }
            if (this.session.getPlayerInventory().getItemInHand(hand).is(Items.LEAD) && !(this.session.getEntityCache().getEntityByGeyserId(leashable.leashHolderBedrockId()) instanceof PlayerEntity)) {
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    public boolean hasLeashesToDrop() {
        Leashable leashable;
        BoundingBox searchBB = new BoundingBox(this.position.getX(), this.position.getY(), this.position.getZ(), 32.0, 32.0, 32.0);
        List<Leashable> leashedInRange = this.session.getEntityCache().getEntities().values().stream().filter(entity -> {
            Leashable leashablex;
            return entity instanceof Leashable && (leashablex = (Leashable)((Object)entity)).leashHolderBedrockId() == this.getGeyserId();
        }).filter(entity -> {
            BoundingBox leashedBB = new BoundingBox(entity.position.toDouble(), entity.boundingBoxWidth, entity.boundingBoxHeight, entity.boundingBoxWidth);
            return searchBB.checkIntersection(leashedBB);
        }).map(Leashable.class::cast).toList();
        boolean found = !leashedInRange.isEmpty();
        Entity entity2 = this;
        if (entity2 instanceof Leashable && (leashable = (Leashable)((Object)entity2)).isLeashed()) {
            found = true;
        }
        return found;
    }

    public InteractionResult interactAt(Hand hand) {
        return InteractionResult.PASS;
    }

    public final void playEntityEvent(EntityEventType type) {
        this.playEntityEvent(type, 0);
    }

    public final void playEntityEvent(EntityEventType type, int data) {
        EntityEventPacket packet = new EntityEventPacket();
        packet.setRuntimeEntityId(this.geyserId);
        packet.setType(type);
        packet.setData(data);
        this.session.sendUpstreamPacket(packet);
    }

    @Override
    public void updatePropertiesBatched(Consumer<BatchPropertyUpdater> consumer) {
        if (this.propertyManager != null) {
            Objects.requireNonNull(consumer);
            final GeyserEntityProperties propertyDefinitions = this.definition.registeredProperties();
            consumer.accept(new BatchPropertyUpdater(){

                @Override
                public <T> void update(@NonNull GeyserEntityProperty<T> property, @Nullable T value) {
                    Objects.requireNonNull(property, "property must not be null!");
                    if (!(property instanceof PropertyType)) {
                        throw new IllegalArgumentException("Invalid property implementation! Got: " + property.getClass().getSimpleName());
                    }
                    PropertyType propertyType = (PropertyType)property;
                    int index = propertyDefinitions.getPropertyIndex(property.identifier().toString());
                    if (index < 0) {
                        throw new IllegalArgumentException("No property with the name " + String.valueOf(property.identifier()) + " has been registered.");
                    }
                    PropertyType<?, ?> expectedProperty = propertyDefinitions.getProperties().get(index);
                    if (!expectedProperty.equals(propertyType)) {
                        throw new IllegalArgumentException("The supplied property was not registered with this entity type!");
                    }
                    propertyType.apply(Entity.this.propertyManager, value);
                }
            });
            if (this.propertyManager.hasProperties()) {
                SetEntityDataPacket packet = new SetEntityDataPacket();
                packet.setRuntimeEntityId(this.getGeyserId());
                this.propertyManager.applyFloatProperties(packet.getProperties().getFloatProperties());
                this.propertyManager.applyIntProperties(packet.getProperties().getIntProperties());
                this.session.sendUpstreamPacket(packet);
            }
        } else {
            throw new IllegalArgumentException("Given entity has no registered properties!");
        }
    }

    public GeyserSession getSession() {
        return this.session;
    }

    public int getEntityId() {
        return this.entityId;
    }

    public long getGeyserId() {
        return this.geyserId;
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public String getNametag() {
        return this.nametag;
    }

    public Vector3f getPosition() {
        return this.position;
    }

    public Vector3f getMotion() {
        return this.motion;
    }

    public float getYaw() {
        return this.yaw;
    }

    public float getPitch() {
        return this.pitch;
    }

    public float getHeadYaw() {
        return this.headYaw;
    }

    public boolean isOnGround() {
        return this.onGround;
    }

    public EntityDefinition<?> getDefinition() {
        return this.definition;
    }

    public boolean isValid() {
        return this.valid;
    }

    public float getBoundingBoxHeight() {
        return this.boundingBoxHeight;
    }

    public float getBoundingBoxWidth() {
        return this.boundingBoxWidth;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public boolean isSilent() {
        return this.silent;
    }

    public List<Entity> getPassengers() {
        return this.passengers;
    }

    public Entity getVehicle() {
        return this.vehicle;
    }

    public GeyserDirtyMetadata getDirtyMetadata() {
        return this.dirtyMetadata;
    }

    public GeyserEntityPropertyManager getPropertyManager() {
        return this.propertyManager;
    }

    public void setEntityId(int entityId) {
        this.entityId = entityId;
    }

    public void setUuid(UUID uuid) {
        this.uuid = uuid;
    }

    public void setPosition(Vector3f position) {
        this.position = position;
    }

    public void setMotion(Vector3f motion) {
        this.motion = motion;
    }

    public void setYaw(float yaw) {
        this.yaw = yaw;
    }

    public void setPitch(float pitch) {
        this.pitch = pitch;
    }

    public void setHeadYaw(float headYaw) {
        this.headYaw = headYaw;
    }

    public void setOnGround(boolean onGround) {
        this.onGround = onGround;
    }

    public void setDefinition(EntityDefinition<?> definition) {
        this.definition = definition;
    }

    public void setValid(boolean valid) {
        this.valid = valid;
    }

    public void setPassengers(List<Entity> passengers) {
        this.passengers = passengers;
    }

    public void setVehicle(Entity vehicle) {
        this.vehicle = vehicle;
    }

    protected void setFlagsDirty(boolean flagsDirty) {
        this.flagsDirty = flagsDirty;
    }
}

