/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.registry.loader;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import org.cloudburstmc.nbt.NbtMap;
import org.cloudburstmc.nbt.NbtType;
import org.geysermc.geyser.inventory.recipe.GeyserRecipe;
import org.geysermc.geyser.platform.velocity.shaded.it.unimi.dsi.fastutil.objects.ObjectArrayList;
import org.geysermc.geyser.registry.loader.RegistryLoader;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftTypes;
import org.geysermc.mcprotocollib.protocol.data.game.item.ItemStack;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.DataComponents;
import org.geysermc.mcprotocollib.protocol.data.game.recipe.Ingredient;

public abstract class RecipeRegistryLoader
implements RegistryLoader<String, Map<Object, List<GeyserRecipe>>> {
    private static List<GeyserRecipe> getShapelessRecipes(List<NbtMap> recipes) {
        ObjectArrayList<GeyserRecipe> deserializedRecipes = new ObjectArrayList<GeyserRecipe>(recipes.size());
        for (NbtMap recipe : recipes) {
            ItemStack output = RecipeRegistryLoader.toItemStack(recipe.getCompound("output"));
            List<NbtMap> rawInputs = recipe.getList("inputs", NbtType.COMPOUND);
            Ingredient[] javaInputs = new Ingredient[rawInputs.size()];
            for (int i = 0; i < rawInputs.size(); ++i) {
            }
        }
        return deserializedRecipes;
    }

    private static List<GeyserRecipe> getShapedRecipes(List<NbtMap> recipes) {
        ObjectArrayList<GeyserRecipe> deserializedRecipes = new ObjectArrayList<GeyserRecipe>(recipes.size());
        for (NbtMap recipe : recipes) {
            ItemStack output = RecipeRegistryLoader.toItemStack(recipe.getCompound("output"));
            List<int[]> shape = recipe.getList("shape", NbtType.INT_ARRAY);
            ArrayList<ItemStack> letterToRecipe = new ArrayList<ItemStack>();
            for (NbtMap rawInput : recipe.getList("inputs", NbtType.COMPOUND)) {
                letterToRecipe.add(RecipeRegistryLoader.toItemStack(rawInput));
            }
            Ingredient[] inputs = new Ingredient[shape.size() * shape.get(0).length];
            int i = 0;
            int j = 0;
            while (i < shape.size() * shape.get(0).length) {
                for (int index : shape.get(j)) {
                    ItemStack itemStack = (ItemStack)letterToRecipe.get(index);
                }
                ++j;
            }
        }
        return deserializedRecipes;
    }

    private static ItemStack toItemStack(NbtMap nbt) {
        int id = nbt.getInt("id");
        int count = nbt.getInt("count", 1);
        String componentsRaw = nbt.getString("components", null);
        if (componentsRaw != null) {
            byte[] bytes = Base64.getDecoder().decode(componentsRaw);
            ByteBuf buf = Unpooled.wrappedBuffer((byte[])bytes);
            DataComponents components = MinecraftTypes.readDataComponentPatch(buf, false);
            return new ItemStack(id, count, components);
        }
        return new ItemStack(id, count);
    }
}

