/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.inventory.chest;

import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.cloudburstmc.math.vector.Vector3i;
import org.cloudburstmc.nbt.NbtMap;
import org.cloudburstmc.nbt.NbtMapBuilder;
import org.cloudburstmc.protocol.bedrock.data.inventory.ContainerType;
import org.cloudburstmc.protocol.bedrock.packet.BlockEntityDataPacket;
import org.cloudburstmc.protocol.bedrock.packet.ContainerClosePacket;
import org.cloudburstmc.protocol.bedrock.packet.ContainerOpenPacket;
import org.cloudburstmc.protocol.bedrock.packet.UpdateBlockPacket;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.inventory.Container;
import org.geysermc.geyser.inventory.Inventory;
import org.geysermc.geyser.level.block.Blocks;
import org.geysermc.geyser.level.block.property.ChestType;
import org.geysermc.geyser.level.block.property.Properties;
import org.geysermc.geyser.level.block.type.BlockState;
import org.geysermc.geyser.level.physics.Direction;
import org.geysermc.geyser.platform.velocity.shaded.it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import org.geysermc.geyser.registry.BlockRegistries;
import org.geysermc.geyser.registry.type.GeyserBedrockBlock;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.translator.inventory.chest.ChestInventoryTranslator;
import org.geysermc.geyser.translator.level.block.entity.BlockEntityTranslator;
import org.geysermc.geyser.translator.level.block.entity.DoubleChestBlockEntityTranslator;
import org.geysermc.geyser.util.InventoryUtils;

public class DoubleChestInventoryTranslator
extends ChestInventoryTranslator<Container> {
    private final int defaultJavaBlockState = Blocks.CHEST.defaultBlockState().withValue(Properties.HORIZONTAL_FACING, Direction.NORTH).withValue(Properties.CHEST_TYPE, ChestType.SINGLE).javaId();

    public DoubleChestInventoryTranslator(int size) {
        super(size, 54);
    }

    @Override
    public boolean canReuseInventory(GeyserSession session, @NonNull Inventory newInventory, @NonNull Inventory oldInventory) {
        if (!(super.canReuseInventory(session, newInventory, oldInventory) && newInventory instanceof Container && oldInventory instanceof Container)) {
            return false;
        }
        Container previous = (Container)oldInventory;
        if (previous.isUsingRealBlock()) {
            return false;
        }
        Vector3i position = InventoryUtils.findAvailableWorldSpace(session);
        if (Objects.equals(position, previous.getHolderPosition())) {
            return true;
        }
        GeyserImpl.getInstance().getLogger().debug(session, "Not reusing inventory due to virtual block holder changing (%s -> %s)!", previous.getHolderPosition(), position);
        return false;
    }

    @Override
    public boolean prepareInventory(GeyserSession session, Container container) {
        if (this.canUseRealBlock(session, container)) {
            return true;
        }
        Vector3i position = InventoryUtils.findAvailableWorldSpace(session);
        if (position == null) {
            return false;
        }
        Vector3i pairPosition = position.add(Vector3i.UNIT_X);
        GeyserBedrockBlock definition = session.getBlockMappings().getVanillaBedrockBlock(this.defaultJavaBlockState);
        UpdateBlockPacket blockPacket = new UpdateBlockPacket();
        blockPacket.setDataLayer(0);
        blockPacket.setBlockPosition(position);
        blockPacket.setDefinition(definition);
        blockPacket.getFlags().addAll(UpdateBlockPacket.FLAG_ALL_PRIORITY);
        session.sendUpstreamPacket(blockPacket);
        NbtMapBuilder tag = BlockEntityTranslator.getConstantBedrockTag("Chest", position).putInt("pairx", pairPosition.getX()).putInt("pairz", pairPosition.getZ()).putString("CustomName", container.getTitle()).putBoolean("pairlead", false);
        BlockEntityDataPacket dataPacket = new BlockEntityDataPacket();
        dataPacket.setData(tag.build());
        dataPacket.setBlockPosition(position);
        session.sendUpstreamPacket(dataPacket);
        blockPacket = new UpdateBlockPacket();
        blockPacket.setDataLayer(0);
        blockPacket.setBlockPosition(pairPosition);
        blockPacket.setDefinition(definition);
        blockPacket.getFlags().addAll(UpdateBlockPacket.FLAG_ALL_PRIORITY);
        session.sendUpstreamPacket(blockPacket);
        tag = NbtMap.builder().putString("id", "Chest").putInt("x", pairPosition.getX()).putInt("y", pairPosition.getY()).putInt("z", pairPosition.getZ()).putInt("pairx", position.getX()).putInt("pairz", position.getZ()).putString("CustomName", container.getTitle()).putBoolean("pairlead", true);
        dataPacket = new BlockEntityDataPacket();
        dataPacket.setData(tag.build());
        dataPacket.setBlockPosition(pairPosition);
        session.sendUpstreamPacket(dataPacket);
        container.setHolderPosition(position);
        return true;
    }

    @Override
    public void openInventory(GeyserSession session, Container container) {
        ContainerOpenPacket containerOpenPacket = new ContainerOpenPacket();
        containerOpenPacket.setId((byte)container.getBedrockId());
        containerOpenPacket.setType(ContainerType.CONTAINER);
        containerOpenPacket.setBlockPosition(container.getHolderPosition());
        containerOpenPacket.setUniqueEntityId(container.getHolderId());
        session.sendUpstreamPacket(containerOpenPacket);
        GeyserImpl.getInstance().getLogger().debug(session, containerOpenPacket.toString(), new Object[0]);
    }

    @Override
    public void closeInventory(GeyserSession session, Container container, boolean force) {
        if (container.isDisplayed()) {
            ContainerClosePacket packet = new ContainerClosePacket();
            packet.setId((byte)container.getBedrockId());
            packet.setServerInitiated(true);
            packet.setType(ContainerType.CONTAINER);
            session.sendUpstreamPacket(packet);
        }
        if (!container.isUsingRealBlock()) {
            Vector3i holderPos = container.getHolderPosition();
            int realBlock = session.getGeyser().getWorldManager().getBlockAt(session, holderPos);
            UpdateBlockPacket blockPacket = new UpdateBlockPacket();
            blockPacket.setDataLayer(0);
            blockPacket.setBlockPosition(holderPos);
            blockPacket.setDefinition(session.getBlockMappings().getBedrockBlock(realBlock));
            session.sendUpstreamPacket(blockPacket);
            holderPos = holderPos.add(Vector3i.UNIT_X);
            realBlock = session.getGeyser().getWorldManager().getBlockAt(session, holderPos);
            blockPacket = new UpdateBlockPacket();
            blockPacket.setDataLayer(0);
            blockPacket.setBlockPosition(holderPos);
            blockPacket.setDefinition(session.getBlockMappings().getBedrockBlock(realBlock));
            session.sendUpstreamPacket(blockPacket);
        }
    }

    private boolean canUseRealBlock(GeyserSession session, Container container) {
        if (session.getLastInteractionPlayerPosition().equals(session.getPlayerEntity().getPosition())) {
            BlockState state = session.getGeyser().getWorldManager().blockAt(session, session.getLastInteractionBlockPosition());
            if (!(((Int2ObjectMap)BlockRegistries.CUSTOM_BLOCK_STATE_OVERRIDES.get()).containsKey(state.javaId()) || state.block() != Blocks.CHEST && state.block() != Blocks.TRAPPED_CHEST || state.getValue(Properties.CHEST_TYPE) == ChestType.SINGLE)) {
                container.setHolderPosition(session.getLastInteractionBlockPosition());
                container.setUsingRealBlock(true, state.block());
                NbtMapBuilder tag = BlockEntityTranslator.getConstantBedrockTag("Chest", session.getLastInteractionBlockPosition()).putString("CustomName", container.getTitle());
                DoubleChestBlockEntityTranslator.translateChestValue(tag, state, session.getLastInteractionBlockPosition().getX(), session.getLastInteractionBlockPosition().getZ());
                BlockEntityDataPacket dataPacket = new BlockEntityDataPacket();
                dataPacket.setData(tag.build());
                dataPacket.setBlockPosition(session.getLastInteractionBlockPosition());
                session.sendUpstreamPacket(dataPacket);
                return true;
            }
        }
        return false;
    }
}

