/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.mcprotocollib.protocol.data.game.item.component;

import io.netty.buffer.ByteBuf;
import net.kyori.adventure.key.KeyPattern;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.DataComponent;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.DataComponentType;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.type.IntDataComponent;

public class IntComponentType
extends DataComponentType<Integer> {
    protected final IntReader primitiveReader;
    protected final IntWriter primitiveWriter;
    protected final IntDataComponentFactory primitiveFactory;

    protected IntComponentType(int id, @KeyPattern String key, IntReader reader, IntWriter writer, IntDataComponentFactory metadataFactory) {
        super(id, key, reader, writer, metadataFactory);
        this.primitiveReader = reader;
        this.primitiveWriter = writer;
        this.primitiveFactory = metadataFactory;
    }

    @Override
    public DataComponent<Integer, IntComponentType> readDataComponent(ByteBuf input) {
        return this.primitiveFactory.createPrimitive(this, this.primitiveReader.readPrimitive(input));
    }

    @Override
    public DataComponent<Integer, IntComponentType> readNullDataComponent() {
        return this.primitiveFactory.createPrimitive(this, null);
    }

    public void writeDataComponentPrimitive(ByteBuf output, int value) {
        this.primitiveWriter.writePrimitive(output, value);
    }

    @Override
    public String toString() {
        return "IntComponentType(id=" + this.id + " , key=" + this.key.asString() + ")";
    }

    @FunctionalInterface
    public static interface IntReader
    extends DataComponentType.Reader<Integer> {
        public int readPrimitive(ByteBuf var1);

        @Override
        @Deprecated
        default public Integer read(ByteBuf input) {
            return this.readPrimitive(input);
        }
    }

    @FunctionalInterface
    public static interface IntWriter
    extends DataComponentType.Writer<Integer> {
        public void writePrimitive(ByteBuf var1, int var2);

        @Override
        @Deprecated
        default public void write(ByteBuf output, Integer value) {
            this.writePrimitive(output, value);
        }
    }

    @FunctionalInterface
    public static interface IntDataComponentFactory
    extends DataComponentType.DataComponentFactory<Integer> {
        public IntDataComponent createPrimitive(IntComponentType var1, Integer var2);

        @Override
        @Deprecated
        default public DataComponent<Integer, IntComponentType> create(DataComponentType<Integer> type, Integer value) {
            throw new UnsupportedOperationException("Unsupported read method! Use primitive createPrimitive!");
        }
    }
}

