/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.mcprotocollib.protocol.packet.ingame.clientbound.inventory;

import io.netty.buffer.ByteBuf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftPacket;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftTypes;

public class ClientboundContainerClosePacket
implements MinecraftPacket {
    private final int containerId;

    public ClientboundContainerClosePacket(ByteBuf in) {
        this.containerId = MinecraftTypes.readVarInt(in);
    }

    @Override
    public void serialize(ByteBuf out) {
        MinecraftTypes.writeVarInt(out, this.containerId);
    }

    @Override
    public boolean shouldRunOnGameThread() {
        return true;
    }

    public int getContainerId() {
        return this.containerId;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientboundContainerClosePacket)) {
            return false;
        }
        ClientboundContainerClosePacket other = (ClientboundContainerClosePacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return this.getContainerId() == other.getContainerId();
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ClientboundContainerClosePacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getContainerId();
        return result;
    }

    public @NonNull String toString() {
        return "ClientboundContainerClosePacket(containerId=" + this.getContainerId() + ")";
    }

    public @NonNull ClientboundContainerClosePacket withContainerId(int containerId) {
        return this.containerId == containerId ? this : new ClientboundContainerClosePacket(containerId);
    }

    public ClientboundContainerClosePacket(int containerId) {
        this.containerId = containerId;
    }
}

