/*
 * Decompiled with CFR 0.152.
 */
package com.soystargaze.vitamin;

import com.soystargaze.vitamin.adapter.VersionAdapter;
import com.soystargaze.vitamin.adapter.VersionAdapter_1_21_1;
import com.soystargaze.vitamin.adapter.VersionAdapter_1_21_4;
import com.soystargaze.vitamin.commands.VitaminCommandManager;
import com.soystargaze.vitamin.config.ConfigHandler;
import com.soystargaze.vitamin.database.DatabaseHandler;
import com.soystargaze.vitamin.integration.WorldGuardFlags;
import com.soystargaze.vitamin.modules.ModuleManager;
import com.soystargaze.vitamin.shaded.bstats.bukkit.Metrics;
import com.soystargaze.vitamin.utils.AsyncExecutor;
import com.soystargaze.vitamin.utils.ConsoleUtils;
import com.soystargaze.vitamin.utils.LogUtils;
import com.soystargaze.vitamin.utils.text.TextHandler;
import java.io.File;
import org.bukkit.Bukkit;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class Vitamin
extends JavaPlugin
implements Listener {
    private static Vitamin instance;
    private ModuleManager moduleManager;
    private VitaminCommandManager commandManager;
    private VersionAdapter versionAdapter;
    private static final int BSTATS_PLUGIN_ID = 24855;

    public void onEnable() {
        instance = this;
        try {
            this.setupVersionAdapter();
            this.initializePlugin();
            if (this.getServer().getPluginManager().getPlugin("WorldGuard") != null) {
                WorldGuardFlags.registerFlags(this);
            }
        }
        catch (Exception e) {
            String KEY = "plugin.enable_error";
            TextHandler.get().registerTemporaryTranslation("plugin.enable_error", "Plugin cannot be enabled: {0}");
            TextHandler.get().logTranslated("plugin.enable_error", e.getMessage());
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
        }
    }

    public void onDisable() {
        AsyncExecutor.shutdown();
        TextHandler.get().logTranslated("plugin.disabled", new Object[0]);
        instance = null;
        DatabaseHandler.close();
    }

    private void initializePlugin() {
        try {
            this.loadConfigurations();
            DatabaseHandler.initialize(this);
            TextHandler.get().logTranslated("plugin.separator", new Object[0]);
            this.moduleManager = new ModuleManager(this);
            this.initializeCommandManager();
            TextHandler.get().logTranslated("plugin.separator", new Object[0]);
            this.initializeMetrics();
        }
        catch (Exception e) {
            TextHandler.get().logTranslated("plugin.enable_error", e.getMessage());
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
        }
    }

    private void loadConfigurations() {
        ConfigHandler.setup(this);
        this.getConfig().options().copyDefaults(true);
        this.saveConfig();
        TextHandler.init(this);
        LogUtils.init(this);
        this.setupTranslations();
        ConsoleUtils.displayAsciiArt(this);
        AsyncExecutor.initialize();
        ConsoleUtils.displaySuccessMessage(this);
    }

    private void setupTranslations() {
        File translationsFolder = new File(this.getDataFolder(), "Translations");
        if (!translationsFolder.exists() && !translationsFolder.mkdirs()) {
            TextHandler.get().logTranslated("translations.folder_error", new Object[0]);
            return;
        }
        String[] defaults = new String[]{"en_us.yml", "es_es.yml", "fr_fr.yml", "de_de.yml", "pt_br.yml", "pl_pl.yml", "zh_cn.yml", "ko_kr.yml", "tr_tr.yml", "ja_jp.yml"};
        boolean replace = this.getConfig().getBoolean("translations.force-update", true);
        for (String file : defaults) {
            try {
                this.saveResource("Translations/" + file, replace);
            }
            catch (Exception e) {
                TextHandler.get().registerTemporaryTranslation("translations.save_error", "Language cannot be saved: {0}");
                TextHandler.get().logTranslated("translations.save_error", file);
            }
        }
        String lang = ConfigHandler.getLanguage();
        if (TextHandler.get().isLanguageAvailable(lang)) {
            TextHandler.get().loadTranslations(this, lang);
        } else {
            TextHandler.get().registerTemporaryTranslation("translations.language_not_found", "Language not found: {0}");
            TextHandler.get().logTranslated("translations.language_not_found", lang);
            TextHandler.get().loadTranslations(this, TextHandler.get().getActiveLanguage());
        }
    }

    private void initializeCommandManager() {
        try {
            if (this.commandManager == null) {
                this.commandManager = new VitaminCommandManager(this);
                this.commandManager.registerCommands();
            }
        }
        catch (Exception e) {
            TextHandler.get().logTranslated("command.register_error", e.getMessage());
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
        }
    }

    public void reregisterCommandListeners() {
        if (this.commandManager != null) {
            this.commandManager.reregisterListeners();
        }
    }

    private void initializeMetrics() {
        try {
            new Metrics(this, 24855);
        }
        catch (Exception e) {
            TextHandler.get().registerTemporaryTranslation("bstats.error", "BStats error: {0}");
            TextHandler.get().logTranslated("bstats.error", e.getMessage());
        }
    }

    private void setupVersionAdapter() {
        String versionPattern;
        String raw = Bukkit.getBukkitVersion();
        String version = raw.replaceFirst(versionPattern = ".*?(\\d+\\.\\d+(?:\\.\\d+)?).*", "$1");
        if (version.equals(raw)) {
            TextHandler.get().logTranslated("version.parse_error", raw);
            this.versionAdapter = new VersionAdapter_1_21_1();
            return;
        }
        String[] parts = version.split("\\.");
        int major = Integer.parseInt(parts[0]);
        int minor = Integer.parseInt(parts[1]);
        int patch = parts.length > 2 ? Integer.parseInt(parts[2]) : 0;
        this.versionAdapter = major == 1 && minor == 21 && patch >= 3 ? new VersionAdapter_1_21_4() : new VersionAdapter_1_21_1();
    }

    public VersionAdapter getVersionAdapter() {
        return this.versionAdapter;
    }

    public static Vitamin getInstance() {
        return instance;
    }

    public ModuleManager getModuleManager() {
        return this.moduleManager;
    }
}

