/*
 * Decompiled with CFR 0.152.
 */
package com.soystargaze.vitamin.commands;

import com.soystargaze.vitamin.Vitamin;
import com.soystargaze.vitamin.database.DatabaseHandler;
import com.soystargaze.vitamin.utils.text.TextHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import net.kyori.adventure.text.Component;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class PModuleCommand
implements CommandExecutor,
TabCompleter {
    private final Vitamin plugin;

    public PModuleCommand(Vitamin plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull @NotNull String @NotNull [] args) {
        boolean enable;
        if (!(sender instanceof Player)) {
            this.sendToSender(sender, "commands.pmodule.player_only", new Object[0]);
            return true;
        }
        Player player = (Player)sender;
        if (!player.hasPermission("vitamin.use.pmodule")) {
            TextHandler.get().sendMessage(player, "commands.pmodule.no_pmodule_permission", new Object[0]);
            return true;
        }
        if (args.length != 2) {
            TextHandler.get().sendMessage(player, "commands.pmodule.usage", new Object[0]);
            return true;
        }
        String moduleName = args[0];
        String configKey = "module." + moduleName;
        String permissionKey = "vitamin.module." + moduleName;
        if (!this.plugin.getConfig().getBoolean(configKey, false)) {
            TextHandler.get().sendMessage(player, "commands.pmodule.module_not_active", moduleName);
            return true;
        }
        if (!player.hasPermission(permissionKey)) {
            TextHandler.get().sendMessage(player, "commands.pmodule.no_module_permission", moduleName);
            return true;
        }
        String stateArg = args[1];
        if (stateArg.equalsIgnoreCase("enable")) {
            enable = true;
        } else if (stateArg.equalsIgnoreCase("disable")) {
            enable = false;
        } else {
            TextHandler.get().sendMessage(player, "commands.pmodule.usage", new Object[0]);
            return true;
        }
        DatabaseHandler.setModuleEnabledForPlayer(player.getUniqueId(), configKey, enable);
        boolean newState = DatabaseHandler.isModuleEnabledForPlayer(player.getUniqueId(), configKey);
        TextHandler.get().sendMessage(player, "commands.pmodule.changed", moduleName, newState ? "enabled" : "disabled");
        return true;
    }

    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String alias, @NotNull @NotNull String @NotNull [] args) {
        ArrayList<String> suggestions = new ArrayList<String>();
        if (args.length == 1) {
            if (this.plugin.getConfig().contains("module")) {
                Set keys = Objects.requireNonNull(this.plugin.getConfig().getConfigurationSection("module")).getKeys(false);
                for (String k : keys) {
                    if (!this.plugin.getConfig().getBoolean("module." + k, true)) continue;
                    suggestions.add(k);
                }
            }
        } else if (args.length == 2) {
            suggestions.add("enable");
            suggestions.add("disable");
        }
        return suggestions;
    }

    private void sendToSender(CommandSender sender, String key, Object ... args) {
        Object msg = TextHandler.get().getMessage(key, args);
        if (msg instanceof Component) {
            Component comp = (Component)msg;
            sender.sendMessage(comp);
        } else {
            sender.sendMessage(msg.toString());
        }
    }
}

