/*
 * Decompiled with CFR 0.152.
 */
package com.soystargaze.vitamin.commands;

import com.soystargaze.vitamin.commands.RestoreCommand;
import com.soystargaze.vitamin.config.ConfigHandler;
import com.soystargaze.vitamin.utils.LogUtils;
import com.soystargaze.vitamin.utils.text.TextHandler;
import org.bukkit.ChatColor;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class RestoreInventoryListener
implements Listener {
    private final JavaPlugin plugin;
    private final NamespacedKey restoreKey;
    private final RestoreCommand restoreCommand;

    public RestoreInventoryListener(JavaPlugin plugin, RestoreCommand restoreCommand) {
        this.plugin = plugin;
        this.restoreKey = new NamespacedKey((Plugin)plugin, "restore_id");
        this.restoreCommand = restoreCommand;
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        String title = event.getView().getTitle();
        String titleCheck = ConfigHandler.getString("gui.restore.title", "&6Restore:");
        String[] titleParts = titleCheck.split("%player%");
        if (titleParts.length == 0) {
            return;
        }
        String titlePrefix = titleParts[0].trim();
        if (!title.startsWith(titlePrefix = ChatColor.translateAlternateColorCodes((char)'&', (String)titlePrefix))) {
            return;
        }
        event.setCancelled(true);
        HumanEntity humanEntity = event.getWhoClicked();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player admin = (Player)humanEntity;
        ItemStack clickedItem = event.getCurrentItem();
        if (clickedItem == null || !clickedItem.hasItemMeta()) {
            return;
        }
        ItemMeta meta = clickedItem.getItemMeta();
        boolean hasRestoreKey = meta.getPersistentDataContainer().has(this.restoreKey, PersistentDataType.STRING);
        if (!hasRestoreKey) {
            return;
        }
        String chestId = (String)meta.getPersistentDataContainer().get(this.restoreKey, PersistentDataType.STRING);
        if (chestId == null) {
            return;
        }
        ItemStack restoredContainer = this.restoreCommand.createRestoreContainer(chestId);
        if (restoredContainer == null) {
            TextHandler.get().sendMessage(admin, "commands.restore.error", new Object[0]);
            return;
        }
        if (admin.getInventory().firstEmpty() == -1) {
            TextHandler.get().sendMessage(admin, "commands.restore.inventory_full", new Object[0]);
            return;
        }
        admin.getInventory().addItem(new ItemStack[]{restoredContainer});
        String containerName = clickedItem.getType().name().toLowerCase().replace("_", " ");
        TextHandler.get().sendMessage(admin, "commands.restore.success", containerName, chestId.substring(0, 8));
        LogUtils.logRestoration(admin.getName(), clickedItem.getType().name(), chestId);
        this.plugin.getServer().getScheduler().runTaskLater((Plugin)this.plugin, () -> admin.closeInventory(), 1L);
    }
}

