/*
 * Decompiled with CFR 0.152.
 */
package com.soystargaze.vitamin.commands;

import com.soystargaze.vitamin.Vitamin;
import com.soystargaze.vitamin.commands.RestoreCommand;
import com.soystargaze.vitamin.commands.RestoreInventoryListener;
import com.soystargaze.vitamin.commands.VitaminCommand;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.TabCompleter;

public class VitaminCommandManager {
    private final Vitamin plugin;
    private VitaminCommand vitaminCommand;

    public VitaminCommandManager(Vitamin plugin) {
        this.plugin = plugin;
    }

    public void registerCommands() {
        this.vitaminCommand = new VitaminCommand(this.plugin);
        RestoreCommand restoreCommand = this.vitaminCommand.getRestoreCommand();
        this.register("vitamin", this.vitaminCommand);
        this.register("vita", this.vitaminCommand);
        this.register("vi", this.vitaminCommand);
        RestoreInventoryListener listener = new RestoreInventoryListener(this.plugin, restoreCommand);
        this.plugin.getModuleManager().addSystemListener(listener);
    }

    public void reregisterListeners() {
        RestoreCommand restoreCommand;
        if (this.vitaminCommand != null && (restoreCommand = this.vitaminCommand.getRestoreCommand()) != null) {
            RestoreInventoryListener restoreListener = new RestoreInventoryListener(this.plugin, restoreCommand);
            this.plugin.getModuleManager().addSystemListener(restoreListener);
        }
    }

    private void register(String name, CommandExecutor executor) {
        PluginCommand cmd = this.plugin.getCommand(name);
        if (cmd == null) {
            throw new IllegalStateException("The command '" + name + "' is not defined in plugin.yml.");
        }
        cmd.setExecutor(executor);
        if (executor instanceof TabCompleter) {
            cmd.setTabCompleter((TabCompleter)executor);
        }
    }
}

