/*
 * Decompiled with CFR 0.152.
 */
package com.soystargaze.vitamin.integration;

import java.util.function.Supplier;
import me.ryanhamshire.GriefPrevention.Claim;
import me.ryanhamshire.GriefPrevention.ClaimPermission;
import me.ryanhamshire.GriefPrevention.GriefPrevention;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.plugin.java.JavaPlugin;

public class GriefPreventionIntegrationHandler {
    private final GriefPrevention griefPrevention = GriefPrevention.instance;

    public GriefPreventionIntegrationHandler(JavaPlugin plugin) {
    }

    public boolean canInteract(Player player, Location location, Event event) {
        if (player.isOp()) {
            return true;
        }
        if (this.griefPrevention == null) {
            return true;
        }
        Claim claim = this.griefPrevention.dataStore.getClaimAt(location, true, null);
        if (claim == null) {
            return true;
        }
        if (claim.getOwnerID().equals(player.getUniqueId())) {
            return true;
        }
        return claim.checkPermission(player, ClaimPermission.Access, event) == null;
    }

    public boolean hasBuildPermission(Player player, Location location, Event event) {
        if (player.isOp()) {
            return true;
        }
        if (this.griefPrevention == null) {
            return true;
        }
        Claim claim = this.griefPrevention.dataStore.getClaimAt(location, true, null);
        if (claim == null) {
            return true;
        }
        if (claim.getOwnerID().equals(player.getUniqueId())) {
            return true;
        }
        Supplier denyReason = claim.checkPermission(player, ClaimPermission.Build, event);
        return denyReason == null;
    }

    public boolean hasInventoryPermission(Player player, Location location, Event event) {
        if (player.isOp()) {
            return true;
        }
        if (this.griefPrevention == null) {
            return true;
        }
        Claim claim = this.griefPrevention.dataStore.getClaimAt(location, true, null);
        if (claim == null) {
            return true;
        }
        if (claim.getOwnerID().equals(player.getUniqueId())) {
            return true;
        }
        Supplier denyReason = claim.checkPermission(player, ClaimPermission.Inventory, event);
        return denyReason == null;
    }

    public boolean hasContainerPermissions(Player player, Location location, Event event) {
        return this.hasBuildPermission(player, location, event) && this.hasInventoryPermission(player, location, event);
    }
}

