/*
 * Decompiled with CFR 0.152.
 */
package com.soystargaze.vitamin.integration;

import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldguard.LocalPlayer;
import com.sk89q.worldguard.WorldGuard;
import com.sk89q.worldguard.bukkit.WorldGuardPlugin;
import com.sk89q.worldguard.protection.ApplicableRegionSet;
import com.sk89q.worldguard.protection.association.RegionAssociable;
import com.sk89q.worldguard.protection.flags.Flags;
import com.sk89q.worldguard.protection.flags.StateFlag;
import com.sk89q.worldguard.protection.regions.ProtectedRegion;
import com.sk89q.worldguard.protection.regions.RegionQuery;
import com.soystargaze.vitamin.integration.WorldGuardFlags;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;

public class WorldGuardIntegrationHandler {
    public WorldGuardIntegrationHandler(JavaPlugin plugin) {
    }

    public boolean canInteract(Player player, Location location) {
        return this.canInteractWithFlag(player, location, WorldGuardFlags.VITAMIN_ENTITY);
    }

    public boolean canBuild(Player player, Location location) {
        return this.canBuildWithFlag(player, location, WorldGuardFlags.VITAMIN_CONTAINER);
    }

    public boolean canInteractEntity(Player player, Location location) {
        return this.canInteractWithFlag(player, location, WorldGuardFlags.VITAMIN_ENTITY);
    }

    public boolean canInteractContainer(Player player, Location location) {
        return this.canBuildWithFlag(player, location, WorldGuardFlags.VITAMIN_CONTAINER);
    }

    private boolean canInteractWithFlag(Player player, Location location, StateFlag customFlag) {
        try {
            RegionQuery query = WorldGuard.getInstance().getPlatform().getRegionContainer().createQuery();
            LocalPlayer wgPlayer = WorldGuardPlugin.inst().wrapPlayer(player);
            com.sk89q.worldedit.util.Location weLoc = BukkitAdapter.adapt((Location)location);
            ApplicableRegionSet regionSet = query.getApplicableRegions(weLoc);
            if (regionSet.getRegions().isEmpty() || regionSet.getRegions().stream().allMatch(region -> region.getId().equalsIgnoreCase("__global__"))) {
                if (customFlag != null) {
                    StateFlag.State customState = regionSet.queryState((RegionAssociable)wgPlayer, new StateFlag[]{customFlag});
                    return customState == StateFlag.State.ALLOW;
                }
                return false;
            }
            boolean hasGeneralPermission = true;
            for (ProtectedRegion region2 : regionSet.getRegions()) {
                if (region2.getId().equalsIgnoreCase("__global__") || region2.getMembers().contains(wgPlayer.getUniqueId()) || region2.getOwners().contains(wgPlayer.getUniqueId()) || query.testState(weLoc, wgPlayer, new StateFlag[]{Flags.INTERACT})) continue;
                hasGeneralPermission = false;
                break;
            }
            if (!hasGeneralPermission) {
                return false;
            }
            if (customFlag != null) {
                StateFlag.State customState = regionSet.queryState((RegionAssociable)wgPlayer, new StateFlag[]{customFlag});
                return customState == StateFlag.State.ALLOW;
            }
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    private boolean canBuildWithFlag(Player player, Location location, StateFlag customFlag) {
        try {
            RegionQuery query = WorldGuard.getInstance().getPlatform().getRegionContainer().createQuery();
            LocalPlayer wgPlayer = WorldGuardPlugin.inst().wrapPlayer(player);
            com.sk89q.worldedit.util.Location weLoc = BukkitAdapter.adapt((Location)location);
            ApplicableRegionSet regionSet = query.getApplicableRegions(weLoc);
            if (regionSet.getRegions().isEmpty() || regionSet.getRegions().stream().allMatch(region -> region.getId().equalsIgnoreCase("__global__"))) {
                if (customFlag != null) {
                    StateFlag.State customState = regionSet.queryState((RegionAssociable)wgPlayer, new StateFlag[]{customFlag});
                    return customState == StateFlag.State.ALLOW;
                }
                return false;
            }
            boolean hasGeneralPermission = true;
            for (ProtectedRegion region2 : regionSet.getRegions()) {
                if (region2.getId().equalsIgnoreCase("__global__") || region2.getMembers().contains(wgPlayer.getUniqueId()) || region2.getOwners().contains(wgPlayer.getUniqueId()) || query.testBuild(weLoc, wgPlayer, new StateFlag[0])) continue;
                hasGeneralPermission = false;
                break;
            }
            if (!hasGeneralPermission) {
                return false;
            }
            if (customFlag != null) {
                StateFlag.State customState = regionSet.queryState((RegionAssociable)wgPlayer, new StateFlag[]{customFlag});
                return customState == StateFlag.State.ALLOW;
            }
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }
}

