/*
 * Decompiled with CFR 0.152.
 */
package com.soystargaze.vitamin.libs.rtag;

import com.soystargaze.vitamin.libs.rtag.Rtag;
import com.soystargaze.vitamin.libs.rtag.RtagEditor;
import com.soystargaze.vitamin.libs.rtag.block.BlockObject;
import com.soystargaze.vitamin.libs.rtag.util.ChatComponent;
import java.util.function.Consumer;
import java.util.function.Function;
import org.bukkit.block.Block;

public class RtagBlock
extends RtagEditor<Block, RtagBlock> {
    public static RtagBlock of(Block block) {
        return new RtagBlock(block);
    }

    public static RtagBlock of(Rtag rtag, Block block) {
        return new RtagBlock(rtag, block);
    }

    public RtagBlock(Block block) {
        super(Rtag.INSTANCE, block);
    }

    public RtagBlock(Rtag rtag, Block block) {
        super(rtag, block);
    }

    public RtagBlock(Rtag rtag, Block block, Object mcObject) {
        super(rtag, block, mcObject);
    }

    public RtagBlock(Rtag rtag, Block block, Object mcObject, Object tag) {
        super(rtag, block, mcObject, tag);
    }

    public Block getBlock() {
        return (Block)this.getTypeObject();
    }

    @Override
    protected RtagBlock getEditor() {
        return this;
    }

    @Override
    public Object getLiteralObject(Block block) {
        return BlockObject.getTileEntity(block);
    }

    @Override
    public Object getTag(Object block) {
        return BlockObject.save(block);
    }

    @Override
    public Block load() {
        try {
            BlockObject.load(this.getLiteralObject(), this.getTag());
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return (Block)this.getTypeObject();
    }

    public boolean setCustomName(String name) {
        return this.set(ChatComponent.isChatComponent(name) ? name : ChatComponent.toJson(name), "CustomName");
    }

    public String getCustomName() {
        String name = (String)this.get("CustomName");
        if (name == null) {
            return null;
        }
        return ChatComponent.isChatComponent(name) ? name : ChatComponent.toString(name);
    }

    public static <T extends Block> T edit(T block, Consumer<RtagBlock> consumer) {
        return RtagBlock.edit(Rtag.INSTANCE, block, consumer);
    }

    public static <T extends Block, R> R edit(T block, Function<RtagBlock, R> function) {
        return RtagBlock.edit(Rtag.INSTANCE, block, function);
    }

    public static <T extends Block> T edit(Rtag rtag, T block, Consumer<RtagBlock> consumer) {
        new RtagBlock(rtag, block).edit(consumer).load();
        return block;
    }

    public static <T extends Block, R> R edit(Rtag rtag, T block, Function<RtagBlock, R> function) {
        return function.apply(new RtagBlock(rtag, block));
    }
}

