/*
 * Decompiled with CFR 0.152.
 */
package com.soystargaze.vitamin.libs.rtag.tag;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.soystargaze.vitamin.libs.rtag.RtagMirror;
import com.soystargaze.vitamin.libs.rtag.stream.TStream;
import com.soystargaze.vitamin.libs.rtag.util.EasyLookup;
import com.soystargaze.vitamin.libs.rtag.util.OptionalType;
import com.soystargaze.vitamin.libs.rtag.util.ServerInstance;
import java.lang.invoke.MethodHandle;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.ApiStatus;

public class TagCompound {
    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="1.6.0")
    public static final TStream<Object> DATA;
    private static final Class<?> NBT_COMPOUND;
    private static final MethodHandle newEmpty;
    private static final MethodHandle newCompound;
    private static final MethodHandle setMapField;
    private static final MethodHandle getMapField;
    private static final MethodHandle clone;
    private static final MethodHandle parse;

    TagCompound() {
    }

    public static Object newTag() {
        try {
            return newEmpty.invoke();
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    public static Object newTag(String snbt) {
        try {
            return parse.invoke(snbt);
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    public static Object newTag(Map<String, Object> map) {
        if (map == null || map.isEmpty()) {
            return TagCompound.newTag();
        }
        try {
            map.putAll(Map.of());
        }
        catch (UnsupportedOperationException e) {
            return TagCompound.newTag(new HashMap<String, Object>(map));
        }
        return TagCompound.newUncheckedTag(map);
    }

    public static Object newUncheckedTag(Map<String, Object> map) {
        if (ServerInstance.MAJOR_VERSION >= 15) {
            try {
                return newCompound.invoke(map);
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
        }
        Object tag = TagCompound.newTag();
        try {
            setMapField.invoke(tag, map);
        }
        catch (ClassCastException e) {
            TagCompound.getValue(tag).putAll(map);
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
        return tag;
    }

    public static Object newTag(RtagMirror mirror, Object object) {
        Map map = OptionalType.of(object).as(Map.class);
        if (map == null) {
            throw new IllegalArgumentException("The object type " + object.getClass().getName() + " cannot be used to create NBTTagCompound tag using TagCompound class");
        }
        return TagCompound.newTag(mirror, map);
    }

    public static Object newTag(RtagMirror mirror, Map<String, Object> map) {
        if (map.isEmpty()) {
            return TagCompound.newTag();
        }
        HashMap<String, Object> tags = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            tags.put(entry.getKey(), mirror.newTag(entry.getValue()));
        }
        return TagCompound.newUncheckedTag(tags);
    }

    public static boolean isTagCompound(Object object) {
        return NBT_COMPOUND.isInstance(object);
    }

    public static Object clone(Object tag) {
        try {
            return clone.invoke(tag);
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    public static Object safeClone(Object tag) {
        try {
            return clone.invoke(tag);
        }
        catch (Throwable t) {
            t.printStackTrace();
            return null;
        }
    }

    public static Map<String, Object> getValue(Object tag) {
        try {
            return getMapField.invoke(tag);
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    public static Map<String, Object> getValue(RtagMirror mirror, Object tag) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : TagCompound.getValue(tag).entrySet()) {
            map.put(entry.getKey(), mirror.getTagValue(entry.getValue()));
        }
        return map;
    }

    public static String getJson(Object tag) {
        return TagCompound.getJson(new Gson(), tag);
    }

    public static String getJson(Gson gson, Object tag) {
        Type type = new TypeToken(){}.getType();
        return gson.toJson(TagCompound.getValue(RtagMirror.INSTANCE, tag), type);
    }

    public static boolean notHasKey(Object tag, String key) {
        try {
            return !TagCompound.hasKey(tag, key);
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    public static boolean hasKey(Object tag, String key) {
        return TagCompound.getValue(tag).containsKey(key);
    }

    public static Object remove(Object tag, String key) {
        return TagCompound.getValue(tag).remove(key);
    }

    public static Object set(Object tag, String key, Object value) {
        return TagCompound.getValue(tag).put(key, value);
    }

    public static void setValue(Object tag, Map<String, Object> map) {
        if (map.isEmpty()) {
            TagCompound.clear(tag);
        } else {
            try {
                setMapField.invoke(tag, map);
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
        }
    }

    public static boolean merge(Object tag, Object value, boolean replace) {
        return TagCompound.merge(tag, value, replace, false);
    }

    public static boolean merge(Object tag, Object value, boolean replace, boolean deep) {
        if (!TagCompound.isTagCompound(value)) {
            return false;
        }
        Map<String, Object> from = TagCompound.getValue(value);
        Map<String, Object> to = TagCompound.getValue(tag);
        boolean merged = false;
        for (Map.Entry<String, Object> entry : from.entrySet()) {
            Object tempValue;
            if (!to.containsKey(entry.getKey())) {
                to.put(entry.getKey(), entry.getValue());
                merged = true;
                continue;
            }
            if (deep && TagCompound.isTagCompound(entry.getValue()) && TagCompound.isTagCompound(tempValue = to.get(entry.getKey()))) {
                boolean result = TagCompound.merge(tempValue, entry.getValue(), replace, true);
                if (merged || !result) continue;
                merged = true;
                continue;
            }
            if (!replace) continue;
            to.put(entry.getKey(), entry.getValue());
            merged = true;
        }
        return merged;
    }

    public static Object get(Object tag, String key) {
        return TagCompound.getValue(tag).get(key);
    }

    public static void clear(Object tag) {
        TagCompound.getValue(tag).clear();
    }

    static {
        try {
            EasyLookup.addNMSClass("nbt.MojangsonParser", "TagParser");
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        DATA = TStream.COMPOUND;
        NBT_COMPOUND = EasyLookup.classById("NBTTagCompound");
        MethodHandle new$EmptyCompound = null;
        MethodHandle new$Compound = null;
        MethodHandle get$map = null;
        MethodHandle set$map = null;
        MethodHandle method$clone = null;
        MethodHandle method$parse = null;
        try {
            String map = "map";
            String clone = "clone";
            String parse = "parse";
            if (ServerInstance.Type.MOJANG_MAPPED) {
                map = "tags";
                clone = "copy";
                parse = "parseTag";
                if (ServerInstance.VERSION >= 21.04f) {
                    parse = "parseCompoundFully";
                }
            } else {
                if (ServerInstance.MAJOR_VERSION >= 10) {
                    clone = "g";
                }
                if (ServerInstance.MAJOR_VERSION >= 13) {
                    clone = "clone";
                }
                if (ServerInstance.Release.UNIVERSAL) {
                    map = "x";
                }
                if (ServerInstance.MAJOR_VERSION >= 18) {
                    clone = "g";
                    parse = "a";
                }
                if ((double)ServerInstance.VERSION >= 19.03) {
                    clone = "h";
                }
                if (ServerInstance.Release.COMPONENT) {
                    clone = "i";
                }
                if (ServerInstance.VERSION >= 21.04f) {
                    clone = "l";
                }
            }
            new$EmptyCompound = EasyLookup.constructor(NBT_COMPOUND, new Object[0]);
            if (ServerInstance.MAJOR_VERSION >= 15) {
                new$Compound = EasyLookup.constructor(NBT_COMPOUND, Map.class);
            }
            get$map = EasyLookup.getter(NBT_COMPOUND, map, Map.class);
            set$map = EasyLookup.setter(NBT_COMPOUND, map, Map.class);
            method$clone = EasyLookup.method(NBT_COMPOUND, clone, NBT_COMPOUND, new Object[0]);
            method$parse = EasyLookup.staticMethod("MojangsonParser", parse, NBT_COMPOUND, String.class);
        }
        catch (IllegalAccessException | NoSuchFieldException | NoSuchMethodException e) {
            e.printStackTrace();
        }
        newEmpty = new$EmptyCompound;
        newCompound = new$Compound;
        setMapField = set$map;
        getMapField = get$map;
        clone = method$clone;
        parse = method$parse;
    }
}

