/*
 * Decompiled with CFR 0.152.
 */
package com.soystargaze.vitamin.libs.rtag.util;

import java.util.TreeMap;
import org.bukkit.Bukkit;
import org.jetbrains.annotations.ApiStatus;

public class ServerInstance {
    public static final float VERSION;
    public static final String PACKAGE_VERSION;
    public static final int DATA_VERSION;
    public static final int MAJOR_VERSION;
    public static final int RELEASE_VERSION;
    public static final int FULL_VERSION;
    private static final TreeMap<Integer, Integer[]> VERSION_MAP;
    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="1.6.0")
    public static final String version;
    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="1.6.0")
    public static final int fullVersion;
    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="1.6.0")
    public static final int verNumber;
    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="1.6.0")
    public static final int release;
    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="1.6.0")
    public static final int dataVersion;
    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="1.6.0")
    public static final boolean isLegacy;
    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="1.6.0")
    public static final boolean isUniversal;
    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="1.6.0")
    public static final boolean isSpigot;
    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="1.6.0")
    public static final boolean isPaper;
    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="1.6.0")
    public static final boolean isFolia;
    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="1.6.0")
    public static final boolean isMojangMapped;

    ServerInstance() {
    }

    private static int getDataVersion(String serverPackage) {
        try {
            Class<?> magicNumbersClass = Class.forName(serverPackage + ".util.CraftMagicNumbers");
            Object craftMagicNumbers = magicNumbersClass.getDeclaredField("INSTANCE").get(null);
            return (Integer)magicNumbersClass.getDeclaredMethod("getDataVersion", new Class[0]).invoke(craftMagicNumbers, new Object[0]);
        }
        catch (Throwable t) {
            t.printStackTrace();
            return Integer.MAX_VALUE;
        }
    }

    public static String version(int dataVersion) {
        Integer[] value = VERSION_MAP.floorEntry(dataVersion).getValue();
        return "v1_" + value[0] + "_R" + value[1];
    }

    public static int fullVersion(int dataVersion) {
        return VERSION_MAP.floorEntry(dataVersion).getValue()[2];
    }

    public static int verNumber(int dataVersion) {
        return VERSION_MAP.floorEntry(dataVersion).getValue()[0];
    }

    public static int release(int dataVersion) {
        return VERSION_MAP.floorEntry(dataVersion).getValue()[1];
    }

    public static int dataVersion(int version) {
        if (version >= 10000) {
            for (Integer key : VERSION_MAP.descendingKeySet()) {
                Integer[] value = VERSION_MAP.get(key);
                if (version < value[2]) continue;
                return key;
            }
        } else {
            int rel;
            int ver;
            if (version < 8) {
                ver = MAJOR_VERSION;
                rel = version;
            } else {
                ver = version;
                rel = 1;
            }
            for (Integer key : VERSION_MAP.descendingKeySet()) {
                Integer[] value = VERSION_MAP.get(key);
                if (ver < value[0] || rel < value[1]) continue;
                return key;
            }
        }
        return Integer.MIN_VALUE;
    }

    static {
        VERSION_MAP = new TreeMap();
        VERSION_MAP.put(98, new Integer[]{8, 3, 10803});
        VERSION_MAP.put(169, new Integer[]{9, 1, 10901});
        VERSION_MAP.put(183, new Integer[]{9, 2, 10902});
        VERSION_MAP.put(510, new Integer[]{10, 1, 11001});
        VERSION_MAP.put(819, new Integer[]{11, 1, 11101});
        VERSION_MAP.put(1139, new Integer[]{12, 1, 11201});
        VERSION_MAP.put(1519, new Integer[]{13, 1, 11301});
        VERSION_MAP.put(1631, new Integer[]{13, 2, 11302});
        VERSION_MAP.put(1952, new Integer[]{14, 1, 11401});
        VERSION_MAP.put(2225, new Integer[]{15, 1, 11501});
        VERSION_MAP.put(2566, new Integer[]{16, 1, 11601});
        VERSION_MAP.put(2578, new Integer[]{16, 2, 11602});
        VERSION_MAP.put(2584, new Integer[]{16, 3, 11603});
        VERSION_MAP.put(2724, new Integer[]{17, 1, 11701});
        VERSION_MAP.put(2860, new Integer[]{18, 1, 11801});
        VERSION_MAP.put(2975, new Integer[]{18, 2, 11802});
        VERSION_MAP.put(3105, new Integer[]{19, 1, 11901});
        VERSION_MAP.put(3218, new Integer[]{19, 2, 11902});
        VERSION_MAP.put(3337, new Integer[]{19, 3, 11903});
        VERSION_MAP.put(3463, new Integer[]{20, 1, 12001});
        VERSION_MAP.put(3578, new Integer[]{20, 2, 12002});
        VERSION_MAP.put(3698, new Integer[]{20, 3, 12003});
        VERSION_MAP.put(3837, new Integer[]{20, 4, 12004});
        VERSION_MAP.put(3953, new Integer[]{21, 1, 12101});
        VERSION_MAP.put(4080, new Integer[]{21, 2, 12102});
        VERSION_MAP.put(4189, new Integer[]{21, 3, 12103});
        VERSION_MAP.put(4324, new Integer[]{21, 4, 12104});
        String serverPackage = Bukkit.getServer().getClass().getPackage().getName();
        if (serverPackage.startsWith("org.bukkit.craftbukkit.v1_")) {
            PACKAGE_VERSION = serverPackage.split("\\.")[3];
            CharSequence[] split = PACKAGE_VERSION.split("_");
            MAJOR_VERSION = Integer.parseInt(split[1]);
            split[2] = split[2].substring(1);
            RELEASE_VERSION = Integer.parseInt(split[2]);
            split[0] = split[0].substring(1);
            if (split[1].length() <= 1) {
                split[1] = "0" + split[1];
            }
            if (split[2].length() <= 1) {
                split[2] = "0" + (String)split[2];
            }
            FULL_VERSION = Integer.parseInt(String.join((CharSequence)"", split));
            DATA_VERSION = MAJOR_VERSION >= 13 ? ServerInstance.getDataVersion(serverPackage) : ServerInstance.dataVersion(FULL_VERSION);
        } else {
            DATA_VERSION = ServerInstance.getDataVersion(serverPackage);
            PACKAGE_VERSION = ServerInstance.version(DATA_VERSION);
            FULL_VERSION = ServerInstance.fullVersion(DATA_VERSION);
            MAJOR_VERSION = ServerInstance.verNumber(DATA_VERSION);
            RELEASE_VERSION = ServerInstance.release(DATA_VERSION);
        }
        VERSION = Float.parseFloat(MAJOR_VERSION + "." + (RELEASE_VERSION < 10 ? "0" : "") + RELEASE_VERSION);
        VERSION_MAP.put(Integer.MIN_VALUE, new Integer[]{MAJOR_VERSION, RELEASE_VERSION, FULL_VERSION});
        version = PACKAGE_VERSION;
        fullVersion = FULL_VERSION;
        verNumber = MAJOR_VERSION;
        release = RELEASE_VERSION;
        dataVersion = DATA_VERSION;
        isLegacy = Release.LEGACY;
        isUniversal = Release.UNIVERSAL;
        isSpigot = Platform.SPIGOT;
        isPaper = Platform.PAPER;
        isFolia = Platform.FOLIA;
        isMojangMapped = Type.MOJANG_MAPPED;
    }

    public static class Release {
        public static final boolean LEGACY = MAJOR_VERSION <= 12;
        public static final boolean FLAT = MAJOR_VERSION >= 13;
        public static final boolean UNIVERSAL = MAJOR_VERSION >= 17;
        public static final boolean COMPONENT = (double)VERSION >= 20.04;
    }

    public static class Platform {
        public static final boolean SPIGOT;
        public static final boolean PAPER;
        public static final boolean FOLIA;

        static {
            boolean spigot = false;
            boolean paper = false;
            boolean folia = false;
            try {
                Class.forName("org.spigotmc.SpigotConfig");
                spigot = true;
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            try {
                Class.forName("com.destroystokyo.paper.Title");
                paper = true;
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            try {
                Class.forName("io.papermc.paper.threadedregions.RegionizedServer");
                folia = true;
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            SPIGOT = spigot;
            PAPER = paper;
            FOLIA = folia;
        }
    }

    public static class Type {
        public static final boolean MOJANG_MAPPED;
        public static final boolean CRAFTBUKKIT_RELOCATED;

        static {
            boolean mojangMapped = false;
            try {
                Class.forName("net.minecraft.nbt.CompoundTag");
                mojangMapped = true;
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            MOJANG_MAPPED = mojangMapped;
            String serverPackage = Bukkit.getServer().getClass().getPackage().getName();
            CRAFTBUKKIT_RELOCATED = serverPackage.startsWith("org.bukkit.craftbukkit.v1_");
        }
    }
}

