/*
 * Decompiled with CFR 0.152.
 */
package com.soystargaze.vitamin.modules;

import com.soystargaze.vitamin.modules.CancellableModule;
import com.soystargaze.vitamin.modules.ModuleDef;
import com.soystargaze.vitamin.modules.core.ArmorTrimModule;
import com.soystargaze.vitamin.modules.core.AutoToolModule;
import com.soystargaze.vitamin.modules.core.BoneMealExpansionModule;
import com.soystargaze.vitamin.modules.core.CampfireTweaksModule;
import com.soystargaze.vitamin.modules.core.CarryOnModule;
import com.soystargaze.vitamin.modules.core.CropProtectionModule;
import com.soystargaze.vitamin.modules.core.CustomRecipesModule;
import com.soystargaze.vitamin.modules.core.DeathChestModule;
import com.soystargaze.vitamin.modules.core.DeathMapModule;
import com.soystargaze.vitamin.modules.core.ElevatorModule;
import com.soystargaze.vitamin.modules.core.ElytraArmorModule;
import com.soystargaze.vitamin.modules.core.EnchantsBackModule;
import com.soystargaze.vitamin.modules.core.FireAspectOnToolsModule;
import com.soystargaze.vitamin.modules.core.InvisibleItemFramesModule;
import com.soystargaze.vitamin.modules.core.LeafDecayModule;
import com.soystargaze.vitamin.modules.core.OxygenBottleModule;
import com.soystargaze.vitamin.modules.core.PetProtectionModule;
import com.soystargaze.vitamin.modules.core.PlayerXptoBooksModule;
import com.soystargaze.vitamin.modules.core.RepairModule;
import com.soystargaze.vitamin.modules.core.ReplanterModule;
import com.soystargaze.vitamin.modules.core.ReplayableVaultModule;
import com.soystargaze.vitamin.modules.core.SilkSpawnersModule;
import com.soystargaze.vitamin.modules.core.SpongeWithLavaModule;
import com.soystargaze.vitamin.modules.core.TotemFromInventoryModule;
import com.soystargaze.vitamin.modules.core.TpToBedModule;
import com.soystargaze.vitamin.modules.core.UnlockRecipesModule;
import com.soystargaze.vitamin.modules.core.VeinLogModule;
import com.soystargaze.vitamin.modules.core.VeinMinerModule;
import com.soystargaze.vitamin.modules.core.VillagerTauntModule;
import com.soystargaze.vitamin.modules.core.VoidTotemModule;
import com.soystargaze.vitamin.modules.core.WallJumpModule;
import com.soystargaze.vitamin.modules.core.WeatherEffectsModule;
import com.soystargaze.vitamin.modules.paper.PaperDeathMapModule;
import com.soystargaze.vitamin.modules.paper.PaperElevatorModule;
import com.soystargaze.vitamin.modules.paper.PaperPlayerXptoBooksModule;
import com.soystargaze.vitamin.modules.paper.PaperTpToBedModule;
import com.soystargaze.vitamin.modules.paper.PaperVillagerTauntModule;
import com.soystargaze.vitamin.modules.paper.PaperWallJumpModule;
import com.soystargaze.vitamin.utils.text.TextHandler;
import com.soystargaze.vitamin.utils.updater.UpdateOnFullLoad;
import com.soystargaze.vitamin.utils.updater.UpdateOnJoinListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class ModuleManager {
    private static final List<ModuleDef> DEFS = List.of(new ModuleDef("module.auto_tool", p -> new AutoToolModule(), null), new ModuleDef("module.crop_protection", p -> new CropProtectionModule(), null), new ModuleDef("module.custom_recipes", p -> new CustomRecipesModule(), null), new ModuleDef("module.armor_trim", p -> new ArmorTrimModule(), null), new ModuleDef("module.invisible_item_frames", p -> new InvisibleItemFramesModule(), null), new ModuleDef("module.pet_protection", p -> new PetProtectionModule(), null), new ModuleDef("module.seed_replanter", p -> new ReplanterModule(), null), new ModuleDef("module.totem_from_inventory", p -> new TotemFromInventoryModule(), null), new ModuleDef("module.bone_meal_expansion", BoneMealExpansionModule::new, null), new ModuleDef("module.campfire_tweaks", CampfireTweaksModule::new, null), new ModuleDef("module.carry_on", CarryOnModule::new, null), new ModuleDef("module.death_chest", DeathChestModule::new, null), new ModuleDef("module.elytra_armor", ElytraArmorModule::new, null), new ModuleDef("module.enchants_back", EnchantsBackModule::new, null), new ModuleDef("module.fire_aspect_tools", FireAspectOnToolsModule::new, null), new ModuleDef("module.leaf_decay", LeafDecayModule::new, null), new ModuleDef("module.oxygen_bottle", OxygenBottleModule::new, null), new ModuleDef("module.repair", RepairModule::new, null), new ModuleDef("module.replayable_vault", ReplayableVaultModule::new, null), new ModuleDef("module.silk_spawners", SilkSpawnersModule::new, null), new ModuleDef("module.sponge_with_lava", SpongeWithLavaModule::new, null), new ModuleDef("module.void_totem", VoidTotemModule::new, null), new ModuleDef("module.unlock_all_recipes", UnlockRecipesModule::new, null), new ModuleDef("module.tree_vein_miner", VeinLogModule::new, null), new ModuleDef("module.vein_miner", VeinMinerModule::new, null), new ModuleDef("module.weather_effects", WeatherEffectsModule::new, null), new ModuleDef("module.death_map", DeathMapModule::new, PaperDeathMapModule::new), new ModuleDef("module.elevator", ElevatorModule::new, PaperElevatorModule::new), new ModuleDef("module.player_xp_to_books", PlayerXptoBooksModule::new, PaperPlayerXptoBooksModule::new), new ModuleDef("module.tp_to_bed_with_compass", TpToBedModule::new, PaperTpToBedModule::new), new ModuleDef("module.villager_follow_emeralds", VillagerTauntModule::new, PaperVillagerTauntModule::new), new ModuleDef("module.wall_jump", WallJumpModule::new, PaperWallJumpModule::new));
    private final JavaPlugin plugin;
    private final boolean isPaper;
    private final Map<String, Listener> modules = new HashMap<String, Listener>();
    private final List<Listener> systemListeners = new ArrayList<Listener>();

    public ModuleManager(JavaPlugin plugin) {
        this.plugin = plugin;
        this.isPaper = this.detectPaper();
        this.registerModules();
        this.registerSystemListeners();
    }

    private boolean detectPaper() {
        try {
            Class.forName("com.destroystokyo.paper.event.player.PlayerJumpEvent");
            TextHandler.get().logTranslated("plugin.paper_detected", new Object[0]);
            TextHandler.get().logTranslated("plugin.separator", new Object[0]);
            return true;
        }
        catch (ClassNotFoundException e) {
            TextHandler.get().logTranslated("plugin.paper_not_detected", new Object[0]);
            TextHandler.get().logTranslated("plugin.separator", new Object[0]);
            return false;
        }
    }

    private void registerModules() {
        for (Listener module : this.modules.values()) {
            if (!(module instanceof CancellableModule)) continue;
            ((CancellableModule)module).cancelTasks();
        }
        for (Listener module : this.modules.values()) {
            HandlerList.unregisterAll((Listener)module);
        }
        this.modules.clear();
        for (ModuleDef def : DEFS) {
            Listener module = def.create(this.plugin, this.isPaper);
            this.addModule(def.configPath(), module);
        }
    }

    private void registerSystemListeners() {
        for (Listener listener : this.systemListeners) {
            HandlerList.unregisterAll((Listener)listener);
        }
        this.systemListeners.clear();
        this.addUpdateListeners();
    }

    public void addUpdateListeners() {
        UpdateOnFullLoad updateListener = new UpdateOnFullLoad();
        UpdateOnJoinListener joinListener = new UpdateOnJoinListener();
        this.addSystemListener(updateListener);
        this.addSystemListener(joinListener);
    }

    public void addSystemListener(Listener listener) {
        this.systemListeners.add(listener);
        Bukkit.getPluginManager().registerEvents(listener, (Plugin)this.plugin);
    }

    private void addModule(String configPath, Listener module) {
        String moduleName = ModuleManager.getModuleName(configPath);
        if (this.plugin.getConfig().getBoolean(configPath, true)) {
            this.modules.put(configPath, module);
            Bukkit.getPluginManager().registerEvents(module, (Plugin)this.plugin);
            TextHandler.get().logTranslated("module.enabled", moduleName);
        } else {
            TextHandler.get().logTranslated("module.disabled", moduleName);
        }
    }

    private static String getModuleName(String configPath) {
        return configPath.replace("module.", "");
    }

    public void reloadModules() {
        this.plugin.reloadConfig();
        this.registerModules();
        this.registerSystemListeners();
    }

    public Listener getModule(String moduleName) {
        Object key = moduleName.startsWith("module.") ? moduleName : "module." + moduleName;
        return this.modules.get(key);
    }
}

