/*
 * Decompiled with CFR 0.152.
 */
package com.soystargaze.vitamin.modules.core;

import com.soystargaze.vitamin.config.ConfigHandler;
import com.soystargaze.vitamin.modules.core.ArmorBoostEffect;
import com.soystargaze.vitamin.modules.core.DamageListenerEffect;
import com.soystargaze.vitamin.modules.core.Effect;
import com.soystargaze.vitamin.modules.core.EnchantExpRefundEffect;
import com.soystargaze.vitamin.modules.core.EnchantListenerEffect;
import com.soystargaze.vitamin.modules.core.ExpListenerEffect;
import com.soystargaze.vitamin.modules.core.ExtraExpEffect;
import com.soystargaze.vitamin.modules.core.FireResistanceEffect;
import com.soystargaze.vitamin.modules.core.GenericDamageListenerEffect;
import com.soystargaze.vitamin.modules.core.HasteOnSneakEffect;
import com.soystargaze.vitamin.modules.core.HeroOfTheVillageEffect;
import com.soystargaze.vitamin.modules.core.InventoryListenerEffect;
import com.soystargaze.vitamin.modules.core.KnockbackResistanceEffect;
import com.soystargaze.vitamin.modules.core.MagnetEffect;
import com.soystargaze.vitamin.modules.core.NightVisionOnSneakEffect;
import com.soystargaze.vitamin.modules.core.RegenerationOnDamageEffect;
import com.soystargaze.vitamin.modules.core.SneakListenerEffect;
import com.soystargaze.vitamin.modules.core.SpeedOnSneakEffect;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.enchantment.EnchantItemEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.event.player.PlayerExpChangeEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.MerchantInventory;
import org.bukkit.inventory.meta.ArmorMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.trim.ArmorTrim;
import org.bukkit.inventory.meta.trim.TrimMaterial;

class ArmorTrimManager {
    private final Map<UUID, Map<TrimMaterial, Integer>> playerTrimCounts = new HashMap<UUID, Map<TrimMaterial, Integer>>();
    private final Map<TrimMaterial, List<Effect>> trimEffects = new HashMap<TrimMaterial, List<Effect>>();
    private static final Map<String, TrimMaterial> MATERIAL_MAP = new HashMap<String, TrimMaterial>();

    public ArmorTrimManager() {
        FileConfiguration config = ConfigHandler.getConfig();
        for (String materialKey : MATERIAL_MAP.keySet()) {
            if (!config.getBoolean("armor_trims." + materialKey + ".enabled", true)) continue;
            ArrayList<Effect> effects = new ArrayList<Effect>();
            switch (materialKey) {
                case "COPPER": {
                    if (!config.getBoolean("armor_trims." + materialKey + ".haste_on_sneak.enabled", true)) break;
                    int durationSeconds = config.getInt("armor_trims." + materialKey + ".haste_on_sneak.duration", 15);
                    int cooldownSeconds = config.getInt("armor_trims." + materialKey + ".haste_on_sneak.cooldown", 60);
                    effects.add(new HasteOnSneakEffect(durationSeconds * 20, cooldownSeconds));
                    break;
                }
                case "IRON": {
                    if (!config.getBoolean("armor_trims." + materialKey + ".magnet.enabled", true)) break;
                    double baseRadius = config.getDouble("armor_trims." + materialKey + ".magnet.base_radius", 1.0);
                    effects.add(new MagnetEffect(baseRadius));
                    break;
                }
                case "REDSTONE": {
                    if (!config.getBoolean("armor_trims." + materialKey + ".speed_on_sneak.enabled", true)) break;
                    double speedBoost = config.getDouble("armor_trims." + materialKey + ".speed_on_sneak.speed_boost", 0.05);
                    int durationSeconds = config.getInt("armor_trims." + materialKey + ".speed_on_sneak.duration", 5);
                    effects.add(new SpeedOnSneakEffect(speedBoost, durationSeconds));
                    break;
                }
                case "EMERALD": {
                    effects.add(new HeroOfTheVillageEffect());
                    break;
                }
                case "NETHERITE": {
                    int cooldownSeconds;
                    if (config.getBoolean("armor_trims." + materialKey + ".fire_resistance.enabled", true)) {
                        int durationSeconds = config.getInt("armor_trims." + materialKey + ".fire_resistance.duration", 10);
                        cooldownSeconds = config.getInt("armor_trims." + materialKey + ".fire_resistance.cooldown", 30);
                        effects.add(new FireResistanceEffect(durationSeconds, cooldownSeconds));
                    }
                    if (!config.getBoolean("armor_trims." + materialKey + ".knockback_resistance.enabled", true)) break;
                    effects.add(new KnockbackResistanceEffect());
                    break;
                }
                case "LAPIS": {
                    if (config.getBoolean("armor_trims." + materialKey + ".extra_exp.enabled", true)) {
                        double extraPerPiece = config.getDouble("armor_trims." + materialKey + ".extra_exp.extra_per_piece", 0.1);
                        effects.add(new ExtraExpEffect(extraPerPiece));
                    }
                    if (!config.getBoolean("armor_trims." + materialKey + ".enchant_exp_refund.enabled", true)) break;
                    double probabilityPerPiece = config.getDouble("armor_trims." + materialKey + ".enchant_exp_refund.probability_per_piece", 0.05);
                    double refundPercentage = config.getDouble("armor_trims." + materialKey + ".enchant_exp_refund.refund_percentage", 0.15);
                    effects.add(new EnchantExpRefundEffect(probabilityPerPiece, refundPercentage));
                    break;
                }
                case "QUARTZ": {
                    if (!config.getBoolean("armor_trims." + materialKey + ".night_vision_on_sneak.enabled", true)) break;
                    effects.add(new NightVisionOnSneakEffect());
                    break;
                }
                case "DIAMOND": {
                    if (!config.getBoolean("armor_trims." + materialKey + ".armor_boost.enabled", true)) break;
                    double reductionPerPiece = config.getDouble("armor_trims." + materialKey + ".armor_boost.reduction_per_piece", 0.08);
                    effects.add(new ArmorBoostEffect(reductionPerPiece));
                    break;
                }
                case "AMETHYST": {
                    if (!config.getBoolean("armor_trims." + materialKey + ".regeneration_on_damage.enabled", true)) break;
                    int durationSeconds = config.getInt("armor_trims." + materialKey + ".regeneration_on_damage.duration", 8);
                    int cooldownSeconds = config.getInt("armor_trims." + materialKey + ".regeneration_on_damage.cooldown", 15);
                    double radius = config.getDouble("armor_trims." + materialKey + ".regeneration_on_damage.radius", 5.0);
                    effects.add(new RegenerationOnDamageEffect(durationSeconds, cooldownSeconds, radius));
                }
            }
            if (effects.isEmpty()) continue;
            this.trimEffects.put(MATERIAL_MAP.get(materialKey), effects);
        }
    }

    public void updatePlayerTrims(Player player) {
        HashMap<TrimMaterial, Integer> counts = new HashMap<TrimMaterial, Integer>();
        for (ItemStack armor : player.getInventory().getArmorContents()) {
            ArmorMeta armorMeta;
            ArmorTrim trim;
            ItemMeta meta;
            if (armor == null || !armor.hasItemMeta() || !((meta = armor.getItemMeta()) instanceof ArmorMeta) || (trim = (armorMeta = (ArmorMeta)meta).getTrim()) == null) continue;
            counts.put(trim.getMaterial(), counts.getOrDefault(trim.getMaterial(), 0) + 1);
        }
        this.playerTrimCounts.put(player.getUniqueId(), counts);
    }

    public void applyEffects(Player player) {
        Map counts = this.playerTrimCounts.getOrDefault(player.getUniqueId(), new HashMap());
        for (Map.Entry entry : counts.entrySet()) {
            List<Effect> effects = this.trimEffects.get(entry.getKey());
            if (effects == null) continue;
            for (Effect effect : effects) {
                effect.apply(player, (Integer)entry.getValue());
            }
        }
    }

    public boolean hasGoldArmorTrim(Player player) {
        FileConfiguration config = ConfigHandler.getConfig();
        if (!config.getBoolean("armor_trims.GOLD.enabled", true)) {
            return false;
        }
        Map counts = this.playerTrimCounts.getOrDefault(player.getUniqueId(), new HashMap());
        return counts.getOrDefault(TrimMaterial.GOLD, 0) > 0;
    }

    public void handleSneak(Player player, boolean isSneaking) {
        Map counts = this.playerTrimCounts.getOrDefault(player.getUniqueId(), new HashMap());
        for (Map.Entry entry : counts.entrySet()) {
            List<Effect> effects = this.trimEffects.get(entry.getKey());
            if (effects == null) continue;
            for (Effect effect : effects) {
                if (!(effect instanceof SneakListenerEffect)) continue;
                ((SneakListenerEffect)effect).onSneak(player, (Integer)entry.getValue(), isSneaking);
            }
        }
    }

    public void handleDamage(EntityDamageByEntityEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            Map counts = this.playerTrimCounts.getOrDefault(player.getUniqueId(), new HashMap());
            for (Map.Entry entry : counts.entrySet()) {
                List<Effect> effects = this.trimEffects.get(entry.getKey());
                if (effects == null) continue;
                for (Effect effect : effects) {
                    if (!(effect instanceof DamageListenerEffect)) continue;
                    ((DamageListenerEffect)effect).onDamage(event, (Integer)entry.getValue());
                }
            }
        }
    }

    public void handleExpChange(PlayerExpChangeEvent event) {
        Player player = event.getPlayer();
        Map counts = this.playerTrimCounts.getOrDefault(player.getUniqueId(), new HashMap());
        for (Map.Entry entry : counts.entrySet()) {
            List<Effect> effects = this.trimEffects.get(entry.getKey());
            if (effects == null) continue;
            for (Effect effect : effects) {
                if (!(effect instanceof ExpListenerEffect)) continue;
                ((ExpListenerEffect)effect).onExpChange(event, (Integer)entry.getValue());
            }
        }
    }

    public void handleInventoryOpen(InventoryOpenEvent event) {
        if (event.getInventory() instanceof MerchantInventory) {
            Player player = (Player)event.getPlayer();
            Map counts = this.playerTrimCounts.getOrDefault(player.getUniqueId(), new HashMap());
            for (Map.Entry entry : counts.entrySet()) {
                List<Effect> effects = this.trimEffects.get(entry.getKey());
                if (effects == null) continue;
                for (Effect effect : effects) {
                    if (!(effect instanceof InventoryListenerEffect)) continue;
                    ((InventoryListenerEffect)effect).onInventoryOpen(event, (Integer)entry.getValue());
                }
            }
        }
    }

    public void handleGenericDamage(EntityDamageEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            Map counts = this.playerTrimCounts.getOrDefault(player.getUniqueId(), new HashMap());
            for (Map.Entry entry : counts.entrySet()) {
                List<Effect> effects = this.trimEffects.get(entry.getKey());
                if (effects == null) continue;
                for (Effect effect : effects) {
                    if (!(effect instanceof GenericDamageListenerEffect)) continue;
                    ((GenericDamageListenerEffect)effect).onGenericDamage(event, (Integer)entry.getValue());
                }
            }
        }
    }

    public void handleEnchantItem(EnchantItemEvent event) {
        Player player = event.getEnchanter();
        Map counts = this.playerTrimCounts.getOrDefault(player.getUniqueId(), new HashMap());
        for (Map.Entry entry : counts.entrySet()) {
            List<Effect> effects = this.trimEffects.get(entry.getKey());
            if (effects == null) continue;
            for (Effect effect : effects) {
                if (!(effect instanceof EnchantListenerEffect)) continue;
                ((EnchantListenerEffect)effect).onEnchant(event, (Integer)entry.getValue());
            }
        }
    }

    public int getTrimStack(Player player, TrimMaterial material) {
        return ((Map)this.playerTrimCounts.getOrDefault(player.getUniqueId(), new HashMap())).getOrDefault(material, 0);
    }

    static {
        MATERIAL_MAP.put("COPPER", TrimMaterial.COPPER);
        MATERIAL_MAP.put("IRON", TrimMaterial.IRON);
        MATERIAL_MAP.put("REDSTONE", TrimMaterial.REDSTONE);
        MATERIAL_MAP.put("EMERALD", TrimMaterial.EMERALD);
        MATERIAL_MAP.put("NETHERITE", TrimMaterial.NETHERITE);
        MATERIAL_MAP.put("LAPIS", TrimMaterial.LAPIS);
        MATERIAL_MAP.put("QUARTZ", TrimMaterial.QUARTZ);
        MATERIAL_MAP.put("DIAMOND", TrimMaterial.DIAMOND);
        MATERIAL_MAP.put("AMETHYST", TrimMaterial.AMETHYST);
        MATERIAL_MAP.put("GOLD", TrimMaterial.GOLD);
    }
}

