/*
 * Decompiled with CFR 0.152.
 */
package com.soystargaze.vitamin.modules.core;

import com.soystargaze.vitamin.Vitamin;
import com.soystargaze.vitamin.database.DatabaseHandler;
import com.soystargaze.vitamin.integration.GriefPreventionIntegrationHandler;
import com.soystargaze.vitamin.integration.LandsIntegrationHandler;
import com.soystargaze.vitamin.integration.LootinIntegrationHandler;
import com.soystargaze.vitamin.integration.WorldGuardIntegrationHandler;
import com.soystargaze.vitamin.utils.LogUtils;
import com.soystargaze.vitamin.utils.text.TextHandler;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.UUID;
import me.ryanhamshire.GriefPrevention.GriefPrevention;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.Container;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.Chest;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.ItemFrame;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Monster;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.entity.EntityDismountEvent;
import org.bukkit.event.entity.EntityTargetEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.DoubleChestInventory;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BlockStateMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitRunnable;

public class CarryOnModule
implements Listener {
    private final JavaPlugin plugin;
    private final double maxCarryWeight;
    private final NamespacedKey storedBlockKey;
    private final NamespacedKey chestIdKey;
    private WorldGuardIntegrationHandler wgIntegration;
    private LandsIntegrationHandler landsIntegration;
    private LootinIntegrationHandler lootinIntegration;
    private final boolean allowStacking;
    private GriefPreventionIntegrationHandler gpIntegration;
    private final boolean preventContainerStacking;

    public CarryOnModule(JavaPlugin plugin) {
        this.plugin = plugin;
        this.maxCarryWeight = plugin.getConfig().getDouble("carry_on.max_weight", 100.0);
        this.allowStacking = plugin.getConfig().getBoolean("carry_on.allow_stacking", false);
        this.preventContainerStacking = plugin.getConfig().getBoolean("carry_on.prevent_container_stacking", true);
        this.storedBlockKey = new NamespacedKey((Plugin)plugin, "stored_block");
        this.chestIdKey = new NamespacedKey((Plugin)plugin, "chest_id");
        this.setupIntegrations(plugin);
    }

    private void setupIntegrations(JavaPlugin plugin) {
        if (plugin.getServer().getPluginManager().getPlugin("WorldGuard") != null) {
            TextHandler.get().logTranslated("plugin.integration.worldguard_detected", new Object[0]);
            this.wgIntegration = new WorldGuardIntegrationHandler(plugin);
        }
        if (plugin.getServer().getPluginManager().getPlugin("Lands") != null) {
            TextHandler.get().logTranslated("plugin.integration.lands_detected", new Object[0]);
            this.landsIntegration = new LandsIntegrationHandler(plugin);
        }
        if (plugin.getServer().getPluginManager().getPlugin("Lootin") != null) {
            TextHandler.get().logTranslated("plugin.integration.lootin_detected", new Object[0]);
            this.lootinIntegration = new LootinIntegrationHandler(plugin);
        }
        if (plugin.getServer().getPluginManager().getPlugin("GriefPrevention") != null) {
            TextHandler.get().logTranslated("plugin.integration.griefprevention_detected", new Object[0]);
            try {
                Bukkit.getScheduler().runTaskLater((Plugin)plugin, () -> {
                    if (GriefPrevention.instance != null) {
                        this.gpIntegration = new GriefPreventionIntegrationHandler(plugin);
                        TextHandler.get().logTranslated("plugin.integration.griefprevention_integration_success", new Object[0]);
                    } else {
                        TextHandler.get().logTranslated("plugin.integration.griefprevention_integration_failed", new Object[0]);
                    }
                }, 20L);
            }
            catch (Exception e) {
                TextHandler.get().logTranslated("plugin.integration.griefprevention_integration_failed", e.getMessage());
            }
        }
    }

    @EventHandler
    public void onEntityTarget(EntityTargetEvent event) {
        if (event.getEntity().getScoreboardTags().contains("being_carried")) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onEntityPickup(PlayerInteractEntityEvent event) {
        if (event.getHand() != EquipmentSlot.HAND) {
            return;
        }
        Player player = event.getPlayer();
        if (!(player.hasPermission("vitamin.module.carry_on") && player.hasPermission("vitamin.module.carry_on.entity") && DatabaseHandler.isModuleEnabledForPlayer(player.getUniqueId(), "module.carry_on"))) {
            return;
        }
        if (!player.getPassengers().isEmpty()) {
            this.releaseEntity(player);
            event.setCancelled(true);
            return;
        }
        Entity entity = event.getRightClicked();
        if (entity instanceof ItemFrame) {
            return;
        }
        if (!(player.isSneaking() && player.getInventory().getItemInMainHand().getType().isAir() && player.getInventory().getItemInOffHand().getType().isAir())) {
            return;
        }
        if (entity instanceof Player) {
            boolean allowPickupPlayers = this.plugin.getConfig().getBoolean("carry_on.allow_player_pickup", false);
            if (!allowPickupPlayers || !player.hasPermission("vitamin.module.carry_on.entity.player")) {
                TextHandler.get().sendMessage(player, "carry_on.cannot_pickup_players", new Object[0]);
                event.setCancelled(true);
                return;
            }
            if (!this.allowStacking) {
                if (!player.getPassengers().isEmpty()) {
                    TextHandler.get().sendMessage(player, "carry_on.cannot_carry_while_carrying", new Object[0]);
                    event.setCancelled(true);
                    return;
                }
                if (player.getVehicle() != null) {
                    TextHandler.get().sendMessage(player, "carry_on.cannot_carry_while_being_carried", new Object[0]);
                    event.setCancelled(true);
                    return;
                }
                if (!entity.getPassengers().isEmpty()) {
                    TextHandler.get().sendMessage(player, "carry_on.cannot_carry_someone_carrying", new Object[0]);
                    event.setCancelled(true);
                    return;
                }
                if (entity.getVehicle() != null) {
                    TextHandler.get().sendMessage(player, "carry_on.cannot_carry_someone_being_carried", new Object[0]);
                    event.setCancelled(true);
                    return;
                }
            }
        }
        if (!(entity instanceof LivingEntity)) {
            TextHandler.get().sendMessage(player, "carry_on.cannot_pickup_entity", new Object[0]);
            event.setCancelled(true);
            return;
        }
        LivingEntity livingEntity = (LivingEntity)entity;
        if (entity.getScoreboardTags().contains("being_carried")) {
            TextHandler.get().sendMessage(player, "carry_on.cannot_pickup_entity", new Object[0]);
            event.setCancelled(true);
            return;
        }
        AttributeInstance maxHPInstance = livingEntity.getAttribute(Vitamin.getInstance().getVersionAdapter().getMaxHPAttribute());
        if (maxHPInstance == null) {
            event.setCancelled(true);
            return;
        }
        double entityWeight = maxHPInstance.getBaseValue() * 2.0;
        if (entityWeight > this.maxCarryWeight) {
            TextHandler.get().sendMessage(player, "carry_on.entity_too_heavy", new Object[0]);
            event.setCancelled(true);
            return;
        }
        if (this.wgIntegration != null && !this.wgIntegration.canInteractEntity(player, entity.getLocation())) {
            TextHandler.get().sendMessage(player, "carry_on.no_permissions", new Object[0]);
            event.setCancelled(true);
            return;
        }
        if (this.landsIntegration != null && !this.landsIntegration.canInteract(player, entity.getLocation())) {
            TextHandler.get().sendMessage(player, "carry_on.no_permissions", new Object[0]);
            event.setCancelled(true);
            return;
        }
        if (this.gpIntegration != null) {
            try {
                if (!this.gpIntegration.canInteract(player, entity.getLocation(), (Event)event)) {
                    TextHandler.get().sendMessage(player, "carry_on.no_permissions", new Object[0]);
                    event.setCancelled(true);
                    return;
                }
            }
            catch (Exception e) {
                TextHandler.get().logTranslated("plugin.integration.griefprevention_error", e.getMessage());
                event.setCancelled(true);
                return;
            }
        }
        int slownessLevel = (int)Math.ceil(entityWeight / 15.0);
        this.applySlowness(player, slownessLevel);
        player.addPassenger(entity);
        entity.setGravity(false);
        entity.addScoreboardTag("being_carried");
        if (entity instanceof Monster) {
            Monster monster = (Monster)entity;
            monster.setAI(false);
        }
        TextHandler.get().sendMessage(player, "carry_on.picked_up_entity", entityWeight, this.maxCarryWeight);
        LogUtils.logEntityPickup(player.getName(), entity.getType().name(), entity.getLocation());
        event.setCancelled(true);
    }

    @EventHandler
    public void onBlockPickup(PlayerInteractEvent event) {
        boolean allow;
        Player player = event.getPlayer();
        if (!player.hasPermission("vitamin.module.carry_on") || !DatabaseHandler.isModuleEnabledForPlayer(player.getUniqueId(), "module.carry_on")) {
            return;
        }
        if (!player.isSneaking() || event.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        if (!player.getInventory().getItemInMainHand().getType().isAir() || !player.getInventory().getItemInOffHand().getType().isAir()) {
            return;
        }
        Block block = event.getClickedBlock();
        if (block == null || !(block.getState() instanceof Container)) {
            return;
        }
        String containerType = block.getType().name().toLowerCase();
        String specificPerm = "vitamin.module.carry_on.container." + containerType;
        if (!player.hasPermission(specificPerm)) {
            TextHandler.get().sendMessage(player, "carry_on.no_permission_" + containerType, new Object[0]);
            event.setCancelled(true);
            return;
        }
        if (this.lootinIntegration != null && this.lootinIntegration.isLootinContainer(block.getState()) && !(allow = this.plugin.getConfig().getBoolean("carry_on.allow_lootin_pickup", false))) {
            TextHandler.get().sendMessage(player, "carry_on.no_lootin_pickup", new Object[0]);
            event.setCancelled(true);
            return;
        }
        if (this.wgIntegration != null && !this.wgIntegration.canInteractContainer(player, block.getLocation())) {
            TextHandler.get().sendMessage(player, "carry_on.no_permissions", new Object[0]);
            event.setCancelled(true);
            return;
        }
        if (this.landsIntegration != null && !this.landsIntegration.canBreak(player, block.getLocation(), block.getType())) {
            TextHandler.get().sendMessage(player, "carry_on.no_permissions", new Object[0]);
            event.setCancelled(true);
            return;
        }
        if (this.gpIntegration != null) {
            try {
                if (!this.gpIntegration.hasContainerPermissions(player, block.getLocation(), (Event)event)) {
                    TextHandler.get().sendMessage(player, "carry_on.no_permissions", new Object[0]);
                    event.setCancelled(true);
                    return;
                }
            }
            catch (Exception e) {
                TextHandler.get().logTranslated("plugin.integration.griefprevention_error", e.getMessage());
                event.setCancelled(true);
                return;
            }
        }
        if (block.getType() == Material.CHEST || block.getType() == Material.TRAPPED_CHEST) {
            this.pickupChestAsIndividual(player, block);
        } else {
            this.pickupSingleContainer(player, block);
        }
        event.setCancelled(true);
    }

    @EventHandler
    public void onBlockDrop(PlayerInteractEvent event) {
        Player player = event.getPlayer();
        if (!player.hasPermission("vitamin.module.carry_on") || !DatabaseHandler.isModuleEnabledForPlayer(player.getUniqueId(), "module.carry_on")) {
            return;
        }
        if (!(player.getPassengers().isEmpty() || event.getAction() != Action.RIGHT_CLICK_AIR && event.getAction() != Action.RIGHT_CLICK_BLOCK)) {
            this.releaseEntity(player);
            event.setCancelled(true);
            return;
        }
        if (event.getAction() != Action.RIGHT_CLICK_AIR && event.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        ItemStack item = player.getInventory().getItemInMainHand();
        if (item.getType() == Material.AIR || !item.hasItemMeta()) {
            return;
        }
        ItemMeta itemMeta = item.getItemMeta();
        if (!(itemMeta instanceof BlockStateMeta)) {
            return;
        }
        BlockStateMeta meta = (BlockStateMeta)itemMeta;
        if (!meta.getPersistentDataContainer().has(this.storedBlockKey, PersistentDataType.STRING)) {
            return;
        }
        Block targetBlock = player.getTargetBlockExact(5);
        if (targetBlock == null || !targetBlock.getType().isAir()) {
            return;
        }
        if (this.wgIntegration != null && !this.wgIntegration.canInteractContainer(player, targetBlock.getLocation())) {
            TextHandler.get().sendMessage(player, "carry_on.no_permissions", new Object[0]);
            event.setCancelled(true);
            return;
        }
        Material blockType = Material.valueOf((String)((String)meta.getPersistentDataContainer().get(this.storedBlockKey, PersistentDataType.STRING)));
        if (this.landsIntegration != null && !this.landsIntegration.canBreak(player, targetBlock.getLocation(), blockType)) {
            TextHandler.get().sendMessage(player, "carry_on.no_permissions", new Object[0]);
            event.setCancelled(true);
            return;
        }
        if (this.gpIntegration != null) {
            try {
                if (!this.gpIntegration.hasContainerPermissions(player, targetBlock.getLocation(), (Event)event)) {
                    TextHandler.get().sendMessage(player, "carry_on.no_permissions", new Object[0]);
                    event.setCancelled(true);
                    return;
                }
            }
            catch (Exception e) {
                TextHandler.get().logTranslated("plugin.integration.griefprevention_error", e.getMessage());
                event.setCancelled(true);
                return;
            }
        }
        if (blockType == Material.CHEST || blockType == Material.TRAPPED_CHEST) {
            if (meta.getPersistentDataContainer().has(this.chestIdKey, PersistentDataType.STRING)) {
                this.placeChest(player, targetBlock, meta);
            } else {
                this.placeSingleContainer(player, targetBlock, meta);
            }
        } else {
            this.placeSingleContainer(player, targetBlock, meta);
        }
        event.setCancelled(true);
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        Player player = event.getPlayer();
        if (!player.getPassengers().isEmpty()) {
            this.releaseEntity(player);
        }
    }

    @EventHandler
    public void onPlayerDeath(PlayerDeathEvent event) {
        Player player = event.getEntity();
        if (!player.getPassengers().isEmpty()) {
            this.releaseEntity(player);
        }
    }

    @EventHandler
    public void onEntityDismount(EntityDismountEvent event) {
        Player player;
        Entity entity;
        block5: {
            block4: {
                Entity dismounted = event.getDismounted();
                entity = event.getEntity();
                if (!(dismounted instanceof Player)) break block4;
                player = (Player)dismounted;
                if (entity instanceof Player) break block5;
            }
            return;
        }
        Player mountedPlayer = (Player)entity;
        if (mountedPlayer.getScoreboardTags().contains("being_carried")) {
            mountedPlayer.setGravity(true);
            mountedPlayer.removeScoreboardTag("being_carried");
            player.removePassenger((Entity)mountedPlayer);
            mountedPlayer.teleport(player.getLocation().add(0.0, 0.5, 0.0));
            this.removeSlowness(player);
            TextHandler.get().sendMessage(player, "carry_on.entity_dropped", new Object[0]);
            TextHandler.get().sendMessage(mountedPlayer, "carry_on.you_dismounted", new Object[0]);
        }
    }

    private void pickupSingleContainer(Player player, Block block) {
        Container container = (Container)block.getState();
        if (this.preventContainerStacking && !player.hasPermission("vitamin.module.carry_on.stacking_bypass") && this.hasNestedContainer(container.getInventory())) {
            TextHandler.get().sendMessage(player, "carry_on.no_stacking_allowed", new Object[0]);
            return;
        }
        UUID containerId = UUID.randomUUID();
        this.saveContainerBackup(containerId, player, block);
        this.saveChestContents(containerId, container.getInventory());
        ItemStack blockItem = new ItemStack(block.getType());
        ItemMeta itemMeta = blockItem.getItemMeta();
        if (!(itemMeta instanceof BlockStateMeta)) {
            return;
        }
        BlockStateMeta meta = (BlockStateMeta)itemMeta;
        Container tempContainer = (Container)block.getState();
        meta.setBlockState((BlockState)tempContainer);
        meta.getPersistentDataContainer().set(this.storedBlockKey, PersistentDataType.STRING, (Object)block.getType().name());
        meta.getPersistentDataContainer().set(this.chestIdKey, PersistentDataType.STRING, (Object)containerId.toString());
        blockItem.setItemMeta((ItemMeta)meta);
        String containerType = block.getType().name();
        block.setType(Material.AIR);
        player.getInventory().addItem(new ItemStack[]{blockItem});
        TextHandler.get().sendMessage(player, "carry_on.picked_up_block", block.getType().name().toLowerCase().replace("_", " "));
        LogUtils.logContainerPickup(player.getName(), containerType, containerId.toString(), block.getLocation());
    }

    private void pickupChestAsIndividual(Player player, Block block) {
        ItemStack[] thisContents;
        Material originalType = block.getType();
        Container originalState = (Container)block.getState();
        Inventory chestInventory = originalState.getInventory();
        boolean isDouble = this.isPartOfDoubleChest(block);
        Block partner = null;
        ItemStack[] otherContents = null;
        if (isDouble) {
            partner = this.findCorrectDoubleChestPartner(block);
            if (partner != null) {
                DoubleChestInventory doubleInv = (DoubleChestInventory)chestInventory;
                thisContents = this.extractIndividualChestContents(block, doubleInv);
                otherContents = this.extractIndividualChestContents(partner, doubleInv);
            } else {
                thisContents = chestInventory.getContents();
            }
        } else {
            thisContents = chestInventory.getContents();
        }
        if (this.preventContainerStacking && !player.hasPermission("vitamin.module.carry_on.stacking_bypass") && this.hasNestedContainer(thisContents)) {
            TextHandler.get().sendMessage(player, "carry_on.no_stacking_allowed", new Object[0]);
            return;
        }
        UUID chestId = UUID.randomUUID();
        this.saveContainerBackup(chestId, player, block);
        ItemStack blockItem = new ItemStack(originalType);
        ItemMeta itemMeta = blockItem.getItemMeta();
        if (!(itemMeta instanceof BlockStateMeta)) {
            return;
        }
        BlockStateMeta meta = (BlockStateMeta)itemMeta;
        meta.setBlockState((BlockState)originalState);
        meta.getPersistentDataContainer().set(this.storedBlockKey, PersistentDataType.STRING, (Object)originalType.name());
        meta.getPersistentDataContainer().set(this.chestIdKey, PersistentDataType.STRING, (Object)chestId.toString());
        blockItem.setItemMeta((ItemMeta)meta);
        String containerType = originalType.name();
        if (isDouble && partner != null) {
            Block finalPartner = partner;
            ItemStack[] finalOtherContents = otherContents;
            this.saveChestContents(chestId, thisContents);
            block.setType(Material.AIR);
            Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
                if (finalPartner.getType() == originalType) {
                    Container otherContainer = (Container)finalPartner.getState();
                    Inventory otherInventory = otherContainer.getInventory();
                    otherInventory.clear();
                    for (int i = 0; i < Math.min(27, finalOtherContents.length); ++i) {
                        if (finalOtherContents[i] == null) continue;
                        otherInventory.setItem(i, finalOtherContents[i]);
                    }
                    otherContainer.update();
                }
            }, 2L);
        } else {
            this.saveChestContents(chestId, chestInventory);
            block.setType(Material.AIR);
        }
        player.getInventory().addItem(new ItemStack[]{blockItem});
        TextHandler.get().sendMessage(player, "carry_on.picked_up_chest", new Object[0]);
        LogUtils.logContainerPickup(player.getName(), containerType, chestId.toString(), block.getLocation());
    }

    private void saveContainerBackup(UUID containerId, Player player, Block block) {
        String sql = " INSERT INTO container_backups \n (chest_id, player_uuid, player_name, container_type, pickup_timestamp, world_name, x_coord, y_coord, z_coord) \n VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)\n ";
        try (Connection conn = DatabaseHandler.getConnection();
             PreparedStatement ps = conn.prepareStatement(sql);){
            ps.setString(1, containerId.toString());
            ps.setString(2, player.getUniqueId().toString());
            ps.setString(3, player.getName());
            ps.setString(4, block.getType().name());
            ps.setLong(5, System.currentTimeMillis());
            ps.setString(6, block.getWorld().getName());
            ps.setInt(7, block.getX());
            ps.setInt(8, block.getY());
            ps.setInt(9, block.getZ());
            ps.executeUpdate();
        }
        catch (SQLException e) {
            TextHandler.get().logTranslated("database.backup.save_error", e);
        }
    }

    private boolean isPartOfDoubleChest(Block block) {
        Chest chestData = (Chest)block.getBlockData();
        return chestData.getType() != Chest.Type.SINGLE;
    }

    private Block findCorrectDoubleChestPartner(Block block) {
        BlockFace[] faces;
        if (!this.isPartOfDoubleChest(block)) {
            return null;
        }
        Container container = (Container)block.getState();
        Inventory blockInventory = container.getInventory();
        for (BlockFace face : faces = new BlockFace[]{BlockFace.NORTH, BlockFace.SOUTH, BlockFace.EAST, BlockFace.WEST}) {
            boolean validPair;
            Container relativeContainer;
            Inventory relativeInventory;
            Block relative = block.getRelative(face);
            if (relative.getType() != block.getType() || !this.isPartOfDoubleChest(relative) || blockInventory != (relativeInventory = (relativeContainer = (Container)relative.getState()).getInventory()) || !(blockInventory instanceof DoubleChestInventory)) continue;
            Chest blockChestData = (Chest)block.getBlockData();
            Chest relativeChestData = (Chest)relative.getBlockData();
            boolean bl = validPair = blockChestData.getType() == Chest.Type.LEFT && relativeChestData.getType() == Chest.Type.RIGHT || blockChestData.getType() == Chest.Type.RIGHT && relativeChestData.getType() == Chest.Type.LEFT;
            if (!validPair) continue;
            return relative;
        }
        return null;
    }

    private ItemStack[] extractIndividualChestContents(Block block, DoubleChestInventory doubleChestInventory) {
        ItemStack[] contents = new ItemStack[27];
        Chest chestData = (Chest)block.getBlockData();
        int startSlot = 0;
        if (chestData.getType() == Chest.Type.RIGHT) {
            startSlot = 27;
        }
        for (int i = 0; i < 27; ++i) {
            ItemStack item = doubleChestInventory.getItem(startSlot + i);
            contents[i] = item != null ? item.clone() : null;
        }
        return contents;
    }

    private void placeSingleContainer(Player player, Block block, BlockStateMeta meta) {
        Material blockType = Material.valueOf((String)((String)meta.getPersistentDataContainer().get(this.storedBlockKey, PersistentDataType.STRING)));
        block.setType(blockType);
        Container container = (Container)block.getState();
        container.setBlockData(meta.getBlockState().getBlockData());
        container.update(true, false);
        String chestIdStr = (String)meta.getPersistentDataContainer().get(this.chestIdKey, PersistentDataType.STRING);
        if (chestIdStr != null) {
            UUID chestId = UUID.fromString(chestIdStr);
            Inventory containerInventory = container.getInventory();
            this.loadChestContents(chestId, containerInventory);
        }
        container.update(true, false);
        TextHandler.get().sendMessage(player, "carry_on.placed_block", new Object[0]);
        this.consumeItemInHand(player);
    }

    private void placeChest(Player player, Block block, BlockStateMeta meta) {
        Material blockType = Material.valueOf((String)((String)meta.getPersistentDataContainer().get(this.storedBlockKey, PersistentDataType.STRING)));
        block.setType(blockType);
        Chest chestData = (Chest)block.getBlockData();
        chestData.setType(Chest.Type.SINGLE);
        block.setBlockData((BlockData)chestData);
        Container container = (Container)block.getState();
        container.update(true, false);
        String chestIdStr = (String)meta.getPersistentDataContainer().get(this.chestIdKey, PersistentDataType.STRING);
        if (chestIdStr != null) {
            UUID chestId = UUID.fromString(chestIdStr);
            Inventory chestInventory = container.getInventory();
            this.loadChestContents(chestId, chestInventory);
        }
        container.update(true, false);
        TextHandler.get().sendMessage(player, "carry_on.placed_chest", new Object[0]);
        this.consumeItemInHand(player);
    }

    private void consumeItemInHand(Player player) {
        ItemStack item = player.getInventory().getItemInMainHand();
        if (item.getAmount() > 1) {
            item.setAmount(item.getAmount() - 1);
        } else {
            player.getInventory().setItemInMainHand(null);
        }
    }

    private void releaseEntity(Player player) {
        if (player.getPassengers().isEmpty()) {
            return;
        }
        player.getPassengers().forEach(entity -> {
            entity.setGravity(true);
            entity.removeScoreboardTag("being_carried");
            if (entity instanceof Monster) {
                Monster monster = (Monster)entity;
                monster.setAI(true);
            }
            if (entity instanceof Player) {
                Player mountedPlayer = (Player)entity;
                mountedPlayer.setGravity(true);
            }
            player.removePassenger(entity);
            entity.teleport(player.getLocation().add(0.0, 0.5, 0.0));
            Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> ((Entity)entity).eject(), 1L);
            LogUtils.logEntityDrop(player.getName(), entity.getType().name(), entity.getLocation());
        });
        this.removeSlowness(player);
        TextHandler.get().sendMessage(player, "carry_on.entity_dropped", new Object[0]);
    }

    private void applySlowness(final Player player, int level) {
        player.addPotionEffect(new PotionEffect(PotionEffectType.SLOWNESS, Integer.MAX_VALUE, level - 1, false, false));
        new BukkitRunnable(){

            public void run() {
                if (player.getPassengers().isEmpty()) {
                    CarryOnModule.this.removeSlowness(player);
                    this.cancel();
                }
            }
        }.runTaskTimer((Plugin)this.plugin, 20L, 20L);
    }

    private void removeSlowness(Player player) {
        player.removePotionEffect(PotionEffectType.SLOWNESS);
    }

    private void saveChestContents(UUID chestId, Inventory chestInventory) {
        String sql = "INSERT INTO chest_contents (chest_id, slot, item_data) VALUES (?, ?, ?)";
        try (Connection conn = DatabaseHandler.getConnection();
             PreparedStatement ps = conn.prepareStatement(sql);){
            for (int slot = 0; slot < chestInventory.getSize(); ++slot) {
                ItemStack item = chestInventory.getItem(slot);
                if (item == null) continue;
                String itemData = this.serializeItemStack(item);
                ps.setString(1, chestId.toString());
                ps.setInt(2, slot);
                ps.setString(3, itemData);
                ps.addBatch();
            }
            ps.executeBatch();
        }
        catch (SQLException e) {
            TextHandler.get().logTranslated("database.chest.save_error", e);
        }
    }

    private void saveChestContents(UUID chestId, ItemStack[] contents) {
        String sql = "INSERT INTO chest_contents (chest_id, slot, item_data) VALUES (?, ?, ?)";
        try (Connection conn = DatabaseHandler.getConnection();
             PreparedStatement ps = conn.prepareStatement(sql);){
            for (int slot = 0; slot < contents.length; ++slot) {
                ItemStack item = contents[slot];
                if (item == null) continue;
                String itemData = this.serializeItemStack(item);
                ps.setString(1, chestId.toString());
                ps.setInt(2, slot);
                ps.setString(3, itemData);
                ps.addBatch();
            }
            ps.executeBatch();
        }
        catch (SQLException e) {
            TextHandler.get().logTranslated("database.chest.save_error", e);
        }
    }

    private void loadChestContents(UUID chestId, Inventory chestInventory) {
        String sql = "SELECT slot, item_data FROM chest_contents WHERE chest_id = ?";
        try (Connection conn = DatabaseHandler.getConnection();
             PreparedStatement ps = conn.prepareStatement(sql);){
            ps.setString(1, chestId.toString());
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    int slot = rs.getInt("slot");
                    String itemData = rs.getString("item_data");
                    ItemStack item = this.deserializeItemStack(itemData);
                    if (slot >= chestInventory.getSize()) continue;
                    chestInventory.setItem(slot, item);
                }
            }
        }
        catch (SQLException e) {
            TextHandler.get().logTranslated("database.chest.load_error", e);
        }
    }

    private String serializeItemStack(ItemStack item) {
        YamlConfiguration config = new YamlConfiguration();
        config.set("item", (Object)item);
        return config.saveToString();
    }

    private ItemStack deserializeItemStack(String itemData) {
        YamlConfiguration config = new YamlConfiguration();
        try {
            config.loadFromString(itemData);
            return config.getItemStack("item");
        }
        catch (Exception e) {
            TextHandler.get().logTranslated("database.chest.deserialize_error", e);
            return null;
        }
    }

    private boolean hasNestedContainer(Inventory inventory) {
        for (ItemStack item : inventory.getContents()) {
            BlockStateMeta meta;
            ItemMeta itemMeta;
            if (item == null || !item.hasItemMeta() || !((itemMeta = item.getItemMeta()) instanceof BlockStateMeta) || !(meta = (BlockStateMeta)itemMeta).getPersistentDataContainer().has(this.storedBlockKey, PersistentDataType.STRING)) continue;
            return true;
        }
        return false;
    }

    private boolean hasNestedContainer(ItemStack[] contents) {
        for (ItemStack item : contents) {
            BlockStateMeta meta;
            ItemMeta itemMeta;
            if (item == null || !item.hasItemMeta() || !((itemMeta = item.getItemMeta()) instanceof BlockStateMeta) || !(meta = (BlockStateMeta)itemMeta).getPersistentDataContainer().has(this.storedBlockKey, PersistentDataType.STRING)) continue;
            return true;
        }
        return false;
    }
}

