/*
 * Decompiled with CFR 0.152.
 */
package com.soystargaze.vitamin.modules.core;

import com.soystargaze.vitamin.Vitamin;
import com.soystargaze.vitamin.database.DatabaseHandler;
import java.util.Collection;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.player.PlayerItemHeldEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerSwapHandItemsEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class ElytraArmorModule
implements Listener {
    private final double defaultArmorValue;
    private final JavaPlugin plugin;

    public ElytraArmorModule(JavaPlugin plugin) {
        this.plugin = plugin;
        this.defaultArmorValue = plugin.getConfig().getDouble("elytra_armor.value", 11.0);
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        if (!player.hasPermission("vitamin.module.elytra_armor") || !DatabaseHandler.isModuleEnabledForPlayer(player.getUniqueId(), "module.elytra_armor")) {
            return;
        }
        this.updateArmorBonus(player);
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        Player player = event.getPlayer();
        if (!player.hasPermission("vitamin.module.elytra_armor") || !DatabaseHandler.isModuleEnabledForPlayer(player.getUniqueId(), "module.elytra_armor")) {
            return;
        }
        Attribute armorAttribute = Vitamin.getInstance().getVersionAdapter().getArmorAttribute();
        AttributeInstance instance = player.getAttribute(armorAttribute);
        if (instance != null) {
            instance.setBaseValue(this.calculateTotalArmorFromEquipment(player));
        }
    }

    @EventHandler
    public void onSwapHandItems(PlayerSwapHandItemsEvent event) {
        Player player = event.getPlayer();
        if (!player.hasPermission("vitamin.module.elytra_armor") || !DatabaseHandler.isModuleEnabledForPlayer(player.getUniqueId(), "module.elytra_armor")) {
            return;
        }
        this.updateArmorBonus(player);
    }

    @EventHandler
    public void onHeldItemChange(PlayerItemHeldEvent event) {
        Player player = event.getPlayer();
        if (!player.hasPermission("vitamin.module.elytra_armor") || !DatabaseHandler.isModuleEnabledForPlayer(player.getUniqueId(), "module.elytra_armor")) {
            return;
        }
        this.updateArmorBonus(player);
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        HumanEntity humanEntity = event.getWhoClicked();
        if (humanEntity instanceof Player) {
            Player player = (Player)humanEntity;
            if (!player.hasPermission("vitamin.module.elytra_armor") || !DatabaseHandler.isModuleEnabledForPlayer(player.getUniqueId(), "module.elytra_armor")) {
                return;
            }
            Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> this.updateArmorBonus(player));
        }
    }

    private void updateArmorBonus(Player player) {
        ItemStack chestplate = player.getInventory().getChestplate();
        Attribute armorAttribute = Vitamin.getInstance().getVersionAdapter().getArmorAttribute();
        AttributeInstance instance = player.getAttribute(armorAttribute);
        if (instance == null) {
            return;
        }
        double baseArmorValue = this.calculateTotalArmorFromEquipment(player);
        double elytraBonus = chestplate != null && chestplate.getType() == Material.ELYTRA ? this.defaultArmorValue : 0.0;
        instance.setBaseValue(baseArmorValue + elytraBonus);
    }

    private double calculateTotalArmorFromEquipment(Player player) {
        double totalArmorValue = 0.0;
        for (ItemStack item : player.getInventory().getArmorContents()) {
            if (item == null || item.getType() == Material.AIR) continue;
            totalArmorValue += this.getArmorValueFromItem(item);
        }
        return totalArmorValue;
    }

    private double getArmorValueFromItem(ItemStack item) {
        if (item == null || item.getType() == Material.AIR) {
            return 0.0;
        }
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return 0.0;
        }
        Collection modifiers = meta.getAttributeModifiers(Vitamin.getInstance().getVersionAdapter().getArmorAttribute());
        if (modifiers == null) {
            return 0.0;
        }
        return modifiers.stream().mapToDouble(AttributeModifier::getAmount).sum();
    }
}

