/*
 * Decompiled with CFR 0.152.
 */
package com.soystargaze.vitamin.modules.core;

import com.soystargaze.vitamin.modules.core.EnchantListenerEffect;
import org.bukkit.Particle;
import org.bukkit.entity.Player;
import org.bukkit.event.enchantment.EnchantItemEvent;

class EnchantExpRefundEffect
implements EnchantListenerEffect {
    private final double probabilityPerPiece;
    private final double refundPercentage;

    public EnchantExpRefundEffect(double probabilityPerPiece, double refundPercentage) {
        this.probabilityPerPiece = probabilityPerPiece;
        this.refundPercentage = refundPercentage;
    }

    @Override
    public void onEnchant(EnchantItemEvent event, int stack) {
        double probability = this.probabilityPerPiece * (double)stack;
        if (Math.random() < probability) {
            int expSpent = event.getExpLevelCost() * 30;
            int refund = (int)((double)expSpent * this.refundPercentage);
            event.getEnchanter().giveExp(refund);
            Player player = event.getEnchanter();
            player.getWorld().spawnParticle(Particle.ENCHANT, player.getLocation().add(0.0, 1.0, 0.0), 15 * stack, 0.5, 0.5, 0.5, 1.0);
        }
    }

    @Override
    public void apply(Player player, int stack) {
    }
}

