/*
 * Decompiled with CFR 0.152.
 */
package com.soystargaze.vitamin.modules.core;

import com.soystargaze.vitamin.database.DatabaseHandler;
import java.util.Collection;
import java.util.EnumMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadLocalRandom;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.inventory.PrepareAnvilEvent;
import org.bukkit.inventory.AnvilInventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.EnchantmentStorageMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.view.AnvilView;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class FireAspectOnToolsModule
implements Listener {
    private final JavaPlugin plugin;
    private final Map<Material, Material> smeltMap;
    private final Set<Location> processedBlocks = ConcurrentHashMap.newKeySet();

    public FireAspectOnToolsModule(JavaPlugin plugin) {
        this.plugin = plugin;
        this.smeltMap = this.initializeSmeltMap();
    }

    private Map<Material, Material> initializeSmeltMap() {
        EnumMap<Material, Material> map = new EnumMap<Material, Material>(Material.class);
        map.put(Material.IRON_ORE, Material.IRON_INGOT);
        map.put(Material.RAW_IRON, Material.IRON_INGOT);
        map.put(Material.GOLD_ORE, Material.GOLD_INGOT);
        map.put(Material.RAW_GOLD, Material.GOLD_INGOT);
        map.put(Material.NETHER_GOLD_ORE, Material.GOLD_INGOT);
        map.put(Material.COPPER_ORE, Material.COPPER_INGOT);
        map.put(Material.RAW_COPPER, Material.COPPER_INGOT);
        map.put(Material.DEEPSLATE_GOLD_ORE, Material.GOLD_INGOT);
        map.put(Material.DEEPSLATE_COPPER_ORE, Material.COPPER_INGOT);
        map.put(Material.DEEPSLATE_IRON_ORE, Material.IRON_INGOT);
        map.put(Material.SAND, Material.GLASS);
        map.put(Material.RED_SAND, Material.GLASS);
        map.put(Material.STONE, Material.STONE);
        map.put(Material.COBBLESTONE, Material.STONE);
        map.put(Material.CLAY_BALL, Material.BRICK);
        map.put(Material.KELP, Material.DRIED_KELP);
        map.put(Material.WET_SPONGE, Material.SPONGE);
        map.put(Material.CLAY, Material.TERRACOTTA);
        map.put(Material.POTATO, Material.BAKED_POTATO);
        return map;
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onPrepareAnvil(PrepareAnvilEvent event) {
        EnchantmentStorageMeta esm;
        ItemMeta itemMeta;
        AnvilView anvilView = event.getView();
        AnvilInventory inventory = event.getInventory();
        Player player = (Player)anvilView.getPlayer();
        if (player == null) {
            return;
        }
        if (!player.hasPermission("vitamin.module.fire_aspect_tools") || !DatabaseHandler.isModuleEnabledForPlayer(player.getUniqueId(), "module.fire_aspect_tools")) {
            return;
        }
        ItemStack left = inventory.getItem(0);
        ItemStack right = inventory.getItem(1);
        if (left == null) {
            return;
        }
        if (right != null && right.getType() == Material.ENCHANTED_BOOK && right.hasItemMeta() && (itemMeta = right.getItemMeta()) instanceof EnchantmentStorageMeta && (esm = (EnchantmentStorageMeta)itemMeta).hasStoredEnchant(Enchantment.FIRE_ASPECT)) {
            int level = esm.getStoredEnchantLevel(Enchantment.FIRE_ASPECT);
            ItemStack result = left.clone();
            result.addUnsafeEnchantment(Enchantment.FIRE_ASPECT, level);
            event.setResult(result);
            int repairCost = level == 2 ? 14 : 7;
            anvilView.setRepairCost(repairCost);
        }
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onBlockBreak(BlockBreakEvent event) {
        Player player = event.getPlayer();
        if (!player.hasPermission("vitamin.module.fire_aspect_tools") || !DatabaseHandler.isModuleEnabledForPlayer(player.getUniqueId(), "module.fire_aspect_tools")) {
            return;
        }
        ItemStack tool = player.getInventory().getItemInMainHand();
        Material blockType = event.getBlock().getType();
        Location blockLocation = event.getBlock().getLocation();
        if (!this.isValidBreak(blockType, tool)) {
            return;
        }
        if (this.processedBlocks.contains(blockLocation)) {
            return;
        }
        this.processedBlocks.add(blockLocation);
        Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> this.processedBlocks.remove(blockLocation), 1L);
        event.setDropItems(false);
        int fireAspectLevel = tool.getEnchantmentLevel(Enchantment.FIRE_ASPECT);
        if (fireAspectLevel == 1) {
            if (ThreadLocalRandom.current().nextDouble() < 0.4) {
                this.processBlockDrop(event, tool);
            } else {
                this.dropNaturalItems(event, tool);
            }
        } else if (fireAspectLevel >= 2) {
            this.processBlockDrop(event, tool);
        }
    }

    private void dropNaturalItems(BlockBreakEvent event, ItemStack tool) {
        Collection naturalDrops = event.getBlock().getDrops(tool);
        for (ItemStack drop : naturalDrops) {
            event.getBlock().getWorld().dropItemNaturally(event.getBlock().getLocation(), drop);
        }
    }

    private void processBlockDrop(BlockBreakEvent event, ItemStack tool) {
        int amount = this.calculateDropAmount(tool);
        Material resultType = this.smeltMap.get(event.getBlock().getType());
        if (resultType == null) {
            this.dropNaturalItems(event, tool);
            return;
        }
        ItemStack smeltedItem = new ItemStack(resultType, amount);
        event.getBlock().getWorld().dropItemNaturally(event.getBlock().getLocation(), smeltedItem);
    }

    private int calculateDropAmount(ItemStack tool) {
        int fortuneLevel = tool.getEnchantmentLevel(Enchantment.FORTUNE);
        int dropAmount = 1;
        if (fortuneLevel > 0) {
            dropAmount += fortuneLevel;
        }
        return dropAmount;
    }

    private boolean isValidBreak(Material blockType, ItemStack tool) {
        return this.smeltMap.containsKey(blockType) && this.isValidTool(tool.getType()) && !tool.containsEnchantment(Enchantment.SILK_TOUCH) && tool.getEnchantmentLevel(Enchantment.FIRE_ASPECT) > 0;
    }

    private boolean isValidTool(Material material) {
        return switch (material) {
            case Material.WOODEN_PICKAXE, Material.STONE_PICKAXE, Material.IRON_PICKAXE, Material.GOLDEN_PICKAXE, Material.DIAMOND_PICKAXE, Material.NETHERITE_PICKAXE, Material.WOODEN_AXE, Material.STONE_AXE, Material.IRON_AXE, Material.GOLDEN_AXE, Material.DIAMOND_AXE, Material.NETHERITE_AXE, Material.WOODEN_SHOVEL, Material.STONE_SHOVEL, Material.IRON_SHOVEL, Material.GOLDEN_SHOVEL, Material.DIAMOND_SHOVEL, Material.NETHERITE_SHOVEL, Material.WOODEN_SWORD, Material.STONE_SWORD, Material.IRON_SWORD, Material.GOLDEN_SWORD, Material.DIAMOND_SWORD, Material.NETHERITE_SWORD, Material.WOODEN_HOE, Material.STONE_HOE, Material.IRON_HOE, Material.GOLDEN_HOE, Material.DIAMOND_HOE, Material.NETHERITE_HOE -> true;
            default -> false;
        };
    }
}

