/*
 * Decompiled with CFR 0.152.
 */
package com.soystargaze.vitamin.modules.core;

import com.soystargaze.vitamin.modules.core.SneakListenerEffect;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Particle;
import org.bukkit.entity.Player;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

class HasteOnSneakEffect
implements SneakListenerEffect {
    private final int duration;
    private final int cooldown;
    private final Map<UUID, Long> lastActivatedMap = new HashMap<UUID, Long>();

    public HasteOnSneakEffect(int duration, int cooldown) {
        this.duration = duration;
        this.cooldown = cooldown;
    }

    @Override
    public void onSneak(Player player, int stack, boolean isSneaking) {
        if (isSneaking) {
            int level;
            long now = System.currentTimeMillis();
            UUID uuid = player.getUniqueId();
            Long lastActivated = this.lastActivatedMap.get(uuid);
            if ((lastActivated == null || now - lastActivated >= (long)this.cooldown * 1000L) && (level = stack - 1) >= 0) {
                player.addPotionEffect(new PotionEffect(PotionEffectType.HASTE, this.duration, level, false, false));
                this.lastActivatedMap.put(uuid, now);
                player.getWorld().spawnParticle(Particle.ELECTRIC_SPARK, player.getLocation().add(0.0, 1.0, 0.0), 10 * stack, 0.5, 0.5, 0.5, 1.0);
            }
        }
    }

    @Override
    public void apply(Player player, int stack) {
    }
}

