/*
 * Decompiled with CFR 0.152.
 */
package com.soystargaze.vitamin.modules.core;

import com.soystargaze.vitamin.utils.AsyncExecutor;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class LeafDecayModule
implements Listener {
    private final JavaPlugin plugin;
    private final int maxRadius;
    private final int decayTime;
    private static final Set<Material> LOGS = EnumSet.noneOf(Material.class);
    private static final Set<Material> LEAVES = EnumSet.noneOf(Material.class);
    public static boolean ENABLED = true;
    private static LeafDecayModule instance;

    public LeafDecayModule(JavaPlugin plugin) {
        this.plugin = plugin;
        this.maxRadius = plugin.getConfig().getInt("leaf_decay.max_radius", 4);
        this.decayTime = plugin.getConfig().getInt("leaf_decay.decay_time", 4) * 20;
        instance = this;
    }

    public static LeafDecayModule getInstance() {
        return instance;
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onBlockBreak(BlockBreakEvent event) {
        Block block = event.getBlock();
        World world = block.getWorld();
        if (LOGS.contains(block.getType())) {
            AsyncExecutor.getExecutor().execute(() -> {
                try {
                    this.removeConnectedLeaves(world, block);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            });
        }
    }

    public void removeConnectedLeaves(World world, Block start) {
        HashSet<Block> visited = new HashSet<Block>();
        HashSet<Block> queue = new HashSet<Block>();
        queue.add(start);
        AtomicInteger blocksProcessed = new AtomicInteger(0);
        HashSet<Block> leavesToRemove = new HashSet<Block>();
        for (int distance = 0; !queue.isEmpty() && distance <= this.maxRadius; ++distance) {
            HashSet<Block> nextQueue = new HashSet<Block>();
            for (Block block : queue) {
                if (blocksProcessed.get() > 1000) {
                    return;
                }
                this.processNeighbors(block, visited, nextQueue, world, blocksProcessed, leavesToRemove);
            }
            queue = nextQueue;
        }
        this.scheduleLeafDecay(leavesToRemove);
    }

    private void processNeighbors(Block block, Set<Block> visited, Set<Block> nextQueue, World world, AtomicInteger blocksProcessed, Set<Block> leavesToRemove) {
        for (int dx = -1; dx <= 1; ++dx) {
            for (int dy = -1; dy <= 1; ++dy) {
                for (int dz = -1; dz <= 1; ++dz) {
                    Block neighbor;
                    if (dx == 0 && dy == 0 && dz == 0 || visited.contains(neighbor = world.getBlockAt(block.getX() + dx, block.getY() + dy, block.getZ() + dz)) || !LEAVES.contains(neighbor.getType())) continue;
                    visited.add(neighbor);
                    nextQueue.add(neighbor);
                    blocksProcessed.incrementAndGet();
                    leavesToRemove.add(neighbor);
                }
            }
        }
    }

    private void scheduleLeafDecay(Set<Block> leaves) {
        if (leaves.isEmpty()) {
            return;
        }
        int totalLeaves = leaves.size();
        int interval = Math.max(1, this.decayTime / totalLeaves);
        AtomicInteger index = new AtomicInteger(0);
        for (Block leaf : leaves) {
            int delay = index.getAndIncrement() * interval;
            Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
                if (leaf.getType().name().endsWith("_LEAVES")) {
                    leaf.breakNaturally();
                }
            }, (long)delay);
        }
    }

    static {
        for (Material material : Material.values()) {
            if (material.name().endsWith("_LOG")) {
                LOGS.add(material);
                continue;
            }
            if (!material.name().endsWith("_LEAVES")) continue;
            LEAVES.add(material);
        }
    }
}

