/*
 * Decompiled with CFR 0.152.
 */
package com.soystargaze.vitamin.modules.core;

import com.soystargaze.vitamin.database.DatabaseHandler;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.TNTPrimed;
import org.bukkit.entity.Tameable;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.projectiles.ProjectileSource;

public final class PetProtectionModule
implements Listener {
    @EventHandler
    public void onPetDamage(EntityDamageByEntityEvent event) {
        if (!this.isValidTameableVictim(event.getEntity())) {
            return;
        }
        Tameable tameable = (Tameable)event.getEntity();
        Player attacker = this.getAttackerFromDamager(event.getDamager());
        if (!(attacker == null || attacker.hasPermission("vitamin.module.pet_protection") && DatabaseHandler.isModuleEnabledForPlayer(attacker.getUniqueId(), "module.pet_protection"))) {
            return;
        }
        this.handlePetDamage(event, tameable, attacker);
    }

    private boolean isValidTameableVictim(Entity victim) {
        if (victim instanceof Tameable) {
            Tameable tameable = (Tameable)victim;
            return tameable.getOwner() != null;
        }
        return false;
    }

    private Player getAttackerFromDamager(Entity damager) {
        TNTPrimed tnt;
        Entity entity;
        Projectile projectile;
        ProjectileSource shooter;
        if (damager instanceof Player) {
            Player player = (Player)damager;
            return player;
        }
        if (damager instanceof Projectile && (shooter = (projectile = (Projectile)damager).getShooter()) instanceof Player) {
            Player player = (Player)shooter;
            return player;
        }
        if (damager instanceof TNTPrimed && (entity = (tnt = (TNTPrimed)damager).getSource()) instanceof Player) {
            Player player = (Player)entity;
            return player;
        }
        return null;
    }

    private void handlePetDamage(EntityDamageByEntityEvent event, Tameable tameable, Player attacker) {
        if (attacker != null && tameable.getOwner() != null && tameable.getOwner().equals((Object)attacker)) {
            event.setCancelled(true);
        }
    }
}

