/*
 * Decompiled with CFR 0.152.
 */
package com.soystargaze.vitamin.modules.core;

import com.soystargaze.vitamin.modules.core.DamageListenerEffect;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Particle;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

class RegenerationOnDamageEffect
implements DamageListenerEffect {
    private final int duration;
    private final int cooldown;
    private final double radius;
    private final Map<UUID, Long> lastAppliedMap = new HashMap<UUID, Long>();

    public RegenerationOnDamageEffect(int duration, int cooldown, double radius) {
        this.duration = duration;
        this.cooldown = cooldown;
        this.radius = radius;
    }

    @Override
    public void onDamage(EntityDamageByEntityEvent event, int stack) {
        Entity entity = event.getEntity();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            long now = System.currentTimeMillis();
            UUID uuid = player.getUniqueId();
            Long lastApplied = this.lastAppliedMap.get(uuid);
            if (lastApplied == null || now - lastApplied >= (long)this.cooldown * 1000L) {
                player.addPotionEffect(new PotionEffect(PotionEffectType.REGENERATION, this.duration * 20 * stack, 0));
                player.getWorld().spawnParticle(Particle.HEART, player.getLocation().add(0.0, 1.0, 0.0), 5 * stack, 0.5, 0.5, 0.5, 0.1);
                for (Entity nearby : player.getNearbyEntities(this.radius, this.radius, this.radius)) {
                    if (!(nearby instanceof Player)) continue;
                    Player ally = (Player)nearby;
                    ally.addPotionEffect(new PotionEffect(PotionEffectType.REGENERATION, this.duration * 20 * stack, 0));
                    ally.getWorld().spawnParticle(Particle.HEART, ally.getLocation().add(0.0, 1.0, 0.0), 5 * stack, 0.5, 0.5, 0.5, 0.1);
                    ally.getWorld().spawnParticle(Particle.SONIC_BOOM, ally.getLocation(), stack);
                }
                this.lastAppliedMap.put(uuid, now);
            }
        }
    }

    @Override
    public void apply(Player player, int stack) {
    }
}

