/*
 * Decompiled with CFR 0.152.
 */
package com.soystargaze.vitamin.modules.core;

import com.soystargaze.vitamin.database.DatabaseHandler;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Material;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.inventory.PrepareItemCraftEvent;
import org.bukkit.inventory.CraftingInventory;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.java.JavaPlugin;

public class RepairModule
implements Listener {
    private final JavaPlugin plugin;
    private final Map<UUID, Long> lastRepairTime = new HashMap<UUID, Long>();
    private static final long REPAIR_COOLDOWN_MS = 500L;

    public RepairModule(JavaPlugin plugin) {
        this.plugin = plugin;
    }

    private boolean isRepairableTool(ItemStack item) {
        if (item == null) {
            return false;
        }
        Material type = item.getType();
        return type.name().endsWith("_SWORD") || type.name().endsWith("_PICKAXE") || type.name().endsWith("_AXE") || type.name().endsWith("_SHOVEL") || type.name().endsWith("_HOE");
    }

    private Material getToolRepairMaterial(ItemStack tool) {
        Material type = tool.getType();
        if (type.name().startsWith("DIAMOND_")) {
            return Material.DIAMOND;
        }
        if (type.name().startsWith("NETHERITE_")) {
            return Material.NETHERITE_INGOT;
        }
        if (type.name().startsWith("IRON_")) {
            return Material.IRON_INGOT;
        }
        if (type.name().startsWith("GOLD_")) {
            return Material.GOLD_INGOT;
        }
        return null;
    }

    private boolean isValidRepairMaterial(ItemStack tool, Material material) {
        Material baseMaterial = this.getToolRepairMaterial(tool);
        if (material == baseMaterial) {
            return true;
        }
        if (baseMaterial == Material.IRON_INGOT && material == Material.IRON_NUGGET) {
            return true;
        }
        return baseMaterial == Material.GOLD_INGOT && material == Material.GOLD_NUGGET;
    }

    private double getRepairValuePerMaterial(Material material) {
        if (material == Material.DIAMOND) {
            return this.plugin.getConfig().getDouble("repair.diamond_value", 0.4);
        }
        if (material == Material.NETHERITE_INGOT) {
            return this.plugin.getConfig().getDouble("repair.netherite_value", 0.8);
        }
        if (material == Material.IRON_INGOT || material == Material.GOLD_INGOT) {
            return this.plugin.getConfig().getDouble("repair.ingot_value", 0.27);
        }
        if (material == Material.IRON_NUGGET || material == Material.GOLD_NUGGET) {
            return this.plugin.getConfig().getDouble("repair.nugget_value", 0.03);
        }
        return 0.0;
    }

    @EventHandler
    public void onPrepareCraft(PrepareItemCraftEvent event) {
        HumanEntity human = event.getView().getPlayer();
        if (!(human instanceof Player)) {
            return;
        }
        Player player = (Player)human;
        if (!player.hasPermission("vitamin.module.repair") || !DatabaseHandler.isModuleEnabledForPlayer(player.getUniqueId(), "module.repair")) {
            return;
        }
        CraftingInventory inv = event.getInventory();
        if (inv.getMatrix().length != 4) {
            return;
        }
        ItemStack[] matrix = inv.getMatrix();
        ItemStack tool = null;
        HashMap<Material, Integer> repairMaterials = new HashMap<Material, Integer>();
        for (ItemStack item : matrix) {
            if (item == null || item.getType() == Material.AIR) continue;
            if (this.isRepairableTool(item)) {
                if (tool != null) {
                    return;
                }
                tool = item.clone();
                continue;
            }
            if (tool == null || !this.isValidRepairMaterial(tool, item.getType())) continue;
            repairMaterials.put(item.getType(), repairMaterials.getOrDefault(item.getType(), 0) + item.getAmount());
        }
        if (tool == null || repairMaterials.isEmpty()) {
            return;
        }
        ItemMeta meta = tool.getItemMeta();
        if (!(meta instanceof Damageable)) {
            return;
        }
        Damageable damageable = (Damageable)meta;
        short maxDurability = tool.getType().getMaxDurability();
        int currentDamage = damageable.getDamage();
        if (currentDamage <= 0) {
            return;
        }
        int totalRepairAmount = 0;
        for (Map.Entry entry : repairMaterials.entrySet()) {
            double repairPerMaterial = (double)maxDurability * this.getRepairValuePerMaterial((Material)entry.getKey());
            totalRepairAmount += (int)((double)((Integer)entry.getValue()).intValue() * repairPerMaterial);
        }
        if (totalRepairAmount <= 0) {
            return;
        }
        int newDamage = Math.max(0, currentDamage - totalRepairAmount);
        damageable.setDamage(newDamage);
        tool.setItemMeta(meta);
        inv.setResult(tool);
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        long lastTime;
        Inventory inventory;
        HumanEntity humanEntity = event.getWhoClicked();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        if (event.getSlotType() != InventoryType.SlotType.RESULT || !((inventory = event.getView().getTopInventory()) instanceof CraftingInventory)) {
            return;
        }
        CraftingInventory craftingInv = (CraftingInventory)inventory;
        ItemStack result = craftingInv.getResult();
        if (result == null || !player.hasPermission("vitamin.module.repair") || !DatabaseHandler.isModuleEnabledForPlayer(player.getUniqueId(), "module.repair")) {
            return;
        }
        UUID playerUUID = player.getUniqueId();
        long currentTime = System.currentTimeMillis();
        if (this.lastRepairTime.containsKey(playerUUID) && currentTime - (lastTime = this.lastRepairTime.get(playerUUID).longValue()) < 500L) {
            return;
        }
        this.lastRepairTime.put(playerUUID, currentTime);
        ItemStack[] matrix = craftingInv.getMatrix();
        ItemStack toolToRepair = null;
        HashMap<Material, Integer> repairMaterials = new HashMap<Material, Integer>();
        for (ItemStack item : matrix) {
            if (item == null) continue;
            if (this.isRepairableTool(item)) {
                if (toolToRepair != null) {
                    return;
                }
                toolToRepair = item;
                continue;
            }
            if (toolToRepair == null || !this.isValidRepairMaterial(toolToRepair, item.getType())) continue;
            repairMaterials.put(item.getType(), repairMaterials.getOrDefault(item.getType(), 0) + item.getAmount());
        }
        if (toolToRepair == null || repairMaterials.isEmpty()) {
            return;
        }
        event.setCancelled(true);
        ItemMeta meta = toolToRepair.getItemMeta();
        if (!(meta instanceof Damageable)) {
            return;
        }
        Damageable damageable = (Damageable)meta;
        short maxDurability = toolToRepair.getType().getMaxDurability();
        int currentDamage = damageable.getDamage();
        int totalRepairAmount = 0;
        for (Map.Entry entry : repairMaterials.entrySet()) {
            double repairPerMaterial = (double)maxDurability * this.getRepairValuePerMaterial((Material)entry.getKey());
            totalRepairAmount += (int)((double)((Integer)entry.getValue()).intValue() * repairPerMaterial);
        }
        int actualRepairAmount = Math.min(totalRepairAmount, currentDamage);
        double repairRatio = actualRepairAmount > 0 ? (double)actualRepairAmount / (double)totalRepairAmount : 0.0;
        ItemStack repairedTool = toolToRepair.clone();
        ItemMeta repairedMeta = repairedTool.getItemMeta();
        if (repairedMeta instanceof Damageable) {
            Damageable repairableMeta = (Damageable)repairedMeta;
            repairableMeta.setDamage(Math.max(0, currentDamage - actualRepairAmount));
            repairedTool.setItemMeta(repairedMeta);
        }
        for (int i = 0; i < matrix.length; ++i) {
            craftingInv.setItem(i + 1, null);
        }
        player.getInventory().addItem(new ItemStack[]{repairedTool});
        if (repairRatio < 1.0) {
            for (Map.Entry entry : repairMaterials.entrySet()) {
                int remainingAmount = (int)Math.floor((double)((Integer)entry.getValue()).intValue() * (1.0 - repairRatio));
                if (remainingAmount <= 0) continue;
                ItemStack leftoverMaterials = new ItemStack((Material)entry.getKey(), remainingAmount);
                player.getInventory().addItem(new ItemStack[]{leftoverMaterials});
            }
        }
        craftingInv.setResult(null);
        player.updateInventory();
    }
}

