/*
 * Decompiled with CFR 0.152.
 */
package com.soystargaze.vitamin.modules.core;

import com.soystargaze.vitamin.database.DatabaseHandler;
import com.soystargaze.vitamin.database.ReactivationData;
import com.soystargaze.vitamin.libs.rtag.RtagBlock;
import com.soystargaze.vitamin.utils.text.TextHandler;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class ReplayableVaultModule
implements Listener {
    private final JavaPlugin plugin;

    public ReplayableVaultModule(JavaPlugin plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onPlayerInteract(PlayerInteractEvent event) {
        long lastOpeningTime;
        Material requiredKey;
        if (event.getAction() != Action.RIGHT_CLICK_BLOCK || event.getHand() != EquipmentSlot.HAND) {
            return;
        }
        Block block = event.getClickedBlock();
        if (block == null || block.getType() != Material.VAULT) {
            return;
        }
        RtagBlock editor = RtagBlock.of(block);
        Boolean isOminous = (Boolean)editor.get("server_data", "ominous");
        Material material = requiredKey = isOminous != null && isOminous != false ? Material.OMINOUS_TRIAL_KEY : Material.TRIAL_KEY;
        if (event.getPlayer().getInventory().getItemInMainHand().getType() != requiredKey) {
            return;
        }
        Player player = event.getPlayer();
        if (!player.hasPermission("vitamin.module.replayable_vault") || !DatabaseHandler.isModuleEnabledForPlayer(player.getUniqueId(), "module.replayable_vault")) {
            return;
        }
        Location vaultLoc = block.getLocation();
        UUID playerId = player.getUniqueId();
        ReactivationData data = DatabaseHandler.getReactivationData(vaultLoc, playerId);
        long currentTime = System.currentTimeMillis();
        long cooldown = this.plugin.getConfig().getLong("replayable_vault.cooldown", 3600000L);
        int maxReactivations = this.plugin.getConfig().getInt("replayable_vault.max_reactivations", 2);
        int maxOpenings = 1 + maxReactivations;
        int openingCount = data != null ? data.openingCount() : 0;
        long l = lastOpeningTime = data != null ? data.lastOpeningTime() : 0L;
        if (openingCount < maxOpenings && (openingCount == 0 || lastOpeningTime + cooldown < currentTime)) {
            this.removePlayerFromRewardedList(vaultLoc, playerId);
            Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
                int newOpeningCount = openingCount + 1;
                DatabaseHandler.saveReactivationData(vaultLoc, playerId, new ReactivationData(newOpeningCount, currentTime));
                int remainingUses = maxOpenings - newOpeningCount;
                String formattedCooldown = this.formatTime(cooldown / 1000L);
                if (newOpeningCount == 1) {
                    TextHandler.get().sendMessage(player, "replayable_vault.first_use", remainingUses, formattedCooldown);
                } else {
                    TextHandler.get().sendMessage(player, "replayable_vault.remaining_uses", remainingUses);
                }
                this.addPlayerToRewardedList(vaultLoc, playerId);
            }, 20L);
        } else {
            event.setCancelled(true);
            if (openingCount >= maxOpenings) {
                TextHandler.get().sendMessage(player, "replayable_vault.max_uses_reached", new Object[0]);
            } else {
                long timeLeft = (lastOpeningTime + cooldown - currentTime) / 1000L;
                String formattedTime = this.formatTime(timeLeft);
                TextHandler.get().sendMessage(player, "replayable_vault.cooldown", formattedTime);
            }
        }
    }

    private String formatTime(long seconds) {
        long hours = seconds / 3600L;
        long minutes = seconds % 3600L / 60L;
        long secs = seconds % 60L;
        ArrayList<CallSite> parts = new ArrayList<CallSite>();
        if (hours > 0L) {
            String hourUnit = hours == 1L ? "h" : "hr";
            parts.add((CallSite)((Object)(hours + " " + hourUnit)));
        }
        if (minutes > 0L) {
            String minuteUnit = "min";
            parts.add((CallSite)((Object)(minutes + " " + minuteUnit)));
        }
        if (secs > 0L || parts.isEmpty()) {
            String secondUnit = "s";
            parts.add((CallSite)((Object)(secs + " " + secondUnit)));
        }
        if (parts.size() == 1) {
            return (String)parts.getFirst();
        }
        if (parts.size() == 2) {
            return (String)parts.get(0) + " " + (String)parts.get(1);
        }
        return String.join((CharSequence)", ", parts.subList(0, parts.size() - 1)) + ", " + (String)parts.getLast();
    }

    private void removePlayerFromRewardedList(Location vaultLoc, UUID playerId) {
        Block block = vaultLoc.getBlock();
        if (block.getType() != Material.VAULT) {
            return;
        }
        RtagBlock editor = RtagBlock.of(block);
        List rewardedPlayers = (List)editor.get("server_data", "rewarded_players");
        if (rewardedPlayers != null && rewardedPlayers.remove(playerId.toString())) {
            editor.set(rewardedPlayers, "server_data", "rewarded_players");
            editor.load();
        }
    }

    private void addPlayerToRewardedList(Location vaultLoc, UUID playerId) {
        Block block = vaultLoc.getBlock();
        if (block.getType() != Material.VAULT) {
            return;
        }
        RtagBlock editor = RtagBlock.of(block);
        ArrayList<String> rewardedPlayers = (ArrayList<String>)editor.get("server_data", "rewarded_players");
        if (rewardedPlayers == null) {
            rewardedPlayers = new ArrayList<String>();
        }
        if (!rewardedPlayers.contains(playerId.toString())) {
            rewardedPlayers.add(playerId.toString());
            editor.set(rewardedPlayers, "server_data", "rewarded_players");
            editor.load();
        }
    }
}

