/*
 * Decompiled with CFR 0.152.
 */
package com.soystargaze.vitamin.modules.core;

import com.soystargaze.vitamin.modules.core.SneakListenerEffect;
import org.bukkit.Particle;
import org.bukkit.entity.Player;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

class SpeedOnSneakEffect
implements SneakListenerEffect {
    private final double speedBoost;
    private final int duration;

    public SpeedOnSneakEffect(double speedBoost, int duration) {
        this.speedBoost = speedBoost;
        this.duration = duration;
    }

    @Override
    public void onSneak(Player player, int stack, boolean isSneaking) {
        if (isSneaking) {
            int amplifier = (int)(this.speedBoost * (double)stack * 10.0);
            player.addPotionEffect(new PotionEffect(PotionEffectType.SPEED, this.duration * 20, amplifier));
            player.getWorld().spawnParticle(Particle.SMOKE, player.getLocation(), 10 * stack, 0.5, 0.5, 0.5, 0.1);
        }
    }

    @Override
    public void apply(Player player, int stack) {
    }
}

