/*
 * Decompiled with CFR 0.152.
 */
package com.soystargaze.vitamin.modules.core;

import com.soystargaze.vitamin.database.DatabaseHandler;
import com.soystargaze.vitamin.utils.text.TextHandler;
import com.soystargaze.vitamin.utils.text.legacy.LegacyTranslationHandler;
import java.util.HashMap;
import java.util.Map;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class TpToBedModule
implements Listener {
    private final Plugin plugin;
    private final Map<Player, BukkitRunnable> teleportDelays = new HashMap<Player, BukkitRunnable>();
    private final Map<Player, Long> lastTeleportTime = new HashMap<Player, Long>();
    private final Map<Player, Long> lastMessageSent = new HashMap<Player, Long>();
    private static final long MESSAGE_COOLDOWN_MS = 2000L;
    private final Map<Player, Long> lastInteract = new HashMap<Player, Long>();
    private static final long INTERACT_COOLDOWN_MS = 300L;

    public TpToBedModule(Plugin plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onPlayerInteract(PlayerInteractEvent event) {
        long lastClick;
        if (event.getHand() != EquipmentSlot.HAND) {
            return;
        }
        Player player = event.getPlayer();
        if (!player.hasPermission("vitamin.module.tp_compass") || !DatabaseHandler.isModuleEnabledForPlayer(player.getUniqueId(), "module.tp_to_bed_with_compass")) {
            return;
        }
        long now = System.currentTimeMillis();
        if (now - (lastClick = this.lastInteract.getOrDefault(player, 0L).longValue()) < 300L) {
            return;
        }
        this.lastInteract.put(player, now);
        Action action = event.getAction();
        if (action != Action.RIGHT_CLICK_AIR && action != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        ItemStack item = event.getItem();
        if (item == null || item.getType() != Material.COMPASS) {
            return;
        }
        long cooldownTime = this.plugin.getConfig().getLong("tp_with_compass.cooldown_time", 0L) * 1000L;
        long lastTp = this.lastTeleportTime.getOrDefault(player, 0L);
        if (now - lastTp < cooldownTime) {
            long timeLeft = (cooldownTime - (now - lastTp)) / 1000L;
            this.sendMessageWithCooldown(player, "tpcompass.cooldown", timeLeft);
            return;
        }
        Location bedSpawn = player.getRespawnLocation();
        if (this.teleportDelays.containsKey(player)) {
            this.sendMessageWithCooldown(player, "tpcompass.already_teleporting", new Object[0]);
            return;
        }
        if (bedSpawn == null) {
            this.sendMessageWithCooldown(player, "tpcompass.no_bed", new Object[0]);
            return;
        }
        Location startLocation = player.getLocation();
        boolean requireStationary = this.plugin.getConfig().getBoolean("tp_with_compass.require_stationary", true);
        BukkitRunnable task = this.createTeleportTask(player, startLocation, bedSpawn, requireStationary);
        task.runTaskTimer(this.plugin, 0L, 1L);
        this.teleportDelays.put(player, task);
    }

    private BukkitRunnable createTeleportTask(final Player player, final Location startLocation, final Location bedSpawn, final boolean requireStationary) {
        return new BukkitRunnable(){
            int ticks = 0;
            final int channelingTime;
            {
                this.channelingTime = TpToBedModule.this.plugin.getConfig().getInt("tp_with_compass.channeling_time", 3) * 20;
            }

            public void run() {
                int secondsLeft;
                Location currentLocation = player.getLocation();
                if (requireStationary && TpToBedModule.this.movedFromStart(currentLocation, startLocation)) {
                    TpToBedModule.this.sendMessageWithCooldown(player, "tpcompass.cancelled", new Object[0]);
                    TpToBedModule.this.teleportDelays.remove(player);
                    this.cancel();
                    return;
                }
                player.getWorld().spawnParticle(Particle.SONIC_BOOM, currentLocation, 1, 1.0, 1.0, 1.0, 0.0);
                if (this.ticks % 20 == 0 && (secondsLeft = (this.channelingTime - this.ticks) / 20) > 0) {
                    Component messageComponent = LegacyTranslationHandler.getPlayerMessage("tpcompass.channeling", secondsLeft);
                    String message = LegacyComponentSerializer.legacyAmpersand().serialize(messageComponent);
                    player.spigot().sendMessage(ChatMessageType.ACTION_BAR, (BaseComponent)new TextComponent(ChatColor.translateAlternateColorCodes((char)'&', (String)message)));
                }
                ++this.ticks;
                if (this.ticks >= this.channelingTime) {
                    player.getWorld().playSound(player.getLocation(), "entity.enderman.teleport", 1.0f, 1.0f);
                    player.teleport(bedSpawn);
                    TpToBedModule.this.sendMessageWithCooldown(player, "tpcompass.success", new Object[0]);
                    TpToBedModule.this.lastTeleportTime.put(player, System.currentTimeMillis());
                    TpToBedModule.this.teleportDelays.remove(player);
                    this.cancel();
                }
            }
        };
    }

    private boolean movedFromStart(Location current, Location start) {
        return current.getBlockX() != start.getBlockX() || current.getBlockY() != start.getBlockY() || current.getBlockZ() != start.getBlockZ();
    }

    private void sendMessageWithCooldown(Player player, String messageKey, Object ... args) {
        long lastSent;
        long now = System.currentTimeMillis();
        if (now - (lastSent = this.lastMessageSent.getOrDefault(player, 0L).longValue()) >= 2000L) {
            TextHandler.get().sendMessage(player, messageKey, args);
            this.lastMessageSent.put(player, now);
        }
    }
}

